#!/bin/bash

echo "----------------------------------------"
echo "APEX AIRPLAY CONFIGURATION SCRIPT"
echo "----------------------------------------"
# sudo apt install shairport-sync
# usage sudo bash apexairplay.sh
# Hendrik-Jan Gielis @ Giva Audiovisual Technologies BV 2020

helpFunction()
{
        echo ""
        echo "Usage example: sudo bash apexairplay.sh --service enable --name friendlyname  --pass pass"
        echo "  -- service: -enable -disable"
        echo "  -- name: friendly name which shows up on airplay compatible devices"
        echo "  -- pass: optional airplay password"
}

while [ $# -gt 0 ]; do
  case "$1" in
    --service*)
      if [[ "$1" != *=* ]]; then shift; fi # Value is next arg if no `=`
      service_state="${1#*=}"
      ;;
    --name*)
      if [[ "$1" != *=* ]]; then shift; fi
      friendlyname="${1#*=}"
      ;;
    --pass*)
      if [[ "$1" != *=* ]]; then shift; fi
      password="${1#*=}"
      ;;
    --help|-h)
      helpFunction
      exit 0
      ;;
    *)
      >&2 printf "Error: Invalid argument\n"
      exit 1
      ;;
  esac
  shift
done

# Print helpFunction in case parameters are empty
if [ -z "$service_state" ] ; then
        echo "There is no service_state argument!";
        helpFunction;
        exit 1
fi


update_configuration_start()
{
        echo "writing /etc/shairport-sync.conf..."
	if [ -z "$password" ] ; then
        (echo "# This file was updated by apexairplay.sh" ; echo "general = {" ;  echo "name = \"$friendlyname\" ;" ; echo "};") > /etc/shairport-sync.conf
	else
	(echo "# This file was updated by apexairplay.sh" ; echo "general = {" ;  echo "name = \"$friendlyname\" ;" ; echo "password = \"$password\" ;" ; echo "};")  > /etc/shairport-sync.conf
	fi
}

update_configuration_stop()
{
        echo "Writing /etc/shairport-sync.conf..."
        (echo "# This file was updated by apexairplay.sh" ; echo "abort_not_configured") > /etc/shairport-sync.conf
}



##### Stop the service
if [ "$service_state" = disable ]  ; then
        echo "Clear config files..."
        update_configuration_stop
        echo "Reloading config files..."
        service shairport-sync force reload
        echo "Stopping service..."
        systemctl stop shairport-sync
        echo "Disabling service..."
        systemctl disable shairport-sync
        sleep 1
        echo "Checking service status..."
        systemctl is-active shairport-sync
fi

##### Start the service and update configuration
if [ "$service_state" = enable ]  ; then
        if [ -z "$friendlyname" ] ; then
                echo "Not all arguments are set!";
                helpFunction;
                exit 1
        else
                echo "Update config files..."
                update_configuration_start
                echo "Reloading config files..."
                service shairport-sync force-reload
                echo "Starting service..."
                systemctl start shairport-sync
                echo "Enabling systemd service..."
                systemctl enable shairport-sync
                sleep 1
                echo "Checking service status..."
                systemctl is-active shairport-sync
        fi
fi

echo "----------------------------------------"

