#!/bin/bash

echo "----------------------------------------"
echo "APEX CONNECT CLIENT CONFIGURATION SCRIPT"
echo "----------------------------------------"
# apt install pagekite
# usage sudo bash apexconnect.sh
# Hendrik-Jan Gielis @ Giva Audiovisual Technologies BV 2020

helpFunction()
{
   	echo ""
   	echo "Usage example: sudo bash apexconnect.sh --service enable --relay apexconnect.me --name amplifier1 --secret serversectret --ssh no --user admin --pass pass"
   	echo "	-- service: enable or disable"
   	echo "	-- relay: relayserver DNS"
   	echo "	-- name: sub domain name"
	echo "	-- sectret: sectret between client<->relay server"
   	echo "	-- ssh: yes or no"
   	echo "	-- user: username"
   	echo "	-- pass: password"
}

while [ $# -gt 0 ]; do
  case "$1" in
    --service*)
      if [[ "$1" != *=* ]]; then shift; fi # Value is next arg if no `=`
      service_state="${1#*=}"
      ;;
    --relay*)
      if [[ "$1" != *=* ]]; then shift; fi
      relay_server="${1#*=}"
      ;;
    --name*)
      if [[ "$1" != *=* ]]; then shift; fi
      sub_domain="${1#*=}"
      ;;
    --secret*)
      if [[ "$1" != *=* ]]; then shift; fi
      kitesectret="${1#*=}"
      ;;
    --ssh*)
      if [[ "$1" != *=* ]]; then shift; fi
      SSH="${1#*=}"
      ;;
    --user*)
      if [[ "$1" != *=* ]]; then shift; fi
      username="${1#*=}"
      ;;
    --pass*)
      if [[ "$1" != *=* ]]; then shift; fi
      password="${1#*=}"
      ;;
    --help|-h)
      helpFunction
      exit 0
      ;;
    *)
      >&2 printf "Error: Invalid argument\n"
      exit 1
      ;;
  esac
  shift
done

#get Ethernet MAC and store it in a file
cat /sys/class/net/eth0/address | tr -d ':' > /etc/device_id

if [ -z "$service_state" ] ; then
   	echo "There is no service_state argument!";
   	helpFunction;
	exit 1
fi


update_configuration_start()
{
	if [ -z "$sub_domain" ] ; then
	echo "No name specified, using Eth0 MAC address as sub_domain..." 
	sub_domain=`cat /etc/device_id`
	fi
	echo "writing /etc/pagekite.d/10_account.rc..."
        (echo "# This file was updated by apexconnect.sh" ; echo "kitename = $sub_domain.$relay_server" ; echo "kitesecret = $kitesectret") > /etc/pagekite.d/10_account.rc

        echo "writing /etc/pagekite.d/80_httpd.rc..."
	if [ -z "$username" ] || [ -z "$password" ] ; then
	(echo "# This file was updated by apexconnect.sh" ; echo "service_on = http:@kitename : localhost:80 : @kitesecret" ; echo "service_on = websocket:@kitename : localhost:5678 : @kitesecret") > /etc/pagekite.d/80_httpd.rc
	else
	(echo "# This file was updated by apexconnect.sh" ; echo "service_on = http:@kitename : localhost:80 : @kitesecret" ; echo "service_on = websocket:@kitename : localhost:5678 : @kitesecret" ; echo "service_cfg = $sub_domain.$relay_server/80 : password/$username:$password") > /etc/pagekite.d/80_httpd.rc
	echo "$username" > /var/www/html/id.txt
	echo "$password" >> /var/www/html/id.txt
	fi

        echo "writing /etc/pagekite.d/20_frontends.rc..."
        (echo "# This file was updated by apexconnect.sh" ; echo "frontend = www.$relay_server:80") > /etc/pagekite.d/20_frontends.rc

	echo "writing /etc/pagekite.d/80_sshd.rc..."
	if [ $SSH = "no" ] ; then 
	(echo "# This file was updated by apexconnect.sh") > /etc/pagekite.d/80_sshd.rc
	elif [ $SSH = "yes" ] ; then 
	(echo "# This file was updated by apexconnect.sh" ; echo "backend = raw/22:@kitename : localhost:22 : @kitesecret") > /etc/pagekite.d/80_sshd.rc
	fi
}

update_configuration_stop()
{
        echo "Writing /etc/pagekite.d/10_account.rc..."
	(echo "# This file was updated by apexconnect.sh" ; echo "abort_not_configured") > /etc/pagekite.d/10_account.rc
}



##### Stop the service
if [ "$service_state" = disable ]  ; then
	echo "Clear config files..."
	update_configuration_stop
	echo "Reloading config files..."
	service pagekite force reload
	echo "Stopping service..."
	systemctl stop pagekite
	echo "Disabling service..."
	systemctl disable pagekite
	sleep 1
	echo "Checking service status..."
	systemctl is-active pagekite
fi

##### Start the service and update configuration
if [ "$service_state" = enable ]  ; then
	if [ -z "$relay_server" ] || [ -z "$kitesectret" ] || [ -z "$SSH" ] ; then
   		echo "Not all arguments are set!";
   		helpFunction;
		exit 1
	else
		echo "Update config files..."
		update_configuration_start
		echo "Reloading config files..."
		service pagekite force-reload
		echo "Starting service..."
		systemctl start pagekite
		echo "Enabling systemd service..."
		systemctl enable pagekite
		sleep 1
		echo "Checking service status..."
		systemctl is-active pagekite
	fi
fi

echo "----------------------------------------"
# Create the device id
# cat /sys/class/net/wlan0/address | tr -d ':' > /etc/device_id

# Define the variables from config
# ssh_remote_server=`cat /etc/et-phone-home-ssh-server`
# device_id=`cat /etc/device_id`

# chmod +x /home/orangepi/et-phone-home.sh


# service_on = localhost:22 ssh://amplifier1.apexconnect.me

