#!/bin/bash

echo "----------------------------------------"
echo "APEX SPOTIFY CONNECT CONFIGURATION SCRIPT"
echo "----------------------------------------"
# sudo curl -sL https://dtcooper.github.io/raspotify/install.sh | sh
# usage sudo bash apexspotify.sh
# Hendrik-Jan Gielis @ Giva Audiovisual Technologies BV 2020

helpFunction()
{
        echo ""
        echo "Usage example: sudo bash apexspotify.sh --service enable --name friendlyname --quality 160 --user admin --pass pass"
        echo "  -- service: -enable -disable"
        echo "  -- name: friendly name which shows up in spotify"
        echo "  -- quality: 96 / 160 / 320"
        echo "  -- user: optional spotify username"
        echo "  -- pass: optional spotifu password"
}

while [ $# -gt 0 ]; do
  case "$1" in
    --service*)
      if [[ "$1" != *=* ]]; then shift; fi # Value is next arg if no `=`
      service_state="${1#*=}"
      ;;
    --name*)
      if [[ "$1" != *=* ]]; then shift; fi
      friendlyname="${1#*=}"
      ;;
    --quality*)
      if [[ "$1" != *=* ]]; then shift; fi
      streamquality="${1#*=}"
      ;;
    --user*)
      if [[ "$1" != *=* ]]; then shift; fi
      username="${1#*=}"
      ;;
    --pass*)
      if [[ "$1" != *=* ]]; then shift; fi
      password="${1#*=}"
      ;;
    --help|-h)
      helpFunction
      exit 0
      ;;
    *)
      >&2 printf "Error: Invalid argument\n"
      exit 1
      ;;
  esac
  shift
done

# Print helpFunction in case parameters are empty
if [ -z "$service_state" ] ; then
        echo "There is no service_state argument!";
        helpFunction;
        exit 1
fi


update_configuration_start()
{
        echo "writing /etc/default/raspotify..."
	if [ -z "$username" ] || [ -z "$password" ] ; then
        (echo "# This file was updated by apexspotify.sh" ; echo "DEVICE_NAME="$friendlyname"" ; echo "BITRATE="$streamquality""; echo "VOLUME_ARGS=\"--enable-volume-normalisation --volume-ctrl linear --initial-volume=10\"") > /etc/default/raspotify
	else
	(echo "# This file was updated by apexspotify.sh" ; echo "DEVICE_NAME="$friendlyname"" ; echo "BITRATE="$streamquality"" ; echo "OPTIONS=\"--username "$username" --password "$password" --disable-discovery\"" ; echo "VOLUME_ARGS=\"--enable-volume-normalisation --volume-ctrl linear --initial-volume=10\"") > /etc/default/raspotify
	fi
}

update_configuration_stop()
{
        echo "Writing /etc/default/raspotify..."
        (echo "# This file was updated by apexspotify.sh" ; echo "abort_not_configured") > /etc/default/raspotify
}



##### Stop the service
if [ "$service_state" = disable ]  ; then
        echo "Clear config files..."
        update_configuration_stop
        echo "Reloading config files..."
        service raspotify force reload
        echo "Stopping service..."
        systemctl stop raspotify
        echo "Disabling service..."
        systemctl disable raspotify
        sleep 1
        echo "Checking service status..."
        systemctl is-active raspotify
fi

##### Start the service and update configuration
if [ "$service_state" = enable ]  ; then
        if [ -z "$friendlyname" ] || [ -z "$streamquality" ] ; then
                echo "Not all arguments are set!";
                helpFunction;
                exit 1
        else
                echo "Update config files..."
                update_configuration_start
                echo "Reloading config files..."
                service raspotify force-reload
                echo "Starting service..."
                systemctl start raspotify
                echo "Enabling systemd service..."
                systemctl enable raspotify
                sleep 1
                echo "Checking service status..."
                systemctl is-active raspotify
        fi
fi

echo "----------------------------------------"

