from common import DSP_VARIANT_FILE

file = open(DSP_VARIANT_FILE, "r")
about_string = str(file.read()).split(" ")
CURRENT_VARIANT_VALUE = about_string[0]
file.close()




if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    NUM_OF_CHANNELS = 16
else:
    NUM_OF_CHANNELS = 4

NORMAL = True
MUTED = False

DHCP_NETWORK_MODE = 0
STATIC_NETWORK_MODE = 1
NETWORK_MODES = [DHCP_NETWORK_MODE, STATIC_NETWORK_MODE]

# NUM_OF_CHANNELS = 16
NUM_OF_ANALOG = 4
NUM_OF_DIGITAL = 4
NUM_OF_STREAM = 2
NUM_OF_GEN = 2
NUM_OF_INPUTS = 12

NUM_OF_MODULES = 4

CLEANUP_TIME = 15.0  # after 5s, selection on home page will be cleaned
READBACK_TIME = 0.1  # on every 0.1s new readback date is read

SCREEN_DIM_INTENSITY = 100 # percentage of dimming on the screen (in %)
SCREEN_DIM_MAX = 255 # max dimming value of screen (in %)
SCREEN_DIM_TIME = 10.0 # delay for dimming the screen (in seconds)

MIN_DELAY = float(0.0)
MAX_DELAY = float(250.0)
DELAY_STEP = float(0.1)
DELAY_STEP_100 = float(1.0)

MIN_GAIN = float(-80.0)
MAX_GAIN = float(15.0)
# GAIN_STEP = float(0.1)
GAIN_STEP = float(1)
MIXER_GAIN_STEP = float(1.0)
MIXER_MAX_GAIN = float(15)

SIGGEN_GAIN_MIN = float(-50.0)
SIGGEN_GAIN_MAX = float(-20.0)
SIGGEN_GAIN_STEP = float(0.5)

SIGPN_GAIN_MIN = float(-50.0)
SIGPN_GAIN_MAX = float(-10.0)
SIGPN_GAIN_STEP = float(0.5)

LIMITER_TYPE_MIN = int(0)
LIMITER_TYPE_MAX = int(5)
LIMITER_TYPE_STEP = int(1)

LIMITER_RMS_THRES_M0_MIN = float(10)
LIMITER_RMS_THRES_M0_MAX = float(65)
LIMITER_RMS_THRES_M0_STEP = float(0.1)

LIMITER_RMS_THRES_M1_MIN = float(10)
LIMITER_RMS_THRES_M1_MAX = float(65)
LIMITER_RMS_THRES_M1_STEP = float(0.1)

LIMITER_RMS_ATTACK_MIN = float(0.1)
LIMITER_RMS_ATTACK_MAX = float(100)
LIMITER_RMS_ATTACK_STEP = float(0.1)

LIMITER_RMS_RELEASE_MIN = float(5)
LIMITER_RMS_RELEASE_MAX = float(500)
LIMITER_RMS_RELEASE_STEP = float(0.1)

LIMITER_PEAK_THRES_M0_MIN = float(10)
LIMITER_PEAK_THRES_M0_MAX = float(90)
LIMITER_PEAK_THRES_M0_STEP = float(0.1)

LIMITER_PEAK_THRES_M1_MIN = float(10)
LIMITER_PEAK_THRES_M1_MAX = float(90)
LIMITER_PEAK_THRES_M1_STEP = float(0.1)

LIMITER_PEAK_RELEASE_MIN = float(5)
LIMITER_PEAK_RELEASE_MAX = float(500)
LIMITER_PEAK_RELEASE_STEP = float(0.1)

XOVER_TYPE_MIN = int(0)
XOVER_TYPE_MAX = int(18)
XOVER_TYPE_STEP = int(1)

XOVER_FREQ_MIN = float(10)
XOVER_FREQ_MAX = float(22000)
XOVER_FREQ_STEP = float(1)

PEQ_COUNT = 12

PEQ_INDEX_MIN = int(0)
PEQ_INDEX_MAX = int(11)
PEQ_INDEX_STEP = int(1)

PEQ_TYPE_MIN = int(0)
PEQ_TYPE_MAX = int(15)
PEQ_TYPE_STEP = int(1)

PEQ_FREQ_MIN = float(10)
PEQ_FREQ_MAX = float(22000)
PEQ_FREQ_STEP = float(1)

PEQ_GAIN_MIN = float(-40.0)
PEQ_GAIN_MAX = float(15.0)
PEQ_GAIN_STEP = float(0.1)

PEQ_Q_MIN = float(0.1)
PEQ_Q_MAX = float(48.0)
PEQ_Q_STEP = float(0.1)

CHANNEL_NAME = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P"]
AUDIO_SOURCE = ["Analog 1", "Analog 2", "Analog 3", "Analog 4", "Network 1", "Network 2", "Network 3", "Network 4", "stream L", "stream R", "Freq Gen", "Pink Ns"]
MAX_SOURCE = len(AUDIO_SOURCE) - 1
MIN_SOURCE = 0

MIN_IP_ADDRESS = 0
MAX_IP_ADDRESS = 255
IP_ADDRESS_STEP = 1

IPC_BOARD_REV = 1   # Command-line argument "--ipc-board-rev=X" overrides this
IPC_BOARD_GPIO_DISPCMD = 0
IPC_BOARD_GPIO_DISPRST = 0
IPC_BOARD_GPIO_ENCA = 0
IPC_BOARD_GPIO_ENCB = 0
IPC_BOARD_GPIO_ENCSW = 0

# Prototype board GPIOs
IPC_BOARD_REV0_GPIO_DISPCMD = 3
IPC_BOARD_REV0_GPIO_DISPRST = 7
IPC_BOARD_REV0_GPIO_ENCA = 8
IPC_BOARD_REV0_GPIO_ENCB = 10
IPC_BOARD_REV0_GPIO_ENCSW = 12

# Production board GPIOs
IPC_BOARD_REV1_GPIO_DISPCMD = 11
IPC_BOARD_REV1_GPIO_DISPRST = 13
IPC_BOARD_REV1_GPIO_ENCA = 12
IPC_BOARD_REV1_GPIO_ENCB = 26
IPC_BOARD_REV1_GPIO_ENCSW = 7

SCREEN_HOME_PAGE_ID = 1
SCREEN_HOME_MENU_ID = 2
SCREEN_MENU_AUDIO_ID = 3
SCREEN_MENU_PRESETS_ID = 4
SCREEN_MENU_HOTSPOT_ID = 5
SCREEN_MENU_CLOUD_ID = 6
SCREEN_MENU_NETWORK_ID = 7
SCREEN_MENU_ABOUT_ID = 8
SCREEN_MENU_AUDIO_DELAY_ID = 9
SCREEN_MENU_AUDIO_GAIN_ID = 10
SCREEN_MENU_AUDIO_SOURCE_ID = 11
SCREEN_FOLDERS_GLOBAL_PRESETS_ID = 12
SCREEN_FILES_GLOBAL_PRESETS_ID = 13
SCREEN_FOLDERS_SPEAKER_PRESETS_ID = 14
SCREEN_FILES_SPEAKER_PRESETS_ID = 15
SCREEN_CHANNEL_CHOICE_SPEAKER_PRESET_ID = 16
SCREEN_CHANNEL_APPLY_CHANGE_ID = 17
SCREEN_MENU_AUDIO_PEQ_ID = 18
SCREEN_MENU_AUDIO_PEQ_EDIT_ID = 19
SCREEN_MENU_AUDIO_XOVER_ID = 20
SCREEN_MENU_AUDIO_XOVER_EDIT_ID = 21
SCREEN_MENU_AUDIO_LIMITER_ID = 22
SCREEN_MENU_AUDIO_LIMITER_EDIT_ID = 23
SCREEN_MENU_AUDIO_SIGGEN_ID = 24
SCREEN_MENU_AUDIO_SOURCE_EDIT_ID = 25
SCREEN_LOCATE = 98
SCREEN_FRONT_LOCK = 99
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_HOME = 17
    HOME_SCREEN_CHANNEL_0_ID = 0
    HOME_SCREEN_CHANNEL_1_ID = 1
    HOME_SCREEN_CHANNEL_2_ID = 2
    HOME_SCREEN_CHANNEL_3_ID = 3
    HOME_SCREEN_CHANNEL_4_ID = 4
    HOME_SCREEN_CHANNEL_5_ID = 5
    HOME_SCREEN_CHANNEL_6_ID = 6
    HOME_SCREEN_CHANNEL_7_ID = 7
    HOME_SCREEN_CHANNEL_8_ID = 8
    HOME_SCREEN_CHANNEL_9_ID = 9
    HOME_SCREEN_CHANNEL_10_ID = 10
    HOME_SCREEN_CHANNEL_11_ID = 11
    HOME_SCREEN_CHANNEL_12_ID = 12
    HOME_SCREEN_CHANNEL_13_ID = 13
    HOME_SCREEN_CHANNEL_14_ID = 14
    HOME_SCREEN_CHANNEL_15_ID = 15
    HOME_SCREEN_SETUP_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_HOME = 4
    HOME_SCREEN_MENU_PRESET_ID = 0
    HOME_SCREEN_MENU_IP_ID = 1
    HOME_SCREEN_MENU_GAIN_ID = 2
    HOME_SCREEN_SETUP_ID = 3
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    MAX_SELECTION_HOME = 4
    HOME_SCREEN_CHANNEL_0_ID = 0
    HOME_SCREEN_CHANNEL_1_ID = 1
    HOME_SCREEN_CHANNEL_2_ID = 2
    HOME_SCREEN_SETUP_ID = 3
else :
    MAX_SELECTION_HOME = 5
    HOME_SCREEN_CHANNEL_0_ID = 0
    HOME_SCREEN_CHANNEL_1_ID = 1
    HOME_SCREEN_CHANNEL_2_ID = 2
    HOME_SCREEN_CHANNEL_3_ID = 3
    HOME_SCREEN_SETUP_ID = 4
#######################################################################################################################
MAX_SELECTION_MENU = 7
MENU_SCREEN_AUDIO_ID = 0
MENU_SCREEN_PRESETS_ID = 1
MENU_SCREEN_HOTSPOT_ID = 2
MENU_SCREEN_CLOUD_ID = 3
MENU_SCREEN_NETWORK_ID = 4
MENU_SCREEN_ABOUT_ID = 5
MENU_SCREEN_BACK_ID = 6
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO = 8
    MENU_AUDIO_SCREEN_SOURCE_ID = 0
    MENU_AUDIO_SCREEN_GAIN_ID = 1
    MENU_AUDIO_SCREEN_DELAY_ID = 2
    MENU_AUDIO_SCREEN_PEQ_ID = 3
    MENU_AUDIO_SCREEN_XOVER_ID = 4
    MENU_AUDIO_SCREEN_LIMITER_ID = 5
    MENU_AUDIO_SCREEN_SIGGEN_ID = 6
    MENU_AUDIO_SCREEN_BACK_ID = 7
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO = 5
    MENU_AUDIO_SCREEN_SOURCE_ID = 0
    MENU_AUDIO_SCREEN_GAIN_ID = 1
    MENU_AUDIO_SCREEN_DELAY_ID = 2
    MENU_AUDIO_SCREEN_SIGGEN_ID = 3
    MENU_AUDIO_SCREEN_BACK_ID = 4

    MENU_AUDIO_SCREEN_PEQ_ID = 8
    MENU_AUDIO_SCREEN_XOVER_ID = 9
    MENU_AUDIO_SCREEN_LIMITER_ID = 10
else:
    MAX_SELECTION_MENU_AUDIO = 8
    MENU_AUDIO_SCREEN_SOURCE_ID = 0
    MENU_AUDIO_SCREEN_GAIN_ID = 1
    MENU_AUDIO_SCREEN_DELAY_ID = 2
    MENU_AUDIO_SCREEN_PEQ_ID = 3
    MENU_AUDIO_SCREEN_XOVER_ID = 4
    MENU_AUDIO_SCREEN_LIMITER_ID = 5
    MENU_AUDIO_SCREEN_SIGGEN_ID = 6
    MENU_AUDIO_SCREEN_BACK_ID = 7
#######################################################################################################################
MAX_SELECTION_MENU_PRESETS = 3
MENU_PRESETS_SCREEN_GLOBAL_ID = 0
MENU_PRESETS_SCREEN_SPEAKER_ID = 1
MENU_PRESETS_SCREEN_BACK_ID = 2
#######################################################################################################################
MAX_SELECTION_MENU_HOTSPOT = 2
HOTSPOT_SCREEN_ON_OFF_ID = 0
HOTSPOT_SCREEN_BACK_ID = 1
#######################################################################################################################
MAX_SELECTION_MENU_CLOUD = 2
CLOUD_SCREEN_ON_OFF_ID = 0
CLOUD_SCREEN_BACK_ID = 1
#######################################################################################################################
MAX_SELECTION_NETWORK = 14
NETWORK_SCREEN_MODE_ID = 0
NETWORK_SCREEN_IP_0_ID = 1
NETWORK_SCREEN_IP_1_ID = 2
NETWORK_SCREEN_IP_2_ID = 3
NETWORK_SCREEN_IP_3_ID = 4
NETWORK_SCREEN_SUBNET_0_ID = 5
NETWORK_SCREEN_SUBNET_1_ID = 6
NETWORK_SCREEN_SUBNET_2_ID = 7
NETWORK_SCREEN_SUBNET_3_ID = 8
NETWORK_SCREEN_GW_0_ID = 9
NETWORK_SCREEN_GW_1_ID = 10
NETWORK_SCREEN_GW_2_ID = 11
NETWORK_SCREEN_GW_3_ID = 12
NETWORK_SCREEN_BACK_ID = 13
#######################################################################################################################
MAX_SELECTION_ABOUT = 1
ABOUT_SCREEN_BACK_POSITION = 0
#######################################################################################################################
MAX_SELECTION_MENU_AUDIO_FREQ_GEN = 4
MENU_AUDIO_SIGGEN_SCREEN_FREQ_FREQ_ID = 0
MENU_AUDIO_SIGGEN_SCREEN_FREQ_GAIN_ID = 1
MENU_AUDIO_SIGGEN_SCREEN_PINK_GAIN_ID = 2
MENU_AUDIO_SIGGEN_SCREEN_BACK_ID = 3
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO_LIMITER = 17
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_4_ID = 4
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_5_ID = 5
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_6_ID = 6
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_7_ID = 7
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_8_ID = 8
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_9_ID = 9
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_10_ID = 10
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_11_ID = 11
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_12_ID = 12
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_13_ID = 13
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_14_ID = 14
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_15_ID = 15
    MENU_AUDIO_LIMITER_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO_LIMITER = 5
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_LIMITER_SCREEN_BACK_ID = 4
else:
    MAX_SELECTION_MENU_AUDIO_LIMITER = 5
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_LIMITER_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_LIMITER_SCREEN_BACK_ID = 4
#######################################################################################################################
MAX_SELECTION_MENU_AUDIO_LIMITER_EDIT = 7
MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_MODE_ID = 0
MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_THRES_ID = 1
MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_ATTACK_ID = 2
MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_RELEASE_ID = 3
MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_THRES_ID = 4
MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_REL_ID = 5
MENU_AUDIO_LIMITER_EDIT_SCREEN_BACK_ID = 6
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO_XOVER = 17
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_4_ID = 4
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_5_ID = 5
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_6_ID = 6
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_7_ID = 7
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_8_ID = 8
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_9_ID = 9
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_10_ID = 10
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_11_ID = 11
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_12_ID = 12
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_13_ID = 13
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_14_ID = 14
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_15_ID = 15
    MENU_AUDIO_XOVER_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO_XOVER = 5
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_XOVER_SCREEN_BACK_ID = 4
else:
    MAX_SELECTION_MENU_AUDIO_XOVER = 5
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_XOVER_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_XOVER_SCREEN_BACK_ID = 4
#######################################################################################################################
MAX_SELECTION_MENU_AUDIO_XOVER_EDIT = 5
MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_INDEX_ID = 0
MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_ENABLE_ID = 1
MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_TYPE_ID = 2
MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_FREQ_ID = 3
MENU_AUDIO_XOVER_EDIT_SCREEN_BACK_ID = 4
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO_PEQ = 17
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_4_ID = 4
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_5_ID = 5
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_6_ID = 6
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_7_ID = 7
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_8_ID = 8
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_9_ID = 9
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_10_ID = 10
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_11_ID = 11
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_12_ID = 12
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_13_ID = 13
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_14_ID = 14
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_15_ID = 15
    MENU_AUDIO_PEQ_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO_PEQ = 5
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_PEQ_SCREEN_BACK_ID = 4
else:
    MAX_SELECTION_MENU_AUDIO_PEQ = 5
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_PEQ_SCREEN_BACK_ID = 4
#######################################################################################################################
MAX_SELECTION_MENU_AUDIO_PEQ_EDIT = 7
MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID = 0
MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_ENABLE_ID = 1
MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_TYPE_ID = 2
MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_FREQ_ID = 3
MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_GAIN_ID = 4
MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_Q_ID = 5
MENU_AUDIO_PEQ_EDIT_SCREEN_BACK_ID = 6
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO_DELAY = 17
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_4_ID = 4
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_5_ID = 5
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_6_ID = 6
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_7_ID = 7
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_8_ID = 8
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_9_ID = 9
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_10_ID = 10
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_11_ID = 11
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_12_ID = 12
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_13_ID = 13
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_14_ID = 14
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_15_ID = 15
    MENU_AUDIO_DELAY_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO_DELAY = 2
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_DELAY_SCREEN_BACK_ID = 1
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    MAX_SELECTION_MENU_AUDIO_DELAY = 4
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_DELAY_SCREEN_BACK_ID = 3
else :
    MAX_SELECTION_MENU_AUDIO_DELAY = 5
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_DELAY_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_DELAY_SCREEN_BACK_ID = 4
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO_GAIN = 17
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_4_ID = 4
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_5_ID = 5
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_6_ID = 6
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_7_ID = 7
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_8_ID = 8
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_9_ID = 9
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_10_ID = 10
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_11_ID = 11
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_12_ID = 12
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_13_ID = 13
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_14_ID = 14
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_15_ID = 15
    MENU_AUDIO_GAIN_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO_GAIN = 2
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_GAIN_SCREEN_BACK_ID = 1
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    MAX_SELECTION_MENU_AUDIO_GAIN = 4
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_GAIN_SCREEN_BACK_ID = 3
else :
    MAX_SELECTION_MENU_AUDIO_GAIN = 5
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_GAIN_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_GAIN_SCREEN_BACK_ID = 4
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_SELECTION_MENU_AUDIO_SOURCE = 17
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_4_ID = 4
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_5_ID = 5
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_6_ID = 6
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_7_ID = 7
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_8_ID = 8
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_9_ID = 9
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_10_ID = 10
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_11_ID = 11
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_12_ID = 12
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_13_ID = 13
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_14_ID = 14
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_15_ID = 15
    MENU_AUDIO_SOURCE_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):   
    MAX_SELECTION_MENU_AUDIO_SOURCE = 5
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_SOURCE_SCREEN_BACK_ID = 4
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    MAX_SELECTION_MENU_AUDIO_SOURCE = 4
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_2_ID = 1
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID = 2
    MENU_AUDIO_SOURCE_SCREEN_BACK_ID = 3
else :     
    MAX_SELECTION_MENU_AUDIO_SOURCE = 5
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID = 0
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_1_ID = 1
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_2_ID = 2
    MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID = 3
    MENU_AUDIO_SOURCE_SCREEN_BACK_ID = 4

# MAX_SELECTION_MENU_AUDIO_SOURCE = 5
# MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID = 0
# MENU_AUDIO_SOURCE_SCREEN_CHANNEL_1_ID = 1
# MENU_AUDIO_SOURCE_SCREEN_CHANNEL_2_ID = 2
# MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID = 3
# MENU_AUDIO_SOURCE_SCREEN_BACK_ID = 4
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code"):
    MAX_SELECTION_MENU_AUDIO_SOURCE_EDIT = 10
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID = 0
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A2_ID = 1
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A3_ID = 2
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A4_ID = 3
    MENU_AUDIO_SOURCE_EDIT_SCREEN_D1_ID = 4
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S1_ID = 5
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S2_ID = 6
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G1_ID = 7
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID = 8
    MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID = 9
elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    MAX_SELECTION_MENU_AUDIO_SOURCE_EDIT = 6
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID = 0
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S1_ID = 1
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S2_ID = 2
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G1_ID = 3
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID = 4
    MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID = 5
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    MAX_SELECTION_MENU_AUDIO_SOURCE_EDIT = 7
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID = 0
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A2_ID = 1
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S1_ID = 2
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S2_ID = 3
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G1_ID = 4
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID = 5
    MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID = 6
else:
    MAX_SELECTION_MENU_AUDIO_SOURCE_EDIT = 13
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID = 0
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A2_ID = 1
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A3_ID = 2
    MENU_AUDIO_SOURCE_EDIT_SCREEN_A4_ID = 3
    MENU_AUDIO_SOURCE_EDIT_SCREEN_D1_ID = 4
    MENU_AUDIO_SOURCE_EDIT_SCREEN_D2_ID = 5
    MENU_AUDIO_SOURCE_EDIT_SCREEN_D3_ID = 6
    MENU_AUDIO_SOURCE_EDIT_SCREEN_D4_ID = 7
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S1_ID = 8
    MENU_AUDIO_SOURCE_EDIT_SCREEN_S2_ID = 9
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G1_ID = 10
    MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID = 11
    MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID = 12
#######################################################################################################################
FOLDERS_GLOBAL_PRESETS_INIT_ID = 0
FILES_GLOBAL_PRESETS_INIT_ID = 0
FOLDERS_SPEAKER_PRESETS_INIT_ID = 0
FILES_SPEAKER_PRESETS_INIT_ID = 0
#######################################################################################################################
MAX_FILE_SYSTEM_ITEMS = 8
MAX_SELECTED_POSITION_IN_FILE_SYSTEM = 7
MIN_SELECTED_POSITION_IN_FILE_SYSTEM = 0
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    MAX_CHOOSE_CHANNEL_ITEMS = 17
    CHOOSE_CHANNEL_1_ID = 0
    CHOOSE_CHANNEL_2_ID = 1
    CHOOSE_CHANNEL_3_ID = 2
    CHOOSE_CHANNEL_4_ID = 3
    CHOOSE_CHANNEL_5_ID = 4
    CHOOSE_CHANNEL_6_ID = 5
    CHOOSE_CHANNEL_7_ID = 6
    CHOOSE_CHANNEL_8_ID = 7
    CHOOSE_CHANNEL_9_ID = 8
    CHOOSE_CHANNEL_10_ID = 9
    CHOOSE_CHANNEL_11_ID = 10
    CHOOSE_CHANNEL_12_ID = 11
    CHOOSE_CHANNEL_13_ID = 12
    CHOOSE_CHANNEL_14_ID = 13
    CHOOSE_CHANNEL_15_ID = 14
    CHOOSE_CHANNEL_16_ID = 15
    CHOOSE_CHANNEL_SCREEN_BACK_ID = 16
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    MAX_CHOOSE_CHANNEL_ITEMS = 4
    CHOOSE_CHANNEL_1_ID = 0
    CHOOSE_CHANNEL_3_ID = 1
    CHOOSE_CHANNEL_4_ID = 2
    CHOOSE_CHANNEL_SCREEN_BACK_ID = 3
else:
    MAX_CHOOSE_CHANNEL_ITEMS = 5
    CHOOSE_CHANNEL_1_ID = 0
    CHOOSE_CHANNEL_2_ID = 1
    CHOOSE_CHANNEL_3_ID = 2
    CHOOSE_CHANNEL_4_ID = 3
    CHOOSE_CHANNEL_SCREEN_BACK_ID = 4
#######################################################################################################################
MAX_APPLY_CHANGE_ITEMS = 2
APPLY_CHANGE_YES_ID = 0
APPLY_CHANGE_NO_ID = 1
#######################################################################################################################
MAX_SELECTION_ARRAY = [MAX_SELECTION_HOME,
                       MAX_SELECTION_MENU,
                       MAX_SELECTION_MENU_AUDIO,
                       MAX_SELECTION_MENU_PRESETS,
                       MAX_SELECTION_MENU_HOTSPOT,
                       MAX_SELECTION_MENU_CLOUD,
                       MAX_SELECTION_NETWORK,
                       MAX_SELECTION_ABOUT,
                       MAX_SELECTION_MENU_AUDIO_DELAY,
                       MAX_SELECTION_MENU_AUDIO_GAIN,
                       MAX_SELECTION_MENU_AUDIO_SOURCE,
                       MAX_FILE_SYSTEM_ITEMS,
                       MAX_FILE_SYSTEM_ITEMS,
                       MAX_FILE_SYSTEM_ITEMS,
                       MAX_FILE_SYSTEM_ITEMS,
                       MAX_CHOOSE_CHANNEL_ITEMS,
                       MAX_APPLY_CHANGE_ITEMS,
                       MAX_SELECTION_MENU_AUDIO_PEQ,
                       MAX_SELECTION_MENU_AUDIO_PEQ_EDIT,
                       MAX_SELECTION_MENU_AUDIO_XOVER,
                       MAX_SELECTION_MENU_AUDIO_XOVER_EDIT,
                       MAX_SELECTION_MENU_AUDIO_LIMITER,
                       MAX_SELECTION_MENU_AUDIO_LIMITER_EDIT,
                       MAX_SELECTION_MENU_AUDIO_FREQ_GEN,
                       MAX_SELECTION_MENU_AUDIO_SOURCE_EDIT]
#######################################################################################################################
MAIN_MENU_POS_1 = (0, 0)
MAIN_MENU_POS_2 = (45, 0)
MAIN_MENU_POS_3 = (90, 0)
MAIN_MENU_POS_4 = (0, 55)
MAIN_MENU_POS_5 = (45, 55)
MAIN_MENU_POS_6 = (90, 55)
#######################################################################################################################
MAIN_AUDIO_MENU_POSITIONS = [(0, 0), (45, 0), (90, 0), (0, 55), (45, 55), (90, 55)]
#######################################################################################################################
PRESETS_MENU_POS_1 = (0, 0)
PRESETS_MENU_POS_2 = (45, 0)
#######################################################################################################################
ONE_ITEM_MENU_RECTANGLE = [(70,30), (127,44)]
#######################################################################################################################
ONE_ITEM_MENU_EDIT_FIELD_POSITION = (75, 30)
#######################################################################################################################
THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_1 = (1, 22)
THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_2 = (1, 50)
THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_3 = (1, 78)
THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_4 = (64, 78)
#######################################################################################################################
THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_1 = (25, 35)
THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_2 = (25, 63)
THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_3 = (15, 91)
THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_4 = (78, 91)
#######################################################################################################################
THREE_ITEM_MENU_TEXT_BOX_POS_1 = (1, 39)
THREE_ITEM_MENU_TEXT_BOX_POS_2 = (1, 59)
THREE_ITEM_MENU_TEXT_BOX_POS_3 = (1, 79)
#######################################################################################################################
FOUR_ITEM_MENU_TEXT_BOX_POS_1 = (1, 19)
FOUR_ITEM_MENU_TEXT_BOX_POS_2 = (1, 39)
FOUR_ITEM_MENU_TEXT_BOX_POS_3 = (1, 59)
FOUR_ITEM_MENU_TEXT_BOX_POS_4 = (1, 79)
#######################################################################################################################
THREE_ITEM_MENU_EDIT_FIELD_POS_1 = (55, 39)
THREE_ITEM_MENU_EDIT_FIELD_POS_2 = (55, 59)
THREE_ITEM_MENU_EDIT_FIELD_POS_3 = (55, 79)
#######################################################################################################################
THREE_ITEM_NETWORK_MENU_EDIT_FIELD_POS_1 = (45, 39)
THREE_ITEM_NETWORK_MENU_EDIT_FIELD_POS_2 = (45, 59)
THREE_ITEM_NETWORK_MENU_EDIT_FIELD_POS_3 = (45, 79)
#######################################################################################################################
FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_1 = (45, 19)
FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_2 = (45, 39)
FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_3 = (45, 59)
FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_4 = (45, 79)
#######################################################################################################################
FOUR_ITEM_MENU_CLOUD_POSITIONS = [(36, 30), (36, 50), (36, 70), (36, 90)]
#######################################################################################################################
THREE_ITEM_MENU_RECTANGLE_1 = [(40, 40), (127, 50)]
THREE_ITEM_MENU_RECTANGLE_2 = [(40, 60), (127, 70)]
THREE_ITEM_MENU_RECTANGLE_3 = [(40, 80), (127, 90)]
#######################################################################################################################
FOUR_ITEM_MENU_RECTANGLE_1 = [(40, 18), (127, 30)]
FOUR_ITEM_MENU_RECTANGLE_2 = [(40, 38), (127, 50)]
FOUR_ITEM_MENU_RECTANGLE_3 = [(40, 58), (127, 70)]
FOUR_ITEM_MENU_RECTANGLE_4 = [(40, 78), (127, 90)]
#######################################################################################################################
FOUR_ITEM_MENU_TEXT_BOX_POSITIONS = [(1, 30), (1, 50), (1, 70), (1, 90)]
#######################################################################################################################
FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS = [(85, 30), (85, 50), (85, 70), (85, 90)]
#######################################################################################################################
FOUR_ITEM_AUDIO_SOURCE_MENU_POSITIONS = [(82, 30), (82, 50), (82, 70), (82, 90)]
#######################################################################################################################
FOUR_ITEM_MENU_RECTANGLES = [[(80, 30), (127, 40)],
                             [(80, 50), (127, 60)],
                             [(80, 70), (127, 80)],
                             [(80, 90), (127, 100)]]
#######################################################################################################################
SIX_ITEM_MENU_TEXT_BOX_POSITIONS = [(1, 5), (10, 27), (10, 44), (10, 61), (10, 78), (10, 95)]
#######################################################################################################################
SIX_ITEM_MENU_EDIT_FIELD_POSITIONS = [(60, 5), (60, 27), (60, 44), (60, 61), (60, 78), (60, 95)]
#######################################################################################################################
TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS = [(4, 3), (4, 30), (4, 58), (4, 84), 
                                       (46, 3), (46, 30), (46, 58), (46, 84),
                                       (89, 3), (89, 30), (89, 58), (89, 84)]
#######################################################################################################################
TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS = [(4, 17), (4, 44), (4, 72), (4, 98), 
                                         (46, 17), (46, 44), (46, 72), (46, 98),
                                         (89, 17), (89, 44), (89, 72), (89, 98)]
#######################################################################################################################
SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS = [
(0, 25), (33, 25), (66, 26), (99, 25),
(0, 47), (34, 47), (66, 48), (99, 47),
(2, 69), (35, 70), (66, 69), (100, 69),
(-1, 91), (33, 91), (66, 92), (100, 91)]
#######################################################################################################################
# SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS = [(1, 30), (1, 50), (1, 70), (1, 90),(31, 30), (31, 50), (31, 70), (31, 90),
#                                         (61, 30), (61, 50), (61, 70), (61, 90),(95, 30), (95, 50), (95, 70), (95, 90)]
#######################################################################################################################
SIX_ITEM_MENU_RECTANGLES = [[(58,6),(127,16)],
                            [(58,27),(127,37)],
                            [(58,44),(127,54)],
                            [(58,61),(127,71)],
                            [(58,78),(127,88)],
                            [(58,95),(127,105)]]
#######################################################################################################################
#Previously was 100 instead of 123
EIGHT_ITEM_MENU_RECTANGLES = [[(5, 9), (123, 19)],
                              [(5, 21), (123, 31)],
                              [(5, 33), (123, 43)],
                              [(5, 45), (123, 55)],
                              [(5, 57), (123, 67)],
                              [(5, 69), (123, 79)],
                              [(5, 81), (123, 91)],
                              [(5, 93), (123, 103)]]
#######################################################################################################################
NINE_ITEM_MENU_RECTANGLES = [[(0, 16), (41, 29)], [(0, 43), (42, 56)], [(0, 70), (42, 83)], [(0, 97), (42, 110)],
                              [(42, 16), (85, 29)],
                              [(85, 16), (128, 29)], [(85, 43), (128, 56)], [(85, 70), (128, 83)], [(85, 97), (128, 110)]]
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    TWELVE_ITEM_MENU_RECTANGLES = [[(0, 16), (41, 29)], 
                              [(85, 16), (128, 29)], [(85, 43), (128, 56)], [(85, 70), (128, 83)], [(85, 97), (128, 110)]]
else:
    TWELVE_ITEM_MENU_RECTANGLES = [[(0, 16), (41, 29)], [(0, 43), (42, 56)], [(0, 70), (42, 83)], [(0, 97), (42, 110)],
                                [(42, 16), (85, 29)], [(42, 43), (85, 56)], [(42, 70), (85, 83)], [(42, 97), (85, 110)],
                                [(85, 16), (128, 29)], [(85, 43), (128, 56)], [(85, 70), (128, 83)], [(85, 97), (128, 110)]]
#######################################################################################################################
CHOOSE_CHANNEL_RECTANGLE_POSITIONS = [[(0, 30), (127, 40)],
                                      [(0, 50), (127, 60)],
                                      [(0, 70), (127, 80)],
                                      [(0, 90), (127, 100)]]
#######################################################################################################################
APPLY_SPEAKER_PRESET_CHANGE_YES_POS = (16, 50)
APPLY_SPEAKER_PRESET_CHANGE_NO_POS = (86, 50)
#######################################################################################################################
APPLY_SPEAKER_PRESET_RECTANGLE_POS_1 = [(15, 50), (42, 60)]
APPLY_SPEAKER_PRESET_RECTANGLE_POS_2 = [(85, 50), (105, 60)]
#######################################################################################################################
GRAY_COLOR = (128, 128, 128)
GRAY2_COLOR = (64, 64, 64)
RED_COLOR = (0, 0, 255)
GREEN_COLOR = (0, 255, 0)
BLUE_COLOR = (255, 0, 0)
ORANGE_COLOR = (0, 140, 255)
SCREEN_SIZE = (128, 128)
#######################################################################################################################
BOTTOM_LINE = [(0, 110), (128, 110)]
BOTTOM_TEXT_POS = (1, 112)
TOP_TEXT_POS = (1, 1)
MIDDLE_TEXT_POS = (1, 30)
VERT_LINE_1_3 = [(42, 0), (42, 110)]
VERT_LINE_2_3 = [(85, 0), (85, 110)]
HORI_LINE_1_3 = [(0, 29), (127, 29)]
HORI_LINE_2_3 = [(0, 56), (127, 56)]
HORI_LINE_3_3 = [(0, 83), (127, 83)]
#######################################################################################################################
POSITION_CLOUD = (90, 0)
POSITION_WIFI = (112, 0)
POSITION_ETHERNET = (68, 0)
POSITION_SETTINGS = (112, 112)
POSITION_BACK = (112, 112)
POSITION_BACK_FILLED = [(112, 112), (127, 127)]
POSITION_LOCK = (61, 16)
#######################################################################################################################
MUTE_UNMUTE_POSITIONS = [(112, 28), (112, 48), (112, 68), (112, 88)]
#######################################################################################################################
DELAY_VALUE_POSITIONS_16 = [
(10, 26), (43, 26), (76, 26), (109, 26),
(10, 48), (43, 48), (76, 48), (109, 48),
(10, 70), (43, 70), (76, 70), (109, 70), 
(10, 92), (43, 92), (76, 92), (109, 92)]
#######################################################################################################################
MUTE_UNMUTE_POSITIONS_16 = [
(13, 26), (46, 26), (79, 26), (112, 26),
(13, 48), (46, 48), (79, 48), (112, 48),
(13, 70), (46, 70), (79, 70), (112, 70), 
(13, 92), (46, 92), (79, 92), (112, 92)]
#######################################################################################################################
HOME_SCREEN_LINE_0 = [(0, 17), (128, 17)]
HOME_SCREEN_LINE_1 = [(0, 110), (128, 110)]
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    HOME_SCREEN_POSITIONS = [[(0, 23), (46, 36)],
                         [(0, 51), (46, 64)],
                         [(0, 79), (46, 92)],
                         [(111, 111), (127, 127)]]
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
     HOME_SCREEN_POSITIONS = [[(0, 28), (127, 44)],
                            [(0, 48), (127, 64)],
                            [(0, 68), (127, 84)],
                            [(111, 111), (127, 127)]]   
else:
    HOME_SCREEN_POSITIONS = [[(0, 28), (127, 44)],
                            [(0, 48), (127, 64)],
                            [(0, 68), (127, 84)],
                            [(0, 88), (127, 104)],
                            [(111, 111), (127, 127)]]
#######################################################################################################################
HOME_SCREEN_SIXTEEN_POSITIONS  = [
[(0, 22), (30, 40)], [(32, 22), (62, 40)], [(65, 22), (95, 40)], [(98, 22), (128, 40)],
[(0, 44), (30, 62)], [(32, 44), (62, 62)], [(65, 44), (95, 62)], [(98, 44), (128, 62)],
[(0, 66), (30, 84)], [(32, 66), (62, 84)], [(65, 66), (95, 84)], [(98, 66), (128, 84)],
[(0, 88), (30, 106)], [(32, 88), (62, 106)], [(65, 88), (95, 106)], [(98, 88), (128, 106)],
[(111, 111), (127, 127)]]
# #######################################################################################################################
# HOME_SCREEN_SIXTEEN_POSITIONS  = [[(0, 28), (28, 44)], [(0, 48), (28, 64)], [(0, 68), (28, 84)], [(0, 88), (28, 104)],
#                                     [(30, 28), (57, 44)], [(30, 48), (57, 64)], [(30, 68), (57, 84)], [(30, 88), (57, 104)],
#                                     [(59, 28), (93, 44)], [(59, 48), (93, 64)], [(59, 68), (93, 84)], [(59, 88), (93, 104)],
#                                     [(95, 28), (127, 44)], [(95, 48), (127, 64)], [(95, 68), (127, 84)], [(95, 88), (127, 104)],
#                                     [(111, 111), (127, 127)]]
#######################################################################################################################
FOUR_ITEMS_FILLED_POSITIONS = [[(75, 30), (110, 40)],
                               [(75, 50), (110, 60)],
                               [(75, 70), (110, 80)],
                               [(75, 90), (110, 100)]]
#######################################################################################################################
SIXTEEN_ITEMS_FILLED_POSITIONS = [
[(10, 26), (28, 36)],[(43, 26), (61, 36)],[(76, 26), (94, 36)],[(109, 26), (127, 36)],
[(10, 48), (28, 58)],[(43, 48), (61, 58)],[(76, 48), (94, 58)],[(109, 48), (127, 58)],
[(10, 70), (28, 80)],[(43, 70), (61, 80)],[(76, 70), (94, 80)],[(109, 70), (127, 80)],
[(10, 92), (28, 102)],[(43, 92), (61, 102)],[(76, 92), (94, 102)],[(109, 92), (127, 102)]]
# #######################################################################################################################
# SIXTEEN_ITEMS_FILLED_POSITIONS = [[(10, 30), (28, 40)], [(10, 50), (28, 60)], [(10, 70), (28, 80)], [(10, 90), (28, 100)],
#                                     [(39, 30), (57, 40)], [(39, 50), (57, 60)], [(39, 70), (57, 80)], [(39, 90), (57, 100)],
#                                     [(75, 30), (93, 40)], [(75, 50), (93, 60)], [(75, 70), (93, 80)], [(75, 90), (93, 100)],
#                                     [(109, 30), (127, 40)], [(109, 50), (127, 60)], [(109, 70), (127, 80)], [(109, 90), (127, 100)]]
#######################################################################################################################
HOME_SCREEN_POS_0 = (0, 0)
HOME_SCREEN_POS_1 = (0, 115)
#######################################################################################################################
HOTSPOT_SCREEN_ON_OFF_RECTANGLE_1 = [(50, 40), (127, 50)]
#######################################################################################################################
CLOUD_SCREEN_ON_OFF_RECTANGLE_1 = [(36, 30), (56, 40)]
#######################################################################################################################
FILE_SYSTEMS_POSITIONS = [(6, 10), (6, 22), (6, 34), (6, 46), (6, 58), (6, 70), (6, 82), (6, 94)]
#######################################################################################################################
BLACK_SCREEN_POS = [(0, 0), (127, 127)]
#######################################################################################################################
ABOUT_SCREEN_POS_1_1 = (1, 9)
ABOUT_SCREEN_POS_1_2 = (85, 9)
ABOUT_SCREEN_POS_2_1 = (1, 29)
ABOUT_SCREEN_POS_2_2 = (85, 29)
ABOUT_SCREEN_POS_3_1 = (1, 49)
ABOUT_SCREEN_POS_3_2 = (85, 49)
ABOUT_SCREEN_POS_4_1 = (1, 69)
ABOUT_SCREEN_POS_4_2 = (85, 69)
ABOUT_SCREEN_POS_5_1 = (1, 89)
ABOUT_SCREEN_POS_5_2 = (85, 89)
ABOUT_SCREEN_POS_6_1 = (1, 109)
# ABOUT_SCREEN_POS_2_1 = (1, 59)
# ABOUT_SCREEN_POS_2_2 = (85, 59)
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    SEEKBAR_CHANNEL_0_POS = (11, 28)
    SEEKBAR_CHANNEL_1_POS = (44, 28)
    SEEKBAR_CHANNEL_2_POS = (77, 28)
    SEEKBAR_CHANNEL_3_POS = (110, 28)
    SEEKBAR_CHANNEL_4_POS = (11, 50)
    SEEKBAR_CHANNEL_5_POS = (44, 50)
    SEEKBAR_CHANNEL_6_POS = (77, 50)
    SEEKBAR_CHANNEL_7_POS = (110, 50)
    SEEKBAR_CHANNEL_8_POS = (11, 72)
    SEEKBAR_CHANNEL_9_POS = (44, 72)
    SEEKBAR_CHANNEL_10_POS = (77, 72)
    SEEKBAR_CHANNEL_11_POS = (110, 72)
    SEEKBAR_CHANNEL_12_POS = (11, 94)
    SEEKBAR_CHANNEL_13_POS = (44, 94)
    SEEKBAR_CHANNEL_14_POS = (77, 94)
    SEEKBAR_CHANNEL_15_POS = (110, 94)
else : 
    SEEKBAR_CHANNEL_0_POS = (76, 32)
    SEEKBAR_CHANNEL_1_POS = (76, 52)
    SEEKBAR_CHANNEL_2_POS = (76, 72)
    SEEKBAR_CHANNEL_3_POS = (76, 92)
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
    SEEKBAR_POSITIONS = [SEEKBAR_CHANNEL_0_POS,
                        SEEKBAR_CHANNEL_1_POS,
                        SEEKBAR_CHANNEL_2_POS,
                        SEEKBAR_CHANNEL_3_POS,
                        SEEKBAR_CHANNEL_4_POS,
                        SEEKBAR_CHANNEL_5_POS,
                        SEEKBAR_CHANNEL_6_POS,
                        SEEKBAR_CHANNEL_7_POS,
                        SEEKBAR_CHANNEL_8_POS,
                        SEEKBAR_CHANNEL_9_POS,
                        SEEKBAR_CHANNEL_10_POS,
                        SEEKBAR_CHANNEL_11_POS,
                        SEEKBAR_CHANNEL_12_POS,
                        SEEKBAR_CHANNEL_13_POS,
                        SEEKBAR_CHANNEL_14_POS,
                        SEEKBAR_CHANNEL_15_POS]
else :
    SEEKBAR_POSITIONS = [SEEKBAR_CHANNEL_0_POS,
                        SEEKBAR_CHANNEL_1_POS,
                        SEEKBAR_CHANNEL_2_POS,
                        SEEKBAR_CHANNEL_3_POS]
#######################################################################################################################
GLOBAL_PRESET_ICON_POS = (0, 0)
SPEAKER_PRESET_ICON_POS = (45, 0)
#######################################################################################################################
SIGGEN_FREQUENCY = [50, 100, 200, 500, 1000, 2000, 5000, 10000]
#######################################################################################################################
if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code"):
    # SOURCE_EDIT_LABELS = ["Analog :", "Nw 1 :", "Nw 2 :", "Nw 3 :", "Nw 4 :", "Str L :", "Str R :", "Sine :", "Pink :"]
    SOURCE_EDIT_LABELS = ["Analog", "Str L :", "Str R :", "Sine :", "Pink :"]
elif (CURRENT_VARIANT_VALUE == "variant9.code"):
    SOURCE_EDIT_LABELS = ["An A :", "An B :", "Str L :", "Str R :", "Sine :", "Pink :"]
else:
    SOURCE_EDIT_LABELS = ["An A :", "An B :", "An C :", "An D :", "Nw 1 :", "Nw 2 :", "Nw 3 :", "Nw 4 :", "Str L :", "Str R :", "Sine :", "Pink :"]
#######################################################################################################################
CHANNEL_LABEL_VAR9 = ["SUB", "LEFT", "RIGHT"]
#######################################################################################################################
NETWORK_SOURCE_LABELS = ["Nw 1:", "Nw 2:", "Nw 3:", "Nw 4", "Nw 5:", "Nw 6:", "Nw 7:", "Nw 8:", "Nw 9:", "Nw 10:", "Nw 11:", "Nw 12:", "Nw 13:", "Nw 14:", "Nw 15:", "Nw 16:"]
#######################################################################################################################
PEQ_EDIT_LABELS = ["PEQ index :", "Ena :", "Type :", "Freq :", "Gain :", "Q :"]
#######################################################################################################################
PEQ_TYPE = ["Bell-Sym", "Bell-ASym", "Notch", "Lo-Shel 6dB", "Lo-Shel 12dB", "Hi-Shel 6dB",
    "Hi-Shel 12dB", "All-Pass 90°", "All-Pass 180°", "Hi-Pass 6dB", "Hi-Pass 12dB",
    "HP VarQ 12dB", "Lo-Pass 6dB", "Lo-Pass 12dB", "LP VarQ 12dB", "Band-Pass"]
#######################################################################################################################
XOVER_EDIT_LABELS = ["XOVER  :", "Ena :", "Type :", "Freq :"]
#######################################################################################################################
XOVER_TYPE = ["BW 6dB", "BW 12dB", "BW 18dB","BW 24dB", "BW 30dB", "BW 36dB", "BW 42dB", "BW 48dB",
    "L-R 12dB", "L-R 24dB", "L-R 36dB","L-R 48dB", "Bessel 12dB", "Bessel 18dB", "Bessel 24dB", "Bessel 30dB", 
    "Bessel 36dB", "Bessel 42dB", "Bessel 48dB"]
#######################################################################################################################
LIMITER_EDIT_LABELS = ["LIM mode :", "RMS Thr:", "RMS Att:", "RMS Rel:", "Peak Thr:", "Peak Rel:"]
#######################################################################################################################
LIMITER_TYPE_LABELS = ["Volt RMS", "2\u03A9 load", "2.7\u03A9 load", "4\u03A9 load", "8\u03A9 load", "16\u03A9 load"]
#######################################################################################################################
PRESET_POSITIONS = [GLOBAL_PRESET_ICON_POS, SPEAKER_PRESET_ICON_POS]
#######################################################################################################################
LOCAL_APP_VERSION = "V1.3.5S"
#######################################################################################################################
