import os.path
from PIL import Image, ImageDraw, ImageFont, ImageSequence
from luma.core.virtual import viewport
from luma.core.render import canvas

import Data
import util
from demo_opts import get_device
from luma.core.sprite_system import framerate_regulator
import Constants
import MonitorTask
import json

import time
from threading import Lock, Timer, Thread

from Constants import CURRENT_VARIANT_VALUE
from common import PEAK_READBACK_FILE, AMP_ON, TEMP, OVERTEMP, VOLTAGE


from util import get_gain_as_slider_progress
from util import construct_luma_core_display_args
from util import dbus_to_python

Font1 = ImageFont.truetype(
    os.path.join(os.path.dirname(__file__), "fonts/FreeSans.ttf"), 12, encoding="unic")
Font2 = ImageFont.truetype(
    os.path.join(os.path.dirname(__file__), "fonts/FreeSans.ttf"), 11, encoding="unic")
Font3 = ImageFont.truetype(
    os.path.join(os.path.dirname(__file__), "fonts/FreeSans.ttf"), 10, encoding="unic")
Font4 = ImageFont.truetype(
    os.path.join(os.path.dirname(__file__), "fonts/FreeSans.ttf"), 9, encoding="unic")
Font5 = ImageFont.truetype(
    os.path.join(os.path.dirname(__file__), "fonts/FreeSans.ttf"), 8, encoding="unic")

img_cloud = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                         'images/bmpInvertedGray', 'cloud.png'))
img_wifi = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                        'images/bmpInvertedGray', 'wifi.png'))
img_ethernet = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'ethernet3.png'))
img_settings = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'settings.png'))
img_unmute = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                          'images/bmpInvertedGray', 'unmute.png'))
img_mute = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                        'images/bmpInvertedGray', 'mute.png'))
img_mute_low = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                        'images/bmpInvertedGray', 'mute_low.png'))
img_back_path = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                             'images/bmpInvertedGray', 'back.png'))
img_lock = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                             'images/bmpInvertedGray', 'LockSelected_result.bmp'))

img_path_1_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Audio_1_result.bmp'))
img_path_2_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Presets_1_result.bmp'))
img_path_3_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Hotspot_1_result.bmp'))
img_path_4_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Cloud_1_result.bmp'))
img_path_5_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Network_1_result.bmp'))
img_path_6_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'About_1_result.bmp'))

img_path_1_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Audio_0_result.bmp'))
img_path_2_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Presets_0_result.bmp'))
img_path_3_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Hotspot_0_result.bmp'))
img_path_4_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Cloud_0_result.bmp'))
img_path_5_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Network_0_result.bmp'))
img_path_6_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'About_0_result.bmp'))
img_seekbar_colored_path = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                        'images/coloredImages', 'seekbar.bmp'))

img_source_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Mixer_1_result.bmp'))
img_gain_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                          'images/bmpInvertedGray', 'Gain_1_result.bmp'))
img_delay_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'Delay_1_result.bmp'))
img_peq_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'PEQ_1_result.bmp'))
img_xover_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'XOver_1_result.bmp'))
img_limiter_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'Limiter_1_result.bmp'))
img_signalgen_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'FrequencyGenerator_1_result.bmp'))
img_empty_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'Empty_0_result.bmp'))

img_source_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                            'images/bmpInvertedGray', 'Mixer_0_result.bmp'))
img_gain_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                          'images/bmpInvertedGray', 'Gain_0_result.bmp'))
img_delay_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'Delay_0_result.bmp'))
img_peq_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'PEQ_0_result.bmp'))
img_xover_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'XOver_0_result.bmp'))
img_limiter_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'Limiter_0_result.bmp'))
img_signalgen_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                           'images/bmpInvertedGray', 'FrequencyGenerator_0_result.bmp'))

img_global_preset_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                      'images/bmpInvertedGray', 'Global_1_result.bmp'))
img_speaker_preset_0 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                       'images/bmpInvertedGray', 'Speaker_1_result.bmp'))

img_global_preset_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                      'images/bmpInvertedGray', 'Global_0_result.bmp'))
img_speaker_preset_1 = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                    'images/bmpInvertedGray', 'Speaker_0_result.bmp'))

loading_gif_path = os.path.abspath(os.path.join(os.path.dirname(__file__), 'images/gif', 'loading.gif'))

locate_gif_path = os.path.abspath(os.path.join(os.path.dirname(__file__), 'images/gif', 'locate_low.gif'))

icon_back = Image.open(img_back_path)
icon_cloud = Image.open(img_cloud)
icon_wifi = Image.open(img_wifi)
icon_ethernet = Image.open(img_ethernet)
icon_settings = Image.open(img_settings)
icon_unmute = Image.open(img_unmute)
icon_mute = Image.open(img_mute)
icon_mute_low = Image.open(img_mute_low)
gif_progress = Image.open(loading_gif_path)
gif_locate = Image.open(locate_gif_path)
icon_lock = Image.open(img_lock)

dim_screen_active = True
ethernet_connected = False
ethernet_request = 1
ethernet_refresh_rate = 100

warning_temperature = 65

def set_screen_dim():
#     print("set screen dim")
    global dim_screen_active
    if dim_screen_active:
        dim_screen_active = False
        Display.device.contrast(int(Constants.SCREEN_DIM_INTENSITY))

def set_screen_dim_full():
    global dim_screen_active
    if not dim_screen_active:
        Display.device.contrast(int(Constants.SCREEN_DIM_MAX))
        dim_screen_active = True

class Display:
    device = get_device(construct_luma_core_display_args())
    imgSeekBarColored = Image.open(img_seekbar_colored_path).convert(device.mode)
    virtual = viewport(device, width=128, height=128)
    mutex_write = False


def create_screen(screen_num, selected_in_screen_num, selected_channel=0, selected_peq=0, is_in_focus=False, start_position=0, stop_position=7):
    if not Display.mutex_write:
        try:
            Display.mutex_write = True
            if screen_num == Constants.SCREEN_HOME_PAGE_ID:
                create_screen_home_page(selected_in_screen_num)
            elif screen_num == Constants.SCREEN_HOME_MENU_ID:
                create_screen_main_menu(selected_in_screen_num)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_ID:
                create_screen_audio_menu(selected_in_screen_num)
            elif screen_num == Constants.SCREEN_MENU_PRESETS_ID:
                create_screen_presets_menu(selected_in_screen_num)
            elif screen_num == Constants.SCREEN_MENU_HOTSPOT_ID:
                create_screen_hotspot_menu(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_CLOUD_ID:
                create_screen_cloud_menu(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_NETWORK_ID:
                create_screen_network_menu(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_ABOUT_ID:
                create_screen_about()
            elif screen_num == Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID:
                create_screen_audio_peq_edit(selected_in_screen_num, is_in_focus, selected_channel, selected_peq)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_PEQ_ID:
                create_screen_audio_peq(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_SIGGEN_ID:
                create_screen_audio_siggen(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_XOVER_EDIT_ID:
                create_screen_audio_xover_edit(selected_in_screen_num, is_in_focus, selected_channel, selected_peq)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_XOVER_ID:
                create_screen_audio_xover(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_LIMITER_EDIT_ID:
                create_screen_audio_limiter_edit(selected_in_screen_num, is_in_focus, selected_channel, selected_peq)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_LIMITER_ID:
                create_screen_audio_limiter(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_DELAY_ID:
                create_screen_audio_delay(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_GAIN_ID:
                create_screen_audio_gain(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_SOURCE_ID:
                create_screen_audio_source(selected_in_screen_num, is_in_focus)
            elif screen_num == Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID:
                create_screen_audio_source_edit(selected_in_screen_num, is_in_focus, selected_channel)
            elif screen_num == Constants.SCREEN_FOLDERS_GLOBAL_PRESETS_ID or \
                 screen_num == Constants.SCREEN_FILES_GLOBAL_PRESETS_ID or \
                 screen_num == Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID or \
                 screen_num == Constants.SCREEN_FILES_SPEAKER_PRESETS_ID:
                create_screen_file_system(screen_num, selected_in_screen_num, start_position, stop_position)
            elif screen_num == Constants.SCREEN_CHANNEL_CHOICE_SPEAKER_PRESET_ID:
                create_screen_choose_channel(selected_in_screen_num)
            elif screen_num == Constants.SCREEN_CHANNEL_APPLY_CHANGE_ID:
                create_screen_apply_change(selected_in_screen_num)
            elif screen_num == Constants.SCREEN_FRONT_LOCK:
                create_screen_front_lock()
            elif screen_num == Constants.SCREEN_LOCATE:
                create_screen_locate()
        except RuntimeError:
            pass
        finally:
            Display.mutex_write = False
            # if screen_num != Constants.SCREEN_HOME_PAGE_ID:
            #     check_dim_screen_timer()


def create_screen_home_page(selected):
    global ethernet_connected
    global ethernet_request

    # 16 CHANNELS VERSION
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
        temp_img = Image.new(Display.device.mode, (128, 128), color="black")

        base_img = Image.open(img_seekbar_colored_path).convert(Display.device.mode)
        base_img = base_img.resize((33, 17))
        array_img_volumes = []
        array_seekbar_rectangles = []

        for i in range(0, Constants.NUM_OF_CHANNELS):
            sc_bar = get_gain_as_slider_progress(Data.channels_preview[i]["gain_slider"])
            img_volume_channel = base_img.crop((0, 10, int(sc_bar / 100 * 16), 17))
            array_img_volumes.append(img_volume_channel)
            array_seekbar_rectangles.append([(Constants.SEEKBAR_POSITIONS[i][0], Constants.SEEKBAR_POSITIONS[i][1]),(Constants.SEEKBAR_POSITIONS[i][0]+int(sc_bar / 100 * 16)), Constants.SEEKBAR_POSITIONS[i][1]+6])

        draw = ImageDraw.Draw(temp_img)

        draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
        if (Data.settings_preview.get("amp_standby") == True and Data.settings_preview.get("amp_status") == 1):
            draw.text(Constants.HOME_SCREEN_POS_0, "STANDBY", fill="white", font=Font2)
        elif (Data.settings_preview.get("amp_status") == 2):
            draw.text(Constants.HOME_SCREEN_POS_0, "OVERTEMP", fill=Constants.RED_COLOR, font=Font2)
        elif (Data.settings_preview.get("amp_temperature") >= warning_temperature):
            draw.text(Constants.HOME_SCREEN_POS_0, "TEMP !", fill=Constants.ORANGE_COLOR, font=Font2)
        else:
            draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)

        if Constants.HOME_SCREEN_CHANNEL_0_ID <= selected <= Constants.HOME_SCREEN_SETUP_ID:
            draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY_COLOR)

        if util.is_ethernet_alive():
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_ETHERNET, icon_ethernet, fill=color)
        if Data.settings_preview.get("cloud_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_CLOUD, icon_cloud, fill=color)
        if Data.settings_preview.get("hotspot_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_WIFI, icon_wifi, fill=color)

        draw.bitmap(Constants.POSITION_SETTINGS, icon_settings, fill="white")

        # array_seekbar_rectangles = []

        for i in range(0, Constants.NUM_OF_CHANNELS):  # for 16 channels do following:
            draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)
            # If channel is muted, display mute icon instead of vu meter
            if Data.channels_preview[i]["mute"]:
                draw.bitmap(Constants.MUTE_UNMUTE_POSITIONS_16[i], icon_mute_low, fill="white")
                array_seekbar_rectangles.append((0,0))
            # Else channel is unmuted, display vu meter
            else:
                draw.rectangle(Constants.SIXTEEN_ITEMS_FILLED_POSITIONS[i], outline="white", width=1)
                temp_img.paste(array_img_volumes[i], Constants.SEEKBAR_POSITIONS[i])

                if 1 == int(Data.channels_preview[i]["rate_limiter_status"]):  # Orange bar
                    draw.rectangle(array_seekbar_rectangles[i], fill=Constants.ORANGE_COLOR)
                elif 2 == int(Data.channels_preview[i]["rate_limiter_status"]):  # Red bar
                    draw.rectangle(array_seekbar_rectangles[i], fill=Constants.RED_COLOR)
                else:  # Normal case: green to red gradient
                    temp_img.paste(array_img_volumes[i], Constants.SEEKBAR_POSITIONS[i])



        draw.line(Constants.HOME_SCREEN_LINE_1, fill="white")
        draw.text(Constants.HOME_SCREEN_POS_1, "HOME", fill="white", font=Font1)

        Display.virtual.display(temp_img)

    # AMP PLATE AF VERSION
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        # global ethernet_connected
        # global ethernet_request

        network_screen_data = {"network_mode": "", "IP": "", "Subnet": ""}

        if ethernet_request == 0:
            print("dbus_to_python(MonitorTask.command_get_data_network())")
            network_screen_data = dbus_to_python(MonitorTask.command_get_data_network())
            Data.settings_preview["old_network_mode"] = network_screen_data["network_mode"]
            Data.settings_preview["old_IP"] = network_screen_data["IP"][:]
            Data.settings_preview["old_subnet"] = network_screen_data["Subnet"][:]
            Data.settings_preview["new_network_mode"] = network_screen_data["network_mode"]
            Data.settings_preview["new_IP"] = network_screen_data["IP"][:]
            Data.settings_preview["new_subnet"] = network_screen_data["Subnet"][:]

        temp_img = Image.new(Display.device.mode, (128, 128), color="black")

        draw = ImageDraw.Draw(temp_img)

        draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
        # draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)
        if (Data.settings_preview.get("amp_standby") == True and Data.settings_preview.get("amp_status") == 1):
            draw.text(Constants.HOME_SCREEN_POS_0, "STANDBY", fill="white", font=Font2)
        elif (Data.settings_preview.get("amp_status") == 2):
            draw.text(Constants.HOME_SCREEN_POS_0, "OVERTEMP", fill=Constants.RED_COLOR, font=Font2)
        elif (Data.settings_preview.get("amp_temperature") >= warning_temperature):
            draw.text(Constants.HOME_SCREEN_POS_0, "TEMP !", fill=Constants.ORANGE_COLOR, font=Font2)
        else:
            draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)

        if Constants.HOME_SCREEN_MENU_PRESET_ID <= selected <= Constants.HOME_SCREEN_SETUP_ID:
            draw.rectangle(Constants.HOME_SCREEN_POSITIONS[selected], fill=Constants.GRAY_COLOR)

        last_ethernet_status = ethernet_connected

        if util.is_ethernet_alive():
            color = Constants.GREEN_COLOR
            ethernet_connected = True
        else:
            color = "white"
            ethernet_connected = False
        
        if last_ethernet_status == False and ethernet_connected == True:
            if (bool(Data.settings_preview["cloud_status"])):
                MonitorTask.command_cloud_turn_on_off(bool(Data.settings_preview["cloud_status"]))
                print("command_cloud_turn_on_off!")

        draw.bitmap(Constants.POSITION_ETHERNET, icon_ethernet, fill=color)
        if Data.settings_preview.get("cloud_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"

        draw.bitmap(Constants.POSITION_CLOUD, icon_cloud, fill=color)
        if Data.settings_preview.get("hotspot_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"

        draw.bitmap(Constants.POSITION_WIFI, icon_wifi, fill=color)

        draw.bitmap(Constants.POSITION_SETTINGS, icon_settings, fill="white")

        ip = str(Data.settings_preview.get("new_IP")[0]) + "." + str(Data.settings_preview.get("new_IP")[1]) + "." + str(Data.settings_preview.get("new_IP")[2]) + "." + str(Data.settings_preview.get("new_IP")[3])

        gain = round(Data.channels_preview[0].get("gain"),1)
        # print("From channel preview :")
        # print(gain)
        # gain = '%.1f' % ( gain if gain != 0 else abs(gain) )
        # gain = '{0:.1f}'.format(Data.channels_preview[0].get("gain") + 0)
        # print("After conversion")
        # print(gain)
        # if gain == -0.0:
        #     gain = abs(gain)

        draw.text(Constants.THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_1, str(Data.channels_preview[0].get("name")), fill="white", font=Font1)
        draw.text(Constants.THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_2, str(ip), fill="white", font=Font1)
        draw.text(Constants.THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_3, str(gain) + "dB", fill="white", font=Font1)
        if Data.settings_preview.get("limiter_sum") == 0:
            draw.text(Constants.THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_4, str(Data.settings_preview.get("limiter_sum")) + "dB", fill="white", font=Font1)
        else:
            draw.text(Constants.THREE_ITEM_HOME_SCREEN_EDIT_FIELD_POS_4, str(Data.settings_preview.get("limiter_sum")) + "dB", fill="blue", font=Font1)

        draw.text(Constants.THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_1, "Preset :", fill="white", font=Font1)
        draw.text(Constants.THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_2, "Ip : ", fill="white", font=Font1)
        draw.text(Constants.THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_3, "Gain :", fill="white", font=Font1)
        draw.text(Constants.THREE_ITEM_HOME_SCREEN_TEXT_BOX_POS_4, "Lim :", fill="white", font=Font1)

        draw.line(Constants.HOME_SCREEN_LINE_1, fill="white")
        draw.text(Constants.HOME_SCREEN_POS_1, "HOME", fill="white", font=Font1)

        Display.virtual.display(temp_img)

        if ethernet_request < 100 :
            ethernet_request += 1
        else:
            ethernet_request = 0
    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        array_3ch = [0,2,3]
        temp_img = Image.new(Display.device.mode, (128, 128), color="black")

        base_img = Image.open(img_seekbar_colored_path).convert(Display.device.mode)
        base_img = base_img.resize((33, 17))
        array_img_volumes = []

        for i in range(0, Constants.NUM_OF_CHANNELS-1):
            sc_bar = get_gain_as_slider_progress(Data.channels_preview[array_3ch[i]]["gain_slider"])
            img_volume_channel = base_img.crop((0, 10, int(sc_bar / 100 * 33), 17))
            array_img_volumes.append(img_volume_channel)

        draw = ImageDraw.Draw(temp_img)

        draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
        # draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)
        if (Data.settings_preview.get("amp_standby") == True and Data.settings_preview.get("amp_status") == 1):
            draw.text(Constants.HOME_SCREEN_POS_0, "STANDBY", fill="white", font=Font2)
        elif (Data.settings_preview.get("amp_status") == 2):
            draw.text(Constants.HOME_SCREEN_POS_0, "OVERTEMP", fill=Constants.RED_COLOR, font=Font2)
        elif (Data.settings_preview.get("amp_temperature") >= warning_temperature):
            draw.text(Constants.HOME_SCREEN_POS_0, "TEMP !", fill=Constants.ORANGE_COLOR, font=Font2)
        else:
            draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)

        if Constants.HOME_SCREEN_CHANNEL_0_ID <= selected <= Constants.HOME_SCREEN_SETUP_ID:
            draw.rectangle(Constants.HOME_SCREEN_POSITIONS[selected], fill=Constants.GRAY_COLOR)

        last_ethernet_status = ethernet_connected

        if util.is_ethernet_alive():
            color = Constants.GREEN_COLOR
            ethernet_connected = True
        else:
            color = "white"
            ethernet_connected = False
        
        if last_ethernet_status == False and ethernet_connected == True:
            if (bool(Data.settings_preview["cloud_status"])):
                MonitorTask.command_cloud_turn_on_off(bool(Data.settings_preview["cloud_status"]))

        draw.bitmap(Constants.POSITION_ETHERNET, icon_ethernet, fill=color)
        if Data.settings_preview.get("cloud_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_CLOUD, icon_cloud, fill=color)
        if Data.settings_preview.get("hotspot_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_WIFI, icon_wifi, fill=color)

        draw.bitmap(Constants.POSITION_SETTINGS, icon_settings, fill="white")

        array_seekbar_rectangles = []

        for i in range(0, Constants.NUM_OF_CHANNELS-1):  # for 4 channels do following:
            if Data.channels_preview[array_3ch[i]]["mute"]:
                draw.bitmap(Constants.MUTE_UNMUTE_POSITIONS[i], icon_mute, fill="white")
            else:
                draw.bitmap(Constants.MUTE_UNMUTE_POSITIONS[i], icon_unmute, fill="white")

            # draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[array_3ch[i]]["name"][0:12], fill="white", font=Font3)
            draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_LABEL_VAR9[i], fill="white", font=Font3)

            draw.rectangle(Constants.FOUR_ITEMS_FILLED_POSITIONS[i], outline="white", width=1)

            array_seekbar_rectangles.append([(76, 32 + i * 20), (76 + int(get_gain_as_slider_progress(Data.channels_preview[array_3ch[i]]["gain_slider"]) / 100 * 33), 39 + i * 20)])

            if 1 == int(Data.channels_preview[array_3ch[i]]["rate_limiter_status"]):  # Orange bar
                draw.rectangle(array_seekbar_rectangles[i], fill=Constants.ORANGE_COLOR)
            elif 2 == int(Data.channels_preview[array_3ch[i]]["rate_limiter_status"]):  # Red bar
                draw.rectangle(array_seekbar_rectangles[i], fill=Constants.RED_COLOR)
            else:  # Normal case: green to red gradient
                temp_img.paste(array_img_volumes[i], Constants.SEEKBAR_POSITIONS[i])

        draw.line(Constants.HOME_SCREEN_LINE_1, fill="white")
        draw.text(Constants.HOME_SCREEN_POS_1, "HOME", fill="white", font=Font1)

        Display.virtual.display(temp_img)
    # 4 CHANNELS VERSION
    else :
        # global ethernet_connected
        temp_img = Image.new(Display.device.mode, (128, 128), color="black")

        base_img = Image.open(img_seekbar_colored_path).convert(Display.device.mode)
        base_img = base_img.resize((33, 17))
        array_img_volumes = []

        for i in range(0, Constants.NUM_OF_CHANNELS):
            sc_bar = get_gain_as_slider_progress(Data.channels_preview[i]["gain_slider"])
            img_volume_channel = base_img.crop((0, 10, int(sc_bar / 100 * 33), 17))
            array_img_volumes.append(img_volume_channel)

        draw = ImageDraw.Draw(temp_img)

        draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
        # draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)
        if (Data.settings_preview.get("amp_standby") == True and Data.settings_preview.get("amp_status") == 1):
            draw.text(Constants.HOME_SCREEN_POS_0, "STANDBY", fill="white", font=Font2)
        elif (Data.settings_preview.get("amp_status") == 2):
            draw.text(Constants.HOME_SCREEN_POS_0, "OVERTEMP", fill=Constants.RED_COLOR, font=Font2)
        elif (Data.settings_preview.get("amp_temperature") >= warning_temperature):
            draw.text(Constants.HOME_SCREEN_POS_0, "TEMP !", fill=Constants.ORANGE_COLOR, font=Font2)
        else:
            draw.text(Constants.HOME_SCREEN_POS_0, "STATUS", fill="white", font=Font2)

        if Constants.HOME_SCREEN_CHANNEL_0_ID <= selected <= Constants.HOME_SCREEN_SETUP_ID:
            draw.rectangle(Constants.HOME_SCREEN_POSITIONS[selected], fill=Constants.GRAY_COLOR)

        last_ethernet_status = ethernet_connected

        if util.is_ethernet_alive():
            color = Constants.GREEN_COLOR
            ethernet_connected = True
        else:
            color = "white"
            ethernet_connected = False
        
        if last_ethernet_status == False and ethernet_connected == True:
            if (bool(Data.settings_preview["cloud_status"])):
                MonitorTask.command_cloud_turn_on_off(bool(Data.settings_preview["cloud_status"]))

        draw.bitmap(Constants.POSITION_ETHERNET, icon_ethernet, fill=color)
        if Data.settings_preview.get("cloud_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_CLOUD, icon_cloud, fill=color)
        if Data.settings_preview.get("hotspot_status"):
            color = Constants.GREEN_COLOR
        else:
            color = "white"
        draw.bitmap(Constants.POSITION_WIFI, icon_wifi, fill=color)

        draw.bitmap(Constants.POSITION_SETTINGS, icon_settings, fill="white")

        array_seekbar_rectangles = []

        for i in range(0, Constants.NUM_OF_CHANNELS):  # for 4 channels do following:
            if Data.channels_preview[i]["mute"]:
                draw.bitmap(Constants.MUTE_UNMUTE_POSITIONS[i], icon_mute, fill="white")
            else:
                draw.bitmap(Constants.MUTE_UNMUTE_POSITIONS[i], icon_unmute, fill="white")

            draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.rectangle(Constants.FOUR_ITEMS_FILLED_POSITIONS[i], outline="white", width=1)

            array_seekbar_rectangles.append([(76, 32 + i * 20), (76 + int(get_gain_as_slider_progress(Data.channels_preview[i]["gain_slider"]) / 100 * 33), 39 + i * 20)])

            if 1 == int(Data.channels_preview[i]["rate_limiter_status"]):  # Orange bar
                draw.rectangle(array_seekbar_rectangles[i], fill=Constants.ORANGE_COLOR)
            elif 2 == int(Data.channels_preview[i]["rate_limiter_status"]):  # Red bar
                draw.rectangle(array_seekbar_rectangles[i], fill=Constants.RED_COLOR)
            else:  # Normal case: green to red gradient
                temp_img.paste(array_img_volumes[i], Constants.SEEKBAR_POSITIONS[i])

        draw.line(Constants.HOME_SCREEN_LINE_1, fill="white")
        draw.text(Constants.HOME_SCREEN_POS_1, "HOME", fill="white", font=Font1)

        Display.virtual.display(temp_img)



def create_screen_main_menu(selected):
    color = "white"

    img_path1 = img_path_1_0
    img_path2 = img_path_2_0
    img_path3 = img_path_3_0
    img_path4 = img_path_4_0
    img_path5 = img_path_5_0
    img_path6 = img_path_6_0

    # overrun for selected image
    if selected == Constants.MENU_SCREEN_AUDIO_ID:
        img_path1 = img_path_1_1
    elif selected == Constants.MENU_SCREEN_PRESETS_ID:
        img_path2 = img_path_2_1
    elif selected == Constants.MENU_SCREEN_HOTSPOT_ID:
        img_path3 = img_path_3_1
    elif selected == Constants.MENU_SCREEN_CLOUD_ID:
        img_path4 = img_path_4_1
    elif selected == Constants.MENU_SCREEN_NETWORK_ID:
        img_path5 = img_path_5_1
    elif selected == Constants.MENU_SCREEN_ABOUT_ID:
        img_path6 = img_path_6_1
#    elif selected == Constants.MENU_SCREEN_BACK_ID:
        

    Icon1 = Image.open(img_path1)
    Icon2 = Image.open(img_path2)
    Icon3 = Image.open(img_path3)
    Icon4 = Image.open(img_path4)
    Icon5 = Image.open(img_path5)
    Icon6 = Image.open(img_path6)

    with canvas(Display.virtual) as draw:
        draw.bitmap(Constants.MAIN_MENU_POS_1, Icon1, fill="white")
        draw.bitmap(Constants.MAIN_MENU_POS_2, Icon2, fill="white")
        draw.bitmap(Constants.MAIN_MENU_POS_3, Icon3, fill="white")
        draw.bitmap(Constants.MAIN_MENU_POS_4, Icon4, fill="white")
        draw.bitmap(Constants.MAIN_MENU_POS_5, Icon5, fill="white")
        draw.bitmap(Constants.MAIN_MENU_POS_6, Icon6, fill="white")
        if selected == Constants.MENU_SCREEN_BACK_ID:    
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

        draw.line(Constants.BOTTOM_LINE, fill="white")
        draw.text(Constants.BOTTOM_TEXT_POS, "MENU", fill="white", font=Font1)


def create_screen_audio_menu(selected):
    color = "white"
    icons = []

    if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        if selected == Constants.MENU_AUDIO_SCREEN_SOURCE_ID:
            icons = [Image.open(img_source_1), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_signalgen_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_GAIN_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_1), Image.open(img_delay_0), Image.open(img_signalgen_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_DELAY_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_1), Image.open(img_signalgen_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_SIGGEN_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_signalgen_1)]
        elif selected == Constants.MENU_AUDIO_SCREEN_BACK_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_signalgen_0)]

        with canvas(Display.virtual) as draw:
            for i in range(0, 4):
                draw.bitmap(Constants.MAIN_AUDIO_MENU_POSITIONS[i], icons[i], fill="white")
            if selected == Constants.MENU_AUDIO_SCREEN_BACK_ID:    
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO", fill="white", font=Font1)
    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        if selected == Constants.MENU_AUDIO_SCREEN_SOURCE_ID:
            icons = [Image.open(img_source_1), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_signalgen_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_GAIN_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_1), Image.open(img_delay_0), Image.open(img_signalgen_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_DELAY_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_1), Image.open(img_signalgen_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_SIGGEN_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_signalgen_1)]
        elif selected == Constants.MENU_AUDIO_SCREEN_BACK_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_signalgen_0)]

        with canvas(Display.virtual) as draw:
            for i in range(0, 4):
                draw.bitmap(Constants.MAIN_AUDIO_MENU_POSITIONS[i], icons[i], fill="white")
            if selected == Constants.MENU_AUDIO_SCREEN_BACK_ID:    
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO", fill="white", font=Font1)
    else:
        if selected == Constants.MENU_AUDIO_SCREEN_SOURCE_ID:
            icons = [Image.open(img_source_1), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_peq_0), Image.open(img_xover_0), Image.open(img_limiter_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_GAIN_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_1), Image.open(img_delay_0), Image.open(img_peq_0), Image.open(img_xover_0), Image.open(img_limiter_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_DELAY_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_1), Image.open(img_peq_0), Image.open(img_xover_0), Image.open(img_limiter_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_PEQ_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_peq_1), Image.open(img_xover_0), Image.open(img_limiter_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_XOVER_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_peq_0), Image.open(img_xover_1), Image.open(img_limiter_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_LIMITER_ID:
            icons = [Image.open(img_source_0), Image.open(img_gain_0), Image.open(img_delay_0), Image.open(img_peq_0), Image.open(img_xover_0), Image.open(img_limiter_1)]
        elif selected == Constants.MENU_AUDIO_SCREEN_SIGGEN_ID:
            icons = [Image.open(img_signalgen_1), Image.open(img_empty_0), Image.open(img_empty_0), Image.open(img_empty_0), Image.open(img_empty_0), Image.open(img_empty_0)]
        elif selected == Constants.MENU_AUDIO_SCREEN_BACK_ID:
            icons = [Image.open(img_signalgen_0), Image.open(img_empty_0), Image.open(img_empty_0), Image.open(img_empty_0), Image.open(img_empty_0), Image.open(img_empty_0)]
    #        color = "gray"

        with canvas(Display.virtual) as draw:
            for i in range(0, 6):
                draw.bitmap(Constants.MAIN_AUDIO_MENU_POSITIONS[i], icons[i], fill="white")
            if selected == Constants.MENU_AUDIO_SCREEN_BACK_ID:    
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO", fill="white", font=Font1)


def create_screen_presets_menu(selected):
    color = "white"
    icons = []

    if selected == Constants.MENU_PRESETS_SCREEN_GLOBAL_ID:
        icons = [Image.open(img_global_preset_1), Image.open(img_speaker_preset_0)]
    elif selected == Constants.MENU_PRESETS_SCREEN_SPEAKER_ID:
        icons = [Image.open(img_global_preset_0), Image.open(img_speaker_preset_1)]
    elif selected == Constants.MENU_PRESETS_SCREEN_BACK_ID:
        icons = [Image.open(img_global_preset_0), Image.open(img_speaker_preset_0)]
#        color = "gray"

    with canvas(Display.virtual) as draw:
        for i in range(0, 2):
            draw.bitmap(Constants.PRESET_POSITIONS[i], icons[i], fill="white")
        if selected == Constants.MENU_PRESETS_SCREEN_BACK_ID:    
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

        draw.line(Constants.BOTTOM_LINE, fill="white")
        draw.text(Constants.BOTTOM_TEXT_POS, "PRESETS", fill="white", font=Font1)


def create_screen_hotspot_menu(selected, is_in_focus):
    color = "white"

    hotspotStatus = Data.settings_preview.get("hotspot_status")
    if hotspotStatus:
        status = "ON"
    else:
        status = "OFF"

    with canvas(Display.virtual) as draw:
        if selected == Constants.HOTSPOT_SCREEN_ON_OFF_ID:
            draw.rectangle(Constants.HOTSPOT_SCREEN_ON_OFF_RECTANGLE_1, fill=Constants.GRAY_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.HOTSPOT_SCREEN_ON_OFF_RECTANGLE_1, outline="white", width=1)
        elif selected == Constants.HOTSPOT_SCREEN_BACK_ID:
#            color = "gray"  
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

        draw.text(Constants.THREE_ITEM_MENU_EDIT_FIELD_POS_1, status, fill="white", font=Font3)
        draw.text(Constants.THREE_ITEM_MENU_EDIT_FIELD_POS_2, Data.settings_preview.get("SSID"), fill="white", font=Font3)
        draw.text(Constants.THREE_ITEM_MENU_EDIT_FIELD_POS_3, Data.settings_preview.get("hotspot_pass"), fill="white", font=Font3)

        draw.text(Constants.THREE_ITEM_MENU_TEXT_BOX_POS_1, "Hotspot", fill="white", font=Font3)
        draw.text(Constants.THREE_ITEM_MENU_TEXT_BOX_POS_2, "SSID", fill="white", font=Font3)
        draw.text(Constants.THREE_ITEM_MENU_TEXT_BOX_POS_3, "Password", fill="white", font=Font3)

        draw.line(Constants.BOTTOM_LINE, fill="white")
        draw.text(Constants.BOTTOM_TEXT_POS, "HOTSPOT", fill="white", font=Font1)


def create_screen_network_menu(selected, is_in_focus):
    color = "white"

    if Data.settings_preview.get("new_network_mode"):
        mode = "STATIC"
    else:
        mode = "DHCP"

    ip = str(Data.settings_preview.get("new_IP")[0]) + "." + str(Data.settings_preview.get("new_IP")[1]) + "." + \
         str(Data.settings_preview.get("new_IP")[2]) + "." + str(Data.settings_preview.get("new_IP")[3])
    subnet = str(Data.settings_preview.get("new_subnet")[0]) + "." + str(Data.settings_preview.get("new_subnet")[1]) + "." + \
             str(Data.settings_preview.get("new_subnet")[2]) + "." + str(Data.settings_preview.get("new_subnet")[3])
    gateway = str(Data.settings_preview.get("new_gateway")[0]) + "." + str(Data.settings_preview.get("new_gateway")[1]) + "." + \
             str(Data.settings_preview.get("new_gateway")[2]) + "." + str(Data.settings_preview.get("new_gateway")[3])

    with canvas(Display.virtual) as draw:
        if selected == Constants.NETWORK_SCREEN_MODE_ID:
            draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_1, fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_1, outline="white", width=1)
        elif selected == Constants.NETWORK_SCREEN_IP_0_ID or selected == Constants.NETWORK_SCREEN_IP_1_ID \
                or selected == Constants.NETWORK_SCREEN_IP_2_ID or selected == Constants.NETWORK_SCREEN_IP_3_ID:
            draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_2, fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_2, outline="white", width=1)

        elif selected == Constants.NETWORK_SCREEN_SUBNET_0_ID or selected == Constants.NETWORK_SCREEN_SUBNET_1_ID \
                or selected == Constants.NETWORK_SCREEN_SUBNET_2_ID or selected == Constants.NETWORK_SCREEN_SUBNET_3_ID:
            draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_3, fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_3, outline="white", width=1)

        elif selected == Constants.NETWORK_SCREEN_GW_0_ID or selected == Constants.NETWORK_SCREEN_GW_1_ID \
                or selected == Constants.NETWORK_SCREEN_GW_2_ID or selected == Constants.NETWORK_SCREEN_GW_3_ID:
            draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_4, fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLE_4, outline="white", width=1)
                
        elif selected == Constants.NETWORK_SCREEN_BACK_ID:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY2_COLOR) #create filled rectangle if selected
        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

        draw.text(Constants.FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_1, mode, fill=Constants.GREEN_COLOR, font=Font3)
        draw.text(Constants.FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_2, ip, fill=Constants.GREEN_COLOR, font=Font3)
        draw.text(Constants.FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_3, subnet, fill=Constants.GREEN_COLOR, font=Font3)
        draw.text(Constants.FOUR_ITEM_NETWORK_MENU_EDIT_FIELD_POS_4, gateway, fill=Constants.GREEN_COLOR, font=Font3)

        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POS_1, "Mode", fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POS_2, "IP", fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POS_3, "Subnet", fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POS_4, "GW", fill="white", font=Font3)

        draw.line(Constants.BOTTOM_LINE, fill="white")
        draw.text(Constants.BOTTOM_TEXT_POS, "NETWORK", fill="white", font=Font1)


def create_screen_about():
    with canvas(Display.virtual) as draw:

        with open(PEAK_READBACK_FILE, "r", os.O_NONBLOCK) as readback_file:
            raw_readback_data = readback_file.read()
        try:
            # convert dictionary string to dictionary
            readback_data = json.loads(raw_readback_data)
        except Exception:
            return

        temp_t = 0
        volt_t = 0
        standby_t = 0
        status_t = 0

        for i in range (0, Constants.NUM_OF_MODULES):
            if (temp_t < readback_data[TEMP + str(i+1)]):
                temp_t = readback_data[TEMP + str(i+1)]
            if (volt_t < readback_data[VOLTAGE + str(i+1)]):
                volt_t = readback_data[VOLTAGE + str(i+1)]
            if (standby_t < readback_data[AMP_ON + str(i+1)]):
                standby_t = readback_data[AMP_ON + str(i+1)]
            if (status_t < readback_data[OVERTEMP + str(i+1)]):
                status_t = readback_data[OVERTEMP + str(i+1)]

        Data.settings_preview["amp_temperature"] = temp_t
        Data.settings_preview["amp_voltage"] = volt_t
        if (standby_t == 0):
            Data.settings_preview["amp_standby"] = True
        else:
            Data.settings_preview["amp_standby"] = False
        if (status_t == 0):
            Data.settings_preview["amp_status"] = 1
        else:
            Data.settings_preview["amp_status"] = 2

        draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
        draw.bitmap(Constants.POSITION_BACK, icon_back, fill="white")
        draw.text(Constants.ABOUT_SCREEN_POS_1_1, "App version", fill="white", font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_1_2, Constants.LOCAL_APP_VERSION, fill=Constants.GREEN_COLOR, font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_2_1, "Service version", fill="white", font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_2_2, Data.settings_preview["version"], fill=Constants.GREEN_COLOR, font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_3_1, "Temperature", fill="white", font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_3_2, str(Data.settings_preview.get("amp_temperature")) + "°C", fill=Constants.GREEN_COLOR, font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_4_1, "Power amp state", fill="white", font=Font3)
        if (Data.settings_preview["amp_standby"] == False):
            draw.text(Constants.ABOUT_SCREEN_POS_4_2, "ON", fill=Constants.GREEN_COLOR, font=Font3)
            # draw.text(Constants.ABOUT_SCREEN_POS_4_2, str(Data.settings_preview["amp_standby"]), fill=Constants.GREEN_COLOR, font=Font3)
        else:
            draw.text(Constants.ABOUT_SCREEN_POS_4_2, "Standby", fill=Constants.RED_COLOR, font=Font3)
            # draw.text(Constants.ABOUT_SCREEN_POS_4_2, str(Data.settings_preview["amp_standby"]), fill=Constants.RED_COLOR, font=Font3)
        draw.text(Constants.ABOUT_SCREEN_POS_5_1, "Status", fill="white", font=Font3)
        if (Data.settings_preview["amp_status"] == 1):
            draw.text(Constants.ABOUT_SCREEN_POS_5_2, "-OK-", fill=Constants.GREEN_COLOR, font=Font3)
        elif (Data.settings_preview["amp_status"] == 2):
            draw.text(Constants.ABOUT_SCREEN_POS_5_2, "-OTP-", fill=Constants.RED_COLOR, font=Font3)
        else:
            draw.text(Constants.ABOUT_SCREEN_POS_5_2, "-NYI-", fill="white", font=Font3)

        draw.line(Constants.BOTTOM_LINE, fill="white")
        draw.text(Constants.BOTTOM_TEXT_POS, "ABOUT", fill="white", font=Font1)


def create_screen_cloud_menu(selected, is_in_focus):
    color = "white"
    cloudStatus = Data.settings_preview.get("cloud_status")
    if cloudStatus:
        status = "ON"
    else:
        status = "OFF"

    with canvas(Display.virtual) as draw:
        if selected == Constants.CLOUD_SCREEN_ON_OFF_ID:
            draw.rectangle(Constants.CLOUD_SCREEN_ON_OFF_RECTANGLE_1, fill=Constants.GRAY_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.CLOUD_SCREEN_ON_OFF_RECTANGLE_1, outline="white", width=1)
        elif selected == Constants.CLOUD_SCREEN_BACK_ID:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

        draw.text(Constants.FOUR_ITEM_MENU_CLOUD_POSITIONS[0], status, fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_CLOUD_POSITIONS[1], Data.settings_preview.get("cloud_device_name"), fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_CLOUD_POSITIONS[2], Data.settings_preview.get("cloud_user"), fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_CLOUD_POSITIONS[3], Data.settings_preview.get("cloud_pass"), fill="white", font=Font3)

        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[0], "Cloud", fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[1], "Name", fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[2], "User", fill="white", font=Font3)
        draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[3], "Pass", fill="white", font=Font3)

        draw.line(Constants.BOTTOM_LINE, fill="white")
        draw.text((0, 115), "CLOUD", fill="white", font=Font1)

def create_screen_audio_siggen(selected, is_in_focus):
    color = "white"
    with canvas(Display.virtual) as draw:
        if Constants.MENU_AUDIO_SIGGEN_SCREEN_FREQ_FREQ_ID <= selected <= Constants.MENU_AUDIO_SIGGEN_SCREEN_PINK_GAIN_ID:
            if selected == 0:
                selected_siggen = 2
            elif selected == 1:
                selected_siggen = 3
            elif selected == 2:
                selected_siggen = 5
            draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected_siggen], fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected_siggen], outline="white", width=1)
        if selected == Constants.MENU_AUDIO_SIGGEN_SCREEN_BACK_ID:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

        #TO DO

        # FREQ GEN
        draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[1], "Sinewave gen :", fill="white", font=Font3)

        # FREQUENCY GENERATOR FREQUENCY
        draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[2], "  Freq :", fill="white", font=Font3)
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[2],"  " +
                  str(round(Data.settings_preview["signal_generator"]["frequency_generator"]["frequency"])) + " Hz", fill=Constants.GREEN_COLOR, font=Font3)

        # FREQUENCY GENERATOR GAIN
        draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[3], "  Gain :", fill="white", font=Font3)
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[3], "  " +
            str(round(Data.settings_preview["signal_generator"]["frequency_generator"]["gain"],1)) + " dB", fill=Constants.GREEN_COLOR, font=Font3)

        # PINK NOISE
        draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[4], "Pink noise gen :", fill="white", font=Font3)


        # PINK NOISE GAIN
        draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[5], "  Gain :", fill="white", font=Font3)
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[5], "  " +
            str(round(Data.settings_preview["signal_generator"]["pink_noise"]["gain"],1)) + " dB", fill=Constants.GREEN_COLOR, font=Font3)

        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
        draw.line(Constants.BOTTOM_LINE, fill="white")
        label= "SIGNAL GEN."
        draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)

def create_screen_audio_limiter(selected, is_in_focus):
    color = "white"
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_XOVER_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.MUTE_UNMUTE_POSITIONS_16[i], "=>", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - LIM", fill="white", font=Font1)
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        pass
    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        pass
    else :
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_LIMITER_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "=> Edit", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - LIM", fill="white", font=Font1)

def create_screen_audio_limiter_edit(selected, is_in_focus, selected_channel, selected_peq):
    color = "white"
    with canvas(Display.virtual) as draw:
        if Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_MODE_ID <= selected <= Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_REL_ID:
            draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
        if selected == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_BACK_ID:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

        for i in range(0, 6):
            draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[i],Constants.LIMITER_EDIT_LABELS[i], fill="white", font=Font3)

        # LIMITER MODE
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[0], Constants.LIMITER_TYPE_LABELS[selected_peq], fill=Constants.GREEN_COLOR, font=Font3)

        # LIMITER RMS_THRES AND PEAK_THRES RELATED TO LIMITER MODE
        if selected_peq == 0:
            #Threshold in VRMS
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], str(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_thres"],1)) + " Vrms", fill=Constants.GREEN_COLOR, font=Font3)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], str(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_thres"],1)) + " Vpeak", fill=Constants.GREEN_COLOR, font=Font3)
        elif selected_peq == 1:
            #Thresold in W RMS for a 2 Ohms load
            watt_2_rms = round(pow(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_thres"],1),2)/2)
            watt_2_peak = round(pow(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_thres"],1),2)/2)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], str(watt_2_rms) + " Wrms", fill=Constants.GREEN_COLOR, font=Font3)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], str(watt_2_peak) + " Wpeak", fill=Constants.GREEN_COLOR, font=Font3)
        elif selected_peq == 2:
            #Thresold in W RMS for a 2.7 Ohms load
            watt_27_rms = round(pow(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_thres"],1),2)/2.7)
            watt_27_peak = round(pow(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_thres"],1),2)/2.7)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], str(watt_27_rms) + " Wrms", fill=Constants.GREEN_COLOR, font=Font3)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], str(watt_27_peak) + " Wpeak", fill=Constants.GREEN_COLOR, font=Font3)
            
        elif selected_peq == 3:
            #Thresold in W RMS for a 4 Ohms load
            watt_4_rms = round(pow(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_thres"],1),2)/4)
            watt_4_peak = round(pow(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_thres"],1),2)/4)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], str(watt_4_rms) + " Wrms", fill=Constants.GREEN_COLOR, font=Font3)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], str(watt_4_peak) + " Wpeak", fill=Constants.GREEN_COLOR, font=Font3)

        elif selected_peq == 4:
            #Thresold in W RMS for a 8 Ohms load
            watt_8_rms = round(pow(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_thres"],1),2)/8)
            watt_8_peak = round(pow(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_thres"],1),2)/8)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], str(watt_8_rms) + " Wrms", fill=Constants.GREEN_COLOR, font=Font3)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], str(watt_8_peak) + " Wpeak", fill=Constants.GREEN_COLOR, font=Font3)

        elif selected_peq == 5:
            #Thresold in W RMS for a 16 Ohms load
            watt_16_rms = round(pow(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_thres"],1),2)/16)
            watt_16_peak = round(pow(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_thres"],1),2)/16)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], str(watt_16_rms) + " Wrms", fill=Constants.GREEN_COLOR, font=Font3)
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], str(watt_16_peak) + " Wpeak", fill=Constants.GREEN_COLOR, font=Font3)
        else:
            print("Invalid argument")

        # LIMITER RMS_ATTACK
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[2], 
            str(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_attack"],1)) + " ms", fill=Constants.GREEN_COLOR, font=Font3)
        # LIMITER RMS_RELEASE
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[3], 
            str(round(Data.channels_preview[selected_channel]["lim_rms"]["lim_rms_release"],1)) + " ms", fill=Constants.GREEN_COLOR, font=Font3)
        # PEAK RELEASE
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[5], 
            str(round(Data.channels_preview[selected_channel]["lim_peak"]["lim_peak_release"],1)) + " ms", fill=Constants.GREEN_COLOR, font=Font3)

        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
        draw.line(Constants.BOTTOM_LINE, fill="white")
        label= "CH "+str(Constants.CHANNEL_NAME[selected_channel])+" - LIM"
        draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)

def create_screen_audio_xover(selected, is_in_focus):
    color = "white"
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_XOVER_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.MUTE_UNMUTE_POSITIONS_16[i], "=>", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - XOVER", fill="white", font=Font1)
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        pass
    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        pass
    else :
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_XOVER_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "=> Edit", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - XOVER", fill="white", font=Font1)

def create_screen_audio_xover_edit(selected, is_in_focus, selected_channel, selected_peq):
    color = "white"
    with canvas(Display.virtual) as draw:
        if Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_INDEX_ID <= selected <= Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_FREQ_ID:
            draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
        if selected == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_BACK_ID:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

        for i in range(0, 4):
            draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.XOVER_EDIT_LABELS[i], fill="white", font=Font3)

        # XOVER INDEX (0 = HPF / 1 = LPF)
        if selected_peq == 0 :
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[0], "High Pass", fill=Constants.GREEN_COLOR, font=Font3)
        else:
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[0], "Low Pass", fill=Constants.GREEN_COLOR, font=Font3)
        # XOVER ENABLE
        if selected_peq == 0:
            if(Data.channels_preview[selected_channel]["xover_hp_filter"]["xover_hp_enable"]):
                draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], "On", fill=Constants.GREEN_COLOR, font=Font3)
            else:
                draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], "Off", fill=Constants.GREEN_COLOR, font=Font3)
        else:
            if(Data.channels_preview[selected_channel]["xover_lp_filter"]["xover_lp_enable"]):
                draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], "On", fill=Constants.GREEN_COLOR, font=Font3)
            else:
                draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], "Off", fill=Constants.GREEN_COLOR, font=Font3)
        # XOVER TYPE
        if selected_peq == 0:
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[2], Constants.XOVER_TYPE[Data.channels_preview[selected_channel]["xover_hp_filter"]["xover_hp_type"]], fill=Constants.GREEN_COLOR, font=Font3)
        else:
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[2], Constants.XOVER_TYPE[Data.channels_preview[selected_channel]["xover_lp_filter"]["xover_lp_type"]], fill=Constants.GREEN_COLOR, font=Font3)
        # XOVER FREQ
        if selected_peq == 0:
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[3], str(round(Data.channels_preview[selected_channel]["xover_hp_filter"]["xover_hp_freq"],0)) + " Hz", fill=Constants.GREEN_COLOR, font=Font3)
        else:
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[3], str(round(Data.channels_preview[selected_channel]["xover_lp_filter"]["xover_lp_freq"],0)) + " Hz", fill=Constants.GREEN_COLOR, font=Font3)

        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
        draw.line(Constants.BOTTOM_LINE, fill="white")
        label= "CH "+str(Constants.CHANNEL_NAME[selected_channel])+" - XOVER"
        draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)

def create_screen_audio_peq(selected, is_in_focus):
    color = "white"
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_PEQ_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.MUTE_UNMUTE_POSITIONS_16[i], "=>", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - PEQ", fill="white", font=Font1)
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        pass
    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        pass
    else:
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_PEQ_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "=> Edit", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - PEQ", fill="white", font=Font1)

def create_screen_audio_peq_edit(selected, is_in_focus, selected_channel, selected_peq):
    color = "white"
    with canvas(Display.virtual) as draw:
        if Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID <= selected <= Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_Q_ID:
            draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
            if is_in_focus:
                draw.rectangle(Constants.SIX_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
        if selected == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_BACK_ID:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

        for i in range(0, 6):
            draw.text(Constants.SIX_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.PEQ_EDIT_LABELS[i], fill="white", font=Font3)

        # PEQ INDEX
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[0], str(round((selected_peq+1),0)), fill=Constants.GREEN_COLOR, font=Font3)
        # PEQ ENABLE
        if(Data.channels_preview[selected_channel]["peq"][selected_peq]["enable"]):
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], "On", fill=Constants.GREEN_COLOR, font=Font3)
        else:
            draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[1], "Off", fill=Constants.GREEN_COLOR, font=Font3)
        # PEQ TYPE
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[2], 
                Constants.PEQ_TYPE[Data.channels_preview[selected_channel]["peq"][selected_peq]["type"]], fill=Constants.GREEN_COLOR, font=Font3)
        # PEQ FREQ
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[3], 
                str(round(Data.channels_preview[selected_channel]["peq"][selected_peq]["freq"],0)) + " Hz", fill=Constants.GREEN_COLOR, font=Font3)
        # PEQ GAIN
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[4], 
                str(round(Data.channels_preview[selected_channel]["peq"][selected_peq]["gain"],1)) + " dB", fill=Constants.GREEN_COLOR, font=Font3)
        # PEQ Q
        draw.text(Constants.SIX_ITEM_MENU_EDIT_FIELD_POSITIONS[5], 
                str(round(Data.channels_preview[selected_channel]["peq"][selected_peq]["q"],1)), fill=Constants.GREEN_COLOR, font=Font3)

        draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
        draw.line(Constants.BOTTOM_LINE, fill="white")
        label= "CH "+str(Constants.CHANNEL_NAME[selected_channel])+" - PEQs"
        draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)


def create_screen_audio_delay(selected, is_in_focus):
    color = "white"
    #16 CHANNELS VERSION
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE =="variant8.code"):
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            #draw channel name on the top of the screen
            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]  + " (ms)"
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                if round(Data.channels_preview[i]["delay"],1) < 100:
                    delay = round(Data.channels_preview[i]["delay"],1)
                else:
                    delay = round(Data.channels_preview[i]["delay"])
                draw.text(Constants.DELAY_VALUE_POSITIONS_16[i], str(delay), fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Delay", fill="white", font=Font1)
    #1 CHANNEL VERSION
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        color = "white"
        with canvas(Display.virtual) as draw:

            if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID == selected:
                draw.rectangle(Constants.ONE_ITEM_MENU_RECTANGLE, fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.ONE_ITEM_MENU_RECTANGLE, outline="white", width=1)
            if selected == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            draw.text(Constants.ONE_ITEM_MENU_EDIT_FIELD_POSITION, str(round(Data.channels_preview[0]["delay"], 1)) + " ms", fill=Constants.GREEN_COLOR, font=Font1)
            draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[0], "Delay :", fill="white", font=Font1)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Delay", fill="white", font=Font1)
    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        pass
    #4 CHANNELS VERSION
    else:
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i],str(round(Data.channels_preview[i]["delay"], 1)) + " ms", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Delay", fill="white", font=Font1)


def create_screen_audio_gain(selected, is_in_focus):
    color = "white"
    #16 CHANNELS VERSION
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            #draw channel name on the top of the screen
            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]  + " (dB)"
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                gain = round(Data.channels_preview[i]["gain"])
                draw.text(Constants.MUTE_UNMUTE_POSITIONS_16[i], str(gain), fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Gain", fill="white", font=Font1)

    #1 CHANNEL VERSION
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        color = "white"
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID == selected:
                draw.rectangle(Constants.ONE_ITEM_MENU_RECTANGLE, fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.ONE_ITEM_MENU_RECTANGLE, outline="white", width=1)
            if selected == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            gain = round(Data.channels_preview[0]["gain"], 1)
            if gain == -0.0:
                gain = 0.0
            draw.text(Constants.ONE_ITEM_MENU_EDIT_FIELD_POSITION, str(gain) + " dB", fill=Constants.GREEN_COLOR, font=Font1)
            draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[0], "Gain :", fill="white",font=Font1)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Gain", fill="white", font=Font1)

    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        pass
    #4 CHANNELS VERSION
    else:
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                gain = round(Data.channels_preview[i]["gain"], 1)
                if gain == -0.0:
                    gain = 0.0
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i], str(gain) + " dB", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Gain", fill="white", font=Font1)


def create_screen_audio_source(selected, is_in_focus):
    color = "white"
    # 16 CHANNELS VERSION
    if CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code":
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            #draw channel name on the top of the screen
            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.MUTE_UNMUTE_POSITIONS_16[i], "=>", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Mixer", fill="white", font=Font1)

    # 1 CHANNEL VERSION
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        pass

    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS-1):
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "=> Edit", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_LABEL_VAR9[i], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Mixer", fill="white", font=Font1)

    # 4 CHANNELS VERSION
    else:
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID:
                draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.FOUR_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "=> Edit", fill=Constants.GREEN_COLOR, font=Font3)
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "AUDIO - Mixer", fill="white", font=Font1)


def create_screen_audio_source_edit(selected, is_in_focus, selected_channel):
    color = "white"
    # 16 CHANNELS VERSION
    if CURRENT_VARIANT_VALUE == "variant7.code":
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= selected <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                draw.rectangle(Constants.NINE_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.NINE_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            for i in range(0, Constants.NUM_OF_INPUTS):
                if i<=4 or i >=8:
                    if i == 4:
                        draw.text(Constants.TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.NETWORK_SOURCE_LABELS[selected_channel], fill="white", font=Font3)
                    else : 
                        draw.text(Constants.TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.SOURCE_EDIT_LABELS[i], fill="white", font=Font3)

                    if Data.channels_preview[selected_channel]["mixer"][i]["gain"] > -80.0 :
                        draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], 
                            str(round(Data.channels_preview[selected_channel]["mixer"][i]["gain"],1))+"dB", fill=Constants.GREEN_COLOR, font=Font3)
                    else:
                        draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill=Constants.GREEN_COLOR, font=Font3)

            draw.line(Constants.VERT_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.VERT_LINE_2_3, fill=Constants.GRAY_COLOR)

            draw.line(Constants.HORI_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_2_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_3_3, fill=Constants.GRAY_COLOR)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            label= "CH "+ str(Constants.CHANNEL_NAME[selected_channel]) +" - MIXER"
            draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)
    
    # 16 CHANNELS WITH 4 DANTE INPUTS
    elif CURRENT_VARIANT_VALUE == "variant8.code":
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= selected <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            for i in range(0, Constants.NUM_OF_INPUTS):
                draw.text(Constants.TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.SOURCE_EDIT_LABELS[i], fill="white", font=Font3)

                if Data.channels_preview[selected_channel]["mixer"][i]["gain"] > -80.0 :
                    draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], 
                        str(round(Data.channels_preview[selected_channel]["mixer"][i]["gain"],1))+"dB", fill=Constants.GREEN_COLOR, font=Font3)
                else:
                    draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill=Constants.GREEN_COLOR, font=Font3)

            draw.line(Constants.VERT_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.VERT_LINE_2_3, fill=Constants.GRAY_COLOR)

            draw.line(Constants.HORI_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_2_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_3_3, fill=Constants.GRAY_COLOR)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            label= "CH " + str(Constants.CHANNEL_NAME[selected_channel]) + " - MIXER"
            draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)

    # 1 CHANNEL VERSION
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        color = "white"
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= selected <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
            
            j = 0
            for i in range(0, Constants.NUM_OF_INPUTS):
                if i==0 or i > 7:
                    draw.text(Constants.TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.SOURCE_EDIT_LABELS[j], fill="white", font=Font3)
                    j+=1
                    if Data.channels_preview[selected_channel]["mixer"][i]["gain"] > -80.0 :
                        draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], 
                            str(round(Data.channels_preview[selected_channel]["mixer"][i]["gain"],1))+"dB", fill=Constants.GREEN_COLOR, font=Font3)
                    else:
                        draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill=Constants.GREEN_COLOR, font=Font3)
                else:
                    draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill="white", font=Font3)

            draw.line(Constants.VERT_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.VERT_LINE_2_3, fill=Constants.GRAY_COLOR)

            draw.line(Constants.HORI_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_2_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_3_3, fill=Constants.GRAY_COLOR)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            label= "INPUT - MIXER"
            draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)

    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        color = "white"
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= selected <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected
            
            j = 0
            for i in range(0, Constants.NUM_OF_INPUTS):
                if i < 2 or i > 7:
                    draw.text(Constants.TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.SOURCE_EDIT_LABELS[j], fill="white", font=Font3)
                    j+=1
                    if Data.channels_preview[selected_channel]["mixer"][i]["gain"] > -80.0 :
                        if (i == 1):
                            draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], str(round(Data.channels_preview[selected_channel]["mixer"][2]["gain"],1))+"dB", fill=Constants.GREEN_COLOR, font=Font3)
                        else:
                            draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], str(round(Data.channels_preview[selected_channel]["mixer"][i]["gain"],1))+"dB", fill=Constants.GREEN_COLOR, font=Font3)

                    else:
                        draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill=Constants.GREEN_COLOR, font=Font3)
                else:
                    draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill="white", font=Font3)

            draw.line(Constants.VERT_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.VERT_LINE_2_3, fill=Constants.GRAY_COLOR)

            draw.line(Constants.HORI_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_2_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_3_3, fill=Constants.GRAY_COLOR)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            label= "INPUT - MIXER"
            draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)

    # 4 CHANNELS VERSION
    else:
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= selected <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY2_COLOR)
                if is_in_focus:
                    draw.rectangle(Constants.TWELVE_ITEM_MENU_RECTANGLES[selected], outline="white", width=1)
            if selected == Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            for i in range(0, Constants.NUM_OF_INPUTS):
                draw.text(Constants.TWELVE_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.SOURCE_EDIT_LABELS[i],
                        fill="white", font=Font3)

            for i in range(0, Constants.NUM_OF_INPUTS):
                if Data.channels_preview[selected_channel]["mixer"][i]["gain"] > -80.0 :
                    draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], 
                        str(round(Data.channels_preview[selected_channel]["mixer"][i]["gain"],1))+"dB", fill=Constants.GREEN_COLOR, font=Font3)
                else:
                    draw.text(Constants.TWELVE_ITEM_MENU_EDIT_FIELD_POSITIONS[i], "OFF", fill=Constants.GREEN_COLOR, font=Font3)

            draw.line(Constants.VERT_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.VERT_LINE_2_3, fill=Constants.GRAY_COLOR)

            draw.line(Constants.HORI_LINE_1_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_2_3, fill=Constants.GRAY_COLOR)
            draw.line(Constants.HORI_LINE_3_3, fill=Constants.GRAY_COLOR)

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            label= "CH " + str(Constants.CHANNEL_NAME[selected_channel]) +" - MIXER"
            draw.text(Constants.BOTTOM_TEXT_POS, str(label), fill="white", font=Font1)


def create_screen_file_system(screen_type, selected, start_position, stop_position):
    color = "white"
    with canvas(Display.virtual) as draw:
        if 0 <= selected < 8:
            draw.rectangle(Constants.EIGHT_ITEM_MENU_RECTANGLES[selected], fill=Constants.GRAY_COLOR)
        if selected == 8:
            draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

        positions = Constants.FILE_SYSTEMS_POSITIONS
        iterator = 0

        if screen_type == Constants.SCREEN_FOLDERS_GLOBAL_PRESETS_ID:
            for i in range(start_position, stop_position + 1, 1):
                draw.text(positions[iterator], Data.folder_names[i], fill="white", font=Font3)
                iterator += 1
            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "PRESETS - Global", fill="white", font=Font1)
        elif screen_type == Constants.SCREEN_FILES_GLOBAL_PRESETS_ID:
            for i in range(start_position, stop_position + 1, 1):
                draw.text(positions[iterator], Data.file_names[i], fill="white", font=Font3)
                iterator += 1
            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "PRESETS - Global", fill="white", font=Font1)
        elif screen_type == Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID:
            for i in range(start_position, stop_position + 1, 1):
                draw.text(positions[iterator], Data.folder_names[i], fill="white", font=Font3)
                iterator += 1
            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "PRESETS -Speaker", fill="white", font=Font1)
        elif screen_type == Constants.SCREEN_FILES_SPEAKER_PRESETS_ID:
            for i in range(start_position, stop_position + 1, 1):
                # if (Data.settings_preview["oem_status"] == True and Data.file_names[i] == "Blank Preset"):
                #     draw.text(positions[iterator], Data.file_names[i] + " (locked)", fill="white", font=Font3)
                # else:
                draw.text(positions[iterator], Data.file_names[i], fill="white", font=Font3)
                iterator += 1

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "PRESETS -Speaker", fill="white", font=Font1)


def create_screen_choose_channel(selected):
    color = "white"
    # 16 CHANNELS VERSION
    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
        with canvas(Display.virtual) as draw:
            if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= selected <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_15_ID:
                draw.rectangle(Constants.HOME_SCREEN_SIXTEEN_POSITIONS[selected], fill=Constants.GRAY2_COLOR)
            if selected == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            #draw channel name on the top of the screen
            draw.line(Constants.HOME_SCREEN_LINE_0, fill="white")
            if(selected<Constants.NUM_OF_CHANNELS):
                label= "=> "+ Data.channels_preview[selected]["name"]
                draw.text(Constants.HOME_SCREEN_POS_0, label, fill="white", font=Font3)
            else:
                draw.text(Constants.HOME_SCREEN_POS_0, "=> Back", fill="white", font=Font3)
            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.SIXTEEN_ITEM_MENU_TEXT_BOX_POSITIONS[i], Constants.CHANNEL_NAME[i], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")
            draw.text(Constants.BOTTOM_TEXT_POS, "Choose one channel:", fill="white", font=Font1)
    # 1 CHANNEL VERSION
    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
        with canvas(Display.virtual) as draw:
            draw.text(Constants.TOP_TEXT_POS, "Choose one channel:", fill="white", font=Font3)

            if Constants.CHOOSE_CHANNEL_1_ID <= selected <= Constants.CHOOSE_CHANNEL_4_ID:
                draw.rectangle(Constants.CHOOSE_CHANNEL_RECTANGLE_POSITIONS[selected], fill=Constants.GRAY_COLOR)
            if selected == Constants.CHOOSE_CHANNEL_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], Data.channels_preview[i]["name"][0:12], fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")

    # AMP PLATE 2.1 AF VERSION
    elif CURRENT_VARIANT_VALUE == "variant9.code" :
        with canvas(Display.virtual) as draw:
            draw.text(Constants.TOP_TEXT_POS, "Choose one channel:", fill="white", font=Font3)

            if Constants.CHOOSE_CHANNEL_1_ID <= selected <= Constants.CHOOSE_CHANNEL_4_ID:
                draw.rectangle(Constants.CHOOSE_CHANNEL_RECTANGLE_POSITIONS[selected], fill=Constants.GRAY_COLOR)
            if selected == Constants.CHOOSE_CHANNEL_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            
            label = ["","","",""]
            label[0] = Constants.CHANNEL_LABEL_VAR9[0] + " - " + Data.channels_preview[0]["name"][0:10]
            label[1] = Constants.CHANNEL_LABEL_VAR9[1] + " - " + Data.channels_preview[2]["name"][0:10]
            label[2] = Constants.CHANNEL_LABEL_VAR9[2] + " - " + Data.channels_preview[3]["name"][0:10]


            for i in range(0, Constants.NUM_OF_CHANNELS-1):
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], str(label[i]), fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")

    # 4 CHANNELS VERSION
    else:
        with canvas(Display.virtual) as draw:
            draw.text(Constants.TOP_TEXT_POS, "Choose one channel:", fill="white", font=Font3)

            if Constants.CHOOSE_CHANNEL_1_ID <= selected <= Constants.CHOOSE_CHANNEL_4_ID:
                draw.rectangle(Constants.CHOOSE_CHANNEL_RECTANGLE_POSITIONS[selected], fill=Constants.GRAY_COLOR)
            if selected == Constants.CHOOSE_CHANNEL_SCREEN_BACK_ID:
                draw.rectangle(Constants.POSITION_BACK_FILLED, fill=Constants.GRAY_COLOR) #create filled rectangle if selected

            draw.bitmap(Constants.POSITION_BACK, icon_back, fill=color)
            
            label = ["","","",""]
            label[0] = "A - " + Data.channels_preview[0]["name"][0:12]
            label[1] = "B - " + Data.channels_preview[1]["name"][0:12]
            label[2] = "C - " + Data.channels_preview[2]["name"][0:12]
            label[3] = "D - " + Data.channels_preview[3]["name"][0:12]

            for i in range(0, Constants.NUM_OF_CHANNELS):
                draw.text(Constants.FOUR_ITEM_MENU_TEXT_BOX_POSITIONS[i], str(label[i]), fill="white", font=Font3)

            draw.line(Constants.BOTTOM_LINE, fill="white")


def create_screen_apply_change(selected):
    with canvas(Display.virtual) as draw:
        draw.text(Constants.MIDDLE_TEXT_POS, "Do you want to apply preset?", fill="white", font=Font4)

        if selected == Constants.APPLY_CHANGE_YES_ID:
            draw.rectangle(Constants.APPLY_SPEAKER_PRESET_RECTANGLE_POS_1, fill=Constants.GRAY_COLOR)
        elif selected == Constants.APPLY_CHANGE_NO_ID:
            draw.rectangle(Constants.APPLY_SPEAKER_PRESET_RECTANGLE_POS_2, fill=Constants.GRAY_COLOR)

        draw.text(Constants.APPLY_SPEAKER_PRESET_CHANGE_YES_POS, "[YES]", fill="white", font=Font3)
        draw.text(Constants.APPLY_SPEAKER_PRESET_CHANGE_NO_POS, "[NO]", fill="white", font=Font3)

        draw.line(Constants.BOTTOM_LINE, fill="white")

def create_screen_cannot_apply(selected):
    with canvas(Display.virtual) as draw:
        draw.text(Constants.MIDDLE_TEXT_POS, "OEM file locked !", fill="white", font=Font4)

        if selected == Constants.APPLY_CHANGE_YES_ID:
            draw.rectangle(Constants.APPLY_SPEAKER_PRESET_RECTANGLE_POS_1, fill=Constants.GRAY_COLOR)
        elif selected == Constants.APPLY_CHANGE_NO_ID:
            draw.rectangle(Constants.APPLY_SPEAKER_PRESET_RECTANGLE_POS_2, fill=Constants.GRAY_COLOR)

        draw.text(Constants.APPLY_SPEAKER_PRESET_CHANGE_YES_POS, "[YES]", fill="white", font=Font3)
        draw.text(Constants.APPLY_SPEAKER_PRESET_CHANGE_NO_POS, "[NO]", fill="white", font=Font3)

        draw.line(Constants.BOTTOM_LINE, fill="white")


def create_black_screen():
    with canvas(Display.virtual) as draw:
        draw.rectangle(Constants.BLACK_SCREEN_POS, fill="black")


def create_screen_loading_eth_config():
    regulator = framerate_regulator(fps=10)
    background = Image.new("RGB", Display.device.size, "black")

    from MonitorTask import MonitorTask

    while MonitorTask.is_encoder_blocked:
        for frame in ImageSequence.Iterator(gif_progress):
            with regulator:
                if not MonitorTask.is_encoder_blocked:
                    break
                background.paste(frame.resize((100, 100), resample=Image.BILINEAR), (13, 0))
                draw = ImageDraw.Draw(background)
                draw.text((15, 101), "Network configuration", fill="white", font=Font3)
                draw.text((33, 111), "in progress...", fill="white", font=Font3)
                Display.device.display(background.convert(Display.device.mode))

    if MonitorTask.response:
        print("IP address is changed successfully!")
    else:
        print("IP address failed to change!")
    return


def create_screen_applying_settings():
    regulator = framerate_regulator(fps=10)
    background = Image.new("RGB", Display.device.size, "black")

    from MonitorTask import MonitorTask

    while MonitorTask.is_encoder_blocked:
        for frame in ImageSequence.Iterator(gif_progress):
            with regulator:
                if not MonitorTask.is_encoder_blocked:
                    break
                background.paste(frame.resize((100, 100), resample=Image.BILINEAR), (13, 0))
                draw = ImageDraw.Draw(background)
                draw.text((15, 101), "Applying settings...", fill="white", font=Font3)
                Display.device.display(background.convert(Display.device.mode))

    return

def create_screen_front_lock():

    with canvas(Display.virtual) as draw:
        draw.text(Constants.ABOUT_SCREEN_POS_3_1, "SCREEN LOCKED", fill="white", font=Font1)
        network_screen_data = dbus_to_python(MonitorTask.command_get_data_network())
        Data.settings_preview["old_network_mode"] = network_screen_data["network_mode"]
        Data.settings_preview["old_IP"] = network_screen_data["IP"][:]
        Data.settings_preview["old_subnet"] = network_screen_data["Subnet"][:]
        Data.settings_preview["new_network_mode"] = network_screen_data["network_mode"]
        Data.settings_preview["new_IP"] = network_screen_data["IP"][:]
        Data.settings_preview["new_subnet"] = network_screen_data["Subnet"][:]

        cloud_screen_data = dbus_to_python(MonitorTask.command_get_data_cloud())
        Data.settings_preview["cloud_status"] = bool(cloud_screen_data["cloud_enable"])
        Data.settings_preview["cloud_device_name"] = cloud_screen_data["cloud_device_name"]
        Data.settings_preview["cloud_user"] = cloud_screen_data["cloud_username"]
        Data.settings_preview["cloud_pass"] = cloud_screen_data["cloud_password"]
        
        ip = str(Data.settings_preview.get("new_IP")[0]) + "." + str(Data.settings_preview.get("new_IP")[1]) + "." + \
         str(Data.settings_preview.get("new_IP")[2]) + "." + str(Data.settings_preview.get("new_IP")[3])
        draw.text(Constants.ABOUT_SCREEN_POS_4_1, "UNLOCK VIA BROWSER", fill="white", font=Font2)
        draw.text(Constants.ABOUT_SCREEN_POS_5_1, "IP :  " + ip, fill="white", font=Font2)
        draw.text(Constants.ABOUT_SCREEN_POS_6_1, "CLOUD :  " + Data.settings_preview.get("cloud_device_name"), fill="white", font=Font2)

        draw.bitmap(Constants.POSITION_LOCK, icon_lock, fill="white")

def create_screen_locate():
    regulator = framerate_regulator(fps=15)
    background = Image.new("RGB", Display.device.size, "black")

    count = 200

    while count > 0:
        for frame in ImageSequence.Iterator(gif_locate):
            with regulator:
                background.paste(frame.resize((120, 120), resample=Image.BILINEAR), (6, 5))
                Display.device.display(background.convert(Display.device.mode))
                count -= 1