import json
import os
from threading import Timer

import Constants
import Data
import MonitorTask
import math
from DisplayTask import create_screen, set_screen_dim, set_screen_dim_full
from common import PEAK_READBACK_FILE, CHANNEL, USER_RMS_LIM, USER_PEAK_LIM, SPEAKER_RMS_LIM, SPEAKER_PEAK_LIM, AMP_LIM, AMP_ON, TEMP, AVERAGE_POWER, OVERTEMP, VOLTAGE
from util import dbus_to_python
from Constants import CURRENT_VARIANT_VALUE





def clear_home_screen():
    print("CLEAR SELECTION AFTER INACTIVITY")
    if not MonitorTask.is_encoder_blocked :
        create_screen(Constants.SCREEN_HOME_PAGE_ID, Constants.MAX_SELECTION_HOME)
        EncoderTask.periodic_gain_timer.cancel()
        if EncoderTask.cancel_timers is False:
            EncoderTask.periodic_gain_timer = Timer(Constants.READBACK_TIME, periodic_gain)
            EncoderTask.periodic_gain_timer.start()

        EncoderTask.current_screen = Constants.SCREEN_HOME_PAGE_ID
        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
            EncoderTask.current_item_in_screen = Constants.HOME_SCREEN_MENU_PRESET_ID
        else:
            EncoderTask.current_item_in_screen = Constants.HOME_SCREEN_CHANNEL_0_ID
        EncoderTask.is_item_in_focus = False
        EncoderTask.is_home_screen_inactive = True
        set_screen_dim()


def periodic_gain():
    if EncoderTask.current_screen == Constants.SCREEN_HOME_PAGE_ID:
        EncoderTask.get_home_page_data()
        if EncoderTask.is_home_screen_inactive:
            create_screen(Constants.SCREEN_HOME_PAGE_ID, Constants.MAX_SELECTION_HOME)
        else:
            create_screen(Constants.SCREEN_HOME_PAGE_ID, EncoderTask.current_item_in_screen)
        EncoderTask.periodic_gain_timer.cancel()
        if EncoderTask.cancel_timers is False:
            EncoderTask.periodic_gain_timer = Timer(Constants.READBACK_TIME, periodic_gain)
            EncoderTask.periodic_gain_timer.start()
            # print("start peridoic gain")

def send_static_ethernet_config():
    ip = str(Data.settings_preview["new_IP"][0]) + "." + \
         str(Data.settings_preview["new_IP"][1]) + "." + \
         str(Data.settings_preview["new_IP"][2]) + "." + \
         str(Data.settings_preview["new_IP"][3])
    mask = str(Data.settings_preview["new_subnet"][0]) + "." + \
           str(Data.settings_preview["new_subnet"][1]) + "." + \
           str(Data.settings_preview["new_subnet"][2]) + "." + \
           str(Data.settings_preview["new_subnet"][3])
    gw = str(Data.settings_preview["new_gateway"][0]) + "." + \
           str(Data.settings_preview["new_gateway"][1]) + "." + \
           str(Data.settings_preview["new_gateway"][2]) + "." + \
           str(Data.settings_preview["new_gateway"][3])
    return MonitorTask.command_set_static_ethernet(str(ip), str(mask), str(gw))


class EncoderTask:
    current_screen = Constants.SCREEN_HOME_PAGE_ID
    current_item_in_screen = Constants.MAX_SELECTION_HOME
    is_item_in_focus = False

    start_position = 0
    stop_position = 0
    current_folder = 0
    current_file_in_folder = 0
    selected_item_in_file_system = 0
    is_home_screen_inactive = True
    is_global_preset = True  # Set global preset if true, set speaker preset if false
    current_channel = 0  # For which of 4 channels speaker preset will be applied
    current_peq = 0 # For which of 12 peqs settings will be applied

    home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
    periodic_gain_timer = Timer(Constants.READBACK_TIME, periodic_gain)

    front_lock = False

    cancel_timers = False

    def __init__(self):
        self.get_home_page_data()
        create_screen(EncoderTask.current_screen, EncoderTask.current_item_in_screen, EncoderTask.is_item_in_focus)
        EncoderTask.periodic_gain_timer.start()
        MonitorTask.command_start_readback()
        MonitorTask.is_encoder_blocked = False
        set_screen_dim()

    def on_click(self):
        #Main display maximum dimming
        #Reset and start timer for back to main display and screen dimming
        EncoderTask.home_screen_timer.cancel()
        EncoderTask.home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
        EncoderTask.home_screen_timer.start()
        
        if (EncoderTask.front_lock) :
            EncoderTask.current_screen = Constants.SCREEN_FRONT_LOCK
            create_screen(EncoderTask.current_screen, EncoderTask.current_item_in_screen, EncoderTask.current_channel, EncoderTask.current_peq, EncoderTask.is_item_in_focus)

        else :
            if EncoderTask.is_item_in_focus:
                print("ENC-SWITCH pressed, item in focus!")

                if EncoderTask.current_screen == Constants.SCREEN_MENU_HOTSPOT_ID:
                    print("HOTSPOT MENU")
                    if EncoderTask.current_item_in_screen == Constants.HOTSPOT_SCREEN_ON_OFF_ID:
                        MonitorTask.command_hotspot_turn_on_off(Data.settings_preview.get("hotspot_status"))
                        EncoderTask.is_item_in_focus = False

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_CLOUD_ID:
                    print("CLOUD MENU")
                    if EncoderTask.current_item_in_screen == Constants.CLOUD_SCREEN_ON_OFF_ID:
                        MonitorTask.command_cloud_turn_on_off(bool(Data.settings_preview["cloud_status"]))
                        EncoderTask.is_item_in_focus = False

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_NETWORK_ID:
                    print("NETWORK MENU")
                    if EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_MODE_ID:
                        EncoderTask.is_item_in_focus = False

                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_0_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_IP_1_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_1_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_IP_2_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_2_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_IP_3_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_3_ID:
                        EncoderTask.is_item_in_focus = False
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_IP_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_0_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_SUBNET_1_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_1_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_SUBNET_2_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_2_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_SUBNET_3_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_3_ID:
                        EncoderTask.is_item_in_focus = False
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_SUBNET_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_0_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_GW_1_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_1_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_GW_2_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_2_ID:
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_GW_3_ID
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_3_ID:
                        EncoderTask.is_item_in_focus = False
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_GW_0_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SIGGEN_ID:
                    print("SIGGEN EDIT MENU")
                    EncoderTask.is_item_in_focus = False

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_LIMITER_EDIT_ID:
                    print("LIMITER EDIT MENU")
                    EncoderTask.is_item_in_focus = False
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_THRES_ID:
                        lim_rms_thres_in_db = round((20*math.log10(Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"]))-37,2)
                        MonitorTask.command_set_limiter_rms_thres(EncoderTask.current_channel,lim_rms_thres_in_db)
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_ATTACK_ID:
                        MonitorTask.command_set_limiter_rms_attack(EncoderTask.current_channel,
                                    Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_RELEASE_ID:
                        MonitorTask.command_set_limiter_rms_release(EncoderTask.current_channel,
                                    Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_THRES_ID:
                        lim_peak_thres_in_db = round((20*math.log10(Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"]))-41,2)
                        MonitorTask.command_set_limiter_peak_thres(EncoderTask.current_channel,lim_peak_thres_in_db)
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_REL_ID:
                        MonitorTask.command_set_limiter_peak_release(EncoderTask.current_channel,
                                    Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_LIMITER_ID:
                    print("AUDIO LIMITER MENU")
                    EncoderTask.is_item_in_focus = False

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_XOVER_EDIT_ID:
                    print("XOVER EDIT MENU")
                    EncoderTask.is_item_in_focus = False
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_ENABLE_ID:
                        if EncoderTask.current_peq == 0:
                            MonitorTask.command_set_xover_hp_enable(EncoderTask.current_channel,
                            Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_enable"])
                        else:
                            MonitorTask.command_set_xover_lp_enable(EncoderTask.current_channel,
                            Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_enable"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_TYPE_ID:
                        if EncoderTask.current_peq == 0:
                            MonitorTask.command_set_xover_hp_type(EncoderTask.current_channel,
                            Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"])
                        else:
                            MonitorTask.command_set_xover_lp_type(EncoderTask.current_channel,
                            Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_FREQ_ID:
                        if EncoderTask.current_peq == 0:
                            MonitorTask.command_set_xover_hp_freq(EncoderTask.current_channel,
                            Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"])
                        else:
                            MonitorTask.command_set_xover_lp_freq(EncoderTask.current_channel,
                            Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_XOVER_ID:
                    print("AUDIO XOVER MENU")
                    EncoderTask.is_item_in_focus = False

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID:
                    print("PEQ EDIT MENU")
                    EncoderTask.is_item_in_focus = False
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_ENABLE_ID:
                        MonitorTask.command_set_peq_enable(EncoderTask.current_channel,EncoderTask.current_peq,
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["enable"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_TYPE_ID:
                        MonitorTask.command_set_peq_type(EncoderTask.current_channel,EncoderTask.current_peq,
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_FREQ_ID:
                        MonitorTask.command_set_peq_freq(EncoderTask.current_channel,EncoderTask.current_peq,
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_GAIN_ID:
                        MonitorTask.command_set_peq_gain(EncoderTask.current_channel,EncoderTask.current_peq,
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"])
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_Q_ID:
                        MonitorTask.command_set_peq_q(EncoderTask.current_channel,EncoderTask.current_peq,
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_PEQ_ID:
                    print("AUDIO PEQ MENU")
                    EncoderTask.is_item_in_focus = False

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_DELAY_ID:
                    print("AUDIO DELAY MENU")
                    EncoderTask.is_item_in_focus = False
                    MonitorTask.command_set_channel_delay(EncoderTask.current_item_in_screen,
                                                        Data.channels_preview[EncoderTask.current_item_in_screen]["delay"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_GAIN_ID:
                    print("AUDIO GAIN MENU")
                    EncoderTask.is_item_in_focus = False
                    MonitorTask.command_set_channel_gain(EncoderTask.current_item_in_screen,
                                                        Data.channels_preview[EncoderTask.current_item_in_screen]["gain"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID:
                    print("SOURCE EDIT MENU")
                    EncoderTask.is_item_in_focus = False
                    mixerInputIndex = EncoderTask.current_item_in_screen
                    if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        if mixerInputIndex == 1:
                            mixerInputIndex = 8
                        elif mixerInputIndex == 2:
                            mixerInputIndex = 9
                        elif mixerInputIndex == 3:
                            mixerInputIndex = 10
                        elif mixerInputIndex == 4:
                            mixerInputIndex = 11
                    elif CURRENT_VARIANT_VALUE == "variant7.code":
                        if mixerInputIndex == 5:
                            mixerInputIndex = 8
                        elif mixerInputIndex == 6:
                            mixerInputIndex = 9
                        elif mixerInputIndex == 7:
                            mixerInputIndex = 10
                        elif mixerInputIndex == 8:
                            mixerInputIndex = 11
                    elif (CURRENT_VARIANT_VALUE == "variant9.code"):
                        if mixerInputIndex == 2:
                            mixerInputIndex = 8
                        elif mixerInputIndex == 3:
                            mixerInputIndex = 9
                        elif mixerInputIndex == 4:
                            mixerInputIndex = 10
                        elif mixerInputIndex == 5:
                            mixerInputIndex = 11

                    if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                        MonitorTask.command_set_channel_source_mixer(EncoderTask.current_channel, mixerInputIndex, Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SOURCE_ID:
                    print("AUDIO SOURCE MENU")
                    EncoderTask.is_item_in_focus = False

                create_screen(EncoderTask.current_screen, EncoderTask.current_item_in_screen, EncoderTask.current_channel, EncoderTask.current_peq, EncoderTask.is_item_in_focus)

            else:
                print("ENC-SWITCH pressed, item is not in focus!")
                if EncoderTask.current_screen == Constants.SCREEN_HOME_PAGE_ID:
                    print("HOME PAGE")
                    EncoderTask.home_screen_timer.cancel()
                    if EncoderTask.cancel_timers is False:
                        EncoderTask.home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
                        EncoderTask.home_screen_timer.start()
                    EncoderTask.is_home_screen_inactive = False

                    if EncoderTask.current_item_in_screen == Constants.HOME_SCREEN_SETUP_ID:
                        EncoderTask.periodic_gain_timer.cancel()
                        EncoderTask.is_home_screen_inactive = True
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_AUDIO_ID
                    else:
                        # 16 CHANNELS AMPLIFIER
                        if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code"):
                            if Constants.HOME_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.HOME_SCREEN_CHANNEL_15_ID:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["mute"] = not Data.channels_preview[EncoderTask.current_item_in_screen].get("mute")
                                MonitorTask.command_mute_unmute_channel(EncoderTask.current_item_in_screen, Data.channels_preview[EncoderTask.current_item_in_screen]["mute"])
                        # AMP PLATE AF
                        elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            #do nothing
                            if EncoderTask.current_item_in_screen == Constants.HOME_SCREEN_MENU_PRESET_ID:
                                Data.folder_names = dbus_to_python(MonitorTask.command_get_data_all_speaker_presets_folder())
                                EncoderTask.current_screen = Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID
                                EncoderTask.current_item_in_screen = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                                EncoderTask.selected_item_in_file_system = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                                self.calc_params_for_file_system_on_click(0, len(Data.folder_names))
                            elif EncoderTask.current_item_in_screen == Constants.HOME_SCREEN_MENU_IP_ID:
                                network_screen_data = dbus_to_python(MonitorTask.command_get_data_network())
                                Data.settings_preview["old_network_mode"] = network_screen_data["network_mode"]
                                Data.settings_preview["old_IP"] = network_screen_data["IP"][:]
                                Data.settings_preview["old_subnet"] = network_screen_data["Subnet"][:]
                                Data.settings_preview["old_gateway"] = network_screen_data["Gateway"][:]
                                Data.settings_preview["new_network_mode"] = network_screen_data["network_mode"]
                                Data.settings_preview["new_IP"] = network_screen_data["IP"][:]
                                Data.settings_preview["new_subnet"] = network_screen_data["Subnet"][:]
                                Data.settings_preview["new_gateway"] = network_screen_data["Gateway"][:]
                                EncoderTask.current_screen = Constants.SCREEN_MENU_NETWORK_ID
                                EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_MODE_ID
                            elif EncoderTask.current_item_in_screen == Constants.HOME_SCREEN_MENU_GAIN_ID:
                                audio_gain_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_gain())
                                for i in range(0, Constants.NUM_OF_CHANNELS):
                                    Data.channels_preview[i]["name"] = audio_gain_screen_data["names"][i]
                                    Data.channels_preview[i]["gain"] = audio_gain_screen_data["gains"][i]
                                EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_GAIN_ID
                                EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID
                        # AMP 2.1 PLATE AF
                        elif (CURRENT_VARIANT_VALUE == "variant9.code"):
                            if Constants.HOME_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.HOME_SCREEN_CHANNEL_2_ID:
                                sel_channel = 0
                                if 0 == EncoderTask.current_item_in_screen:
                                    sel_channel = 0
                                elif 1 == EncoderTask.current_item_in_screen:
                                    sel_channel = 2
                                elif 2 == EncoderTask.current_item_in_screen:
                                    sel_channel = 3
                                Data.channels_preview[sel_channel]["mute"] = not Data.channels_preview[sel_channel].get("mute")
                                MonitorTask.command_mute_unmute_channel(sel_channel, Data.channels_preview[sel_channel]["mute"])
                        # 4 CHANNELS AMPLIFIER
                        else:
                            if Constants.HOME_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.HOME_SCREEN_CHANNEL_3_ID:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["mute"] = not Data.channels_preview[EncoderTask.current_item_in_screen].get("mute")
                                MonitorTask.command_mute_unmute_channel(EncoderTask.current_item_in_screen, Data.channels_preview[EncoderTask.current_item_in_screen]["mute"])

                    # if Constants.HOME_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.HOME_SCREEN_CHANNEL_15_ID:
                    #     Data.channels_preview[EncoderTask.current_item_in_screen]["mute"] = not Data.channels_preview[EncoderTask.current_item_in_screen].get("mute")
                    #     MonitorTask.command_mute_unmute_channel(EncoderTask.current_item_in_screen, Data.channels_preview[EncoderTask.current_item_in_screen]["mute"])
                    # elif EncoderTask.current_item_in_screen == Constants.HOME_SCREEN_SETUP_ID:
                    #     EncoderTask.periodic_gain_timer.cancel()
                    #     EncoderTask.is_home_screen_inactive = True
                    #     EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                    #     EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_AUDIO_ID

                elif EncoderTask.current_screen == Constants.SCREEN_HOME_MENU_ID:
                    print("HOME MENU")
                    if EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_AUDIO_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_SOURCE_ID
                    elif EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_PRESETS_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_PRESETS_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_PRESETS_SCREEN_GLOBAL_ID
                    elif EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_HOTSPOT_ID:
                        hotspot_screen_data = dbus_to_python(MonitorTask.command_get_data_hotspot())
                        Data.settings_preview["hotspot_status"] = bool(hotspot_screen_data["hotspot_status"])
                        Data.settings_preview["SSID"] = hotspot_screen_data["SSID"]
                        Data.settings_preview["hotspot_pass"] = hotspot_screen_data["hotspot_pass"]
                        EncoderTask.current_screen = Constants.SCREEN_MENU_HOTSPOT_ID
                        EncoderTask.current_item_in_screen = Constants.HOTSPOT_SCREEN_ON_OFF_ID
                    elif EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_CLOUD_ID:
                        cloud_screen_data = dbus_to_python(MonitorTask.command_get_data_cloud())
                        Data.settings_preview["cloud_status"] = bool(cloud_screen_data["cloud_enable"])
                        Data.settings_preview["cloud_device_name"] = cloud_screen_data["cloud_device_name"]
                        Data.settings_preview["cloud_user"] = cloud_screen_data["cloud_username"]
                        Data.settings_preview["cloud_pass"] = cloud_screen_data["cloud_password"]
                        EncoderTask.current_screen = Constants.SCREEN_MENU_CLOUD_ID
                        EncoderTask.current_item_in_screen = Constants.CLOUD_SCREEN_ON_OFF_ID
                    elif EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_NETWORK_ID:
                        network_screen_data = dbus_to_python(MonitorTask.command_get_data_network())
                        Data.settings_preview["old_network_mode"] = network_screen_data["network_mode"]
                        Data.settings_preview["old_IP"] = network_screen_data["IP"][:]
                        Data.settings_preview["old_subnet"] = network_screen_data["Subnet"][:]
                        Data.settings_preview["old_gateway"] = network_screen_data["Gateway"][:]
                        Data.settings_preview["new_network_mode"] = network_screen_data["network_mode"]
                        Data.settings_preview["new_IP"] = network_screen_data["IP"][:]
                        Data.settings_preview["new_subnet"] = network_screen_data["Subnet"][:]
                        Data.settings_preview["new_gateway"] = network_screen_data["Gateway"][:]
                        EncoderTask.current_screen = Constants.SCREEN_MENU_NETWORK_ID
                        EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_MODE_ID
                    elif EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_ABOUT_ID:
                        Data.settings_preview["version"] = MonitorTask.command_get_data_about()
                        EncoderTask.current_screen = Constants.SCREEN_MENU_ABOUT_ID
                        EncoderTask.current_item_in_screen = Constants.ABOUT_SCREEN_BACK_POSITION
                    elif EncoderTask.current_item_in_screen == Constants.MENU_SCREEN_BACK_ID:
                        self.get_home_page_data()
                        EncoderTask.current_screen = Constants.SCREEN_HOME_PAGE_ID
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            EncoderTask.current_item_in_screen = Constants.HOME_SCREEN_MENU_PRESET_ID
                        else:
                            EncoderTask.current_item_in_screen = Constants.HOME_SCREEN_CHANNEL_0_ID
                        EncoderTask.home_screen_timer.cancel()
                        EncoderTask.periodic_gain_timer.cancel()
                        if EncoderTask.cancel_timers is False:
                            EncoderTask.home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
                            EncoderTask.home_screen_timer.start()
                        if EncoderTask.cancel_timers is False:
                            EncoderTask.periodic_gain_timer = Timer(Constants.READBACK_TIME, periodic_gain)
                            EncoderTask.periodic_gain_timer.start()
                        EncoderTask.is_home_screen_inactive = False
                        MonitorTask.command_start_readback()

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_ID:
                    print("AUDIO MENU")
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_SOURCE_ID:
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            EncoderTask.current_channel = 0
                            audio_source_gain_all_data = dbus_to_python(MonitorTask.command_get_solo_mixer_all_gain(EncoderTask.current_channel))
                            for i in range(0, Constants.NUM_OF_INPUTS, 1):
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][i]["gain"] = audio_source_gain_all_data[i]

                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID
                        else:
                            audio_source_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_source())
                            for i in range(0, Constants.NUM_OF_CHANNELS):
                                Data.channels_preview[i]["name"] = audio_source_screen_data["names"][i]
                                Data.channels_preview[i]["source"] = audio_source_screen_data["sources"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_GAIN_ID:
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            audio_gain_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_gain())
                            for i in range(0, Constants.NUM_OF_CHANNELS):
                                Data.channels_preview[i]["name"] = audio_gain_screen_data["names"][i]
                                Data.channels_preview[i]["gain"] = audio_gain_screen_data["gains"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_GAIN_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID
                            EncoderTask.is_item_in_focus = True
                        else:
                            audio_gain_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_gain())
                            for i in range(0, Constants.NUM_OF_CHANNELS):
                                Data.channels_preview[i]["name"] = audio_gain_screen_data["names"][i]
                                Data.channels_preview[i]["gain"] = audio_gain_screen_data["gains"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_GAIN_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_DELAY_ID:
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            audio_delay_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_delay())
                            for i in range(0, Constants.NUM_OF_CHANNELS):
                                Data.channels_preview[i]["name"] = audio_delay_screen_data["names"][i]
                                Data.channels_preview[i]["delay"] = audio_delay_screen_data["delays"][i]
                                Data.channels_preview[i]["group_delay"] = audio_delay_screen_data["groupDelays"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_DELAY_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID
                            EncoderTask.is_item_in_focus = True
                        else:
                            audio_delay_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_delay())
                            for i in range(0, Constants.NUM_OF_CHANNELS):
                                Data.channels_preview[i]["name"] = audio_delay_screen_data["names"][i]
                                Data.channels_preview[i]["delay"] = audio_delay_screen_data["delays"][i]
                                Data.channels_preview[i]["group_delay"] = audio_delay_screen_data["groupDelays"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_DELAY_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_PEQ_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_PEQ_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_XOVER_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_XOVER_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_LIMITER_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_LIMITER_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_SIGGEN_ID:
                        audio_siggen_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_siggen())
                        Data.settings_preview["signal_generator"] = audio_siggen_screen_data
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SIGGEN_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SIGGEN_SCREEN_FREQ_FREQ_ID

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_AUDIO_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_PRESETS_ID:
                    print("PRESETS MENU")
                    if EncoderTask.current_item_in_screen == Constants.MENU_PRESETS_SCREEN_GLOBAL_ID:
                        Data.folder_names = dbus_to_python(MonitorTask.command_get_data_global_presets_folder())
                        EncoderTask.current_screen = Constants.SCREEN_FOLDERS_GLOBAL_PRESETS_ID
                        EncoderTask.current_item_in_screen = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID
                        EncoderTask.selected_item_in_file_system = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID
                        self.calc_params_for_file_system_on_click(0, len(Data.folder_names))
                    elif EncoderTask.current_item_in_screen == Constants.MENU_PRESETS_SCREEN_SPEAKER_ID:
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                            Data.folder_names = dbus_to_python(MonitorTask.command_get_data_all_speaker_presets_folder())
                        else:
                            Data.folder_names = dbus_to_python(MonitorTask.command_get_data_speaker_presets_folder())
                        EncoderTask.current_screen = Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID
                        EncoderTask.current_item_in_screen = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                        EncoderTask.selected_item_in_file_system = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                        self.calc_params_for_file_system_on_click(0, len(Data.folder_names))
                    elif EncoderTask.current_item_in_screen == Constants.MENU_PRESETS_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_PRESETS_ID
                        EncoderTask.selected_item_in_file_system = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_HOTSPOT_ID:
                    print("HOTSPOT MENU")
                    if EncoderTask.current_item_in_screen == Constants.HOTSPOT_SCREEN_ON_OFF_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.HOTSPOT_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_HOTSPOT_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_CLOUD_ID:
                    print("CLOUD MENU")
                    if EncoderTask.current_item_in_screen == Constants.CLOUD_SCREEN_ON_OFF_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.CLOUD_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_CLOUD_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_NETWORK_ID:
                    print("NETWORK MENU")
                    if EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_MODE_ID or \
                            EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_0_ID or \
                            EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_0_ID or \
                            EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_0_ID :
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_BACK_ID:
                        if not Data.settings_preview["new_network_mode"] and Data.settings_preview["old_network_mode"]:
                            MonitorTask.command_set_dhcp_ethernet()
                        elif Data.settings_preview["new_network_mode"] and not Data.settings_preview["old_network_mode"]:
                            send_static_ethernet_config()
                        elif Data.settings_preview["old_network_mode"] and Data.settings_preview["new_network_mode"] and \
                            ((Data.settings_preview["old_IP"] != Data.settings_preview["new_IP"]) or (Data.settings_preview["old_subnet"] != Data.settings_preview["new_subnet"]) or (Data.settings_preview["old_gateway"] != Data.settings_preview["new_gateway"])):
                            send_static_ethernet_config()
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_NETWORK_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_ABOUT_ID:
                    print("ABOUT MENU")
                    if EncoderTask.current_item_in_screen == Constants.ABOUT_SCREEN_BACK_POSITION:
                        EncoderTask.current_screen = Constants.SCREEN_HOME_MENU_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_SCREEN_ABOUT_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SIGGEN_ID:
                    print("AUDIO SIGGEN MENU")
                    if Constants.MENU_AUDIO_SIGGEN_SCREEN_FREQ_FREQ_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SIGGEN_SCREEN_PINK_GAIN_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SIGGEN_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_SIGGEN_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_LIMITER_EDIT_ID:
                    print("AUDIO LIMITER LIST MENU")
                    if Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_MODE_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_REL_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_LIMITER_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_LIMITER_ID:
                    print("AUDIO LIMITER MENU")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_15_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_limiter_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_limiter(EncoderTask.current_channel))
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"] = audio_limiter_screen_data["lim_rms"]
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] = pow(10,(round(Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"],1)+37)/20)
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"] = audio_limiter_screen_data["lim_peak"]
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] = pow(10,(round(Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"],1)+41)/20)
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_LIMITER_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_MODE_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_LIMITER_ID
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        pass
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        pass
                    else:
                        if Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_LIMITER_SCREEN_CHANNEL_3_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_limiter_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_limiter(EncoderTask.current_channel))
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"] = audio_limiter_screen_data["lim_rms"]
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] = pow(10,(round(Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"],1)+37)/20)
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"] = audio_limiter_screen_data["lim_peak"]
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] = pow(10,(round(Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"],1)+41)/20)
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_LIMITER_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_MODE_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_LIMITER_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_XOVER_EDIT_ID:
                    print("AUDIO XOVER LIST MENU")
                    if Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_INDEX_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_FREQ_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_XOVER_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_XOVER_ID:
                    print("AUDIO XOVER MENU")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_15_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_xover_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_xover(EncoderTask.current_channel))
                            Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"] = audio_xover_screen_data["xover_hp_filter"]
                            Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"] = audio_xover_screen_data["xover_lp_filter"]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_XOVER_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_INDEX_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_XOVER_ID
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        pass
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        pass
                    else:
                        if Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_XOVER_SCREEN_CHANNEL_3_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_xover_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_xover(EncoderTask.current_channel))
                            Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"] = audio_xover_screen_data["xover_hp_filter"]
                            Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"] = audio_xover_screen_data["xover_lp_filter"]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_XOVER_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_INDEX_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_XOVER_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID:
                    print("AUDIO PEQ LIST MENU")
                    if Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_Q_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_BACK_ID:
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_PEQ_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_PEQ_ID:
                    print("AUDIO PEQ MENU")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_15_ID:
                            print("PEQ SCREEN NOT BACK")
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_peq_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_peq(EncoderTask.current_channel))
                            for i in range(0, 12):
                                Data.channels_preview[EncoderTask.current_channel]["peq"][i] = audio_peq_screen_data["peq"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_PEQ_ID
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        if Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID:
                            print("PEQ SCREEN NOT BACK")
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_peq_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_peq(EncoderTask.current_channel))
                            for i in range(0, 12):
                                Data.channels_preview[EncoderTask.current_channel]["peq"][i] = audio_peq_screen_data["peq"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_PEQ_ID
                    elif CURRENT_VARIANT_VALUE ==  "variant9.code" :
                        if Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID:
                            print("PEQ SCREEN NOT BACK")
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_peq_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_peq(EncoderTask.current_channel))
                            for i in range(0, 12):
                                Data.channels_preview[EncoderTask.current_channel]["peq"][i] = audio_peq_screen_data["peq"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_PEQ_ID
                    else:
                        if Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_PEQ_SCREEN_CHANNEL_3_ID:
                            print("PEQ SCREEN NOT BACK")
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_peq = 0
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_peq_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_peq(EncoderTask.current_channel))
                            for i in range(0, 12):
                                Data.channels_preview[EncoderTask.current_channel]["peq"][i] = audio_peq_screen_data["peq"][i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_PEQ_ID
    
                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_DELAY_ID:
                    print("AUDIO DELAY MENU")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_15_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_DELAY_ID
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_DELAY_ID
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_2_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_DELAY_ID
                    else:
                        if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_3_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_DELAY_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_DELAY_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_GAIN_ID:
                    print("AUDIO GAIN MENU")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_15_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_GAIN_ID
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_GAIN_ID
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_2_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_GAIN_ID
                    else:
                        if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_3_ID:
                            EncoderTask.is_item_in_focus = True
                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_GAIN_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_GAIN_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID:
                    print("AUDIO SOURCE EDIT MENU")
                    if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                        EncoderTask.is_item_in_focus = True
                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_BACK_ID:
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_SOURCE_ID
                        else:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SOURCE_ID:
                    print("AUDIO SOURCE MENU")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_15_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_source_gain_all_data = dbus_to_python(MonitorTask.command_get_solo_mixer_all_gain(EncoderTask.current_channel))
                            for i in range(0, Constants.NUM_OF_INPUTS, 1):
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][i]["gain"] = audio_source_gain_all_data[i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SOURCE_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_SOURCE_ID
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        EncoderTask.is_item_in_focus = False
                        EncoderTask.current_channel = 0
                        audio_source_gain_all_data = dbus_to_python(MonitorTask.command_get_solo_mixer_all_gain(EncoderTask.current_channel))
                        for i in range(0, Constants.NUM_OF_INPUTS, 1):
                            # if i==0:
                            Data.channels_preview[EncoderTask.current_channel]["mixer"][i]["gain"] = audio_source_gain_all_data[i]
                            # elif i<9 : 
                            #     Data.channels_preview[EncoderTask.current_channel]["mixer"][i]["gain"] = audio_source_gain_all_data[(i+6)]
                        EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        if Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            if (EncoderTask.current_item_in_screen > 0):
                                EncoderTask.current_channel = EncoderTask.current_item_in_screen + 1
                            audio_source_gain_all_data = dbus_to_python(MonitorTask.command_get_solo_mixer_all_gain(EncoderTask.current_channel))
                            for i in range(0, Constants.NUM_OF_INPUTS, 1):
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][i]["gain"] = audio_source_gain_all_data[i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SOURCE_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_SOURCE_ID
                    else:
                        if Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SOURCE_SCREEN_CHANNEL_3_ID:
                            EncoderTask.is_item_in_focus = False
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            audio_source_gain_all_data = dbus_to_python(MonitorTask.command_get_solo_mixer_all_gain(EncoderTask.current_channel))
                            for i in range(0, Constants.NUM_OF_INPUTS, 1):
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][i]["gain"] = audio_source_gain_all_data[i]
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID

                        elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SOURCE_SCREEN_BACK_ID:
                            EncoderTask.current_screen = Constants.SCREEN_MENU_AUDIO_ID
                            EncoderTask.current_item_in_screen = Constants.MENU_AUDIO_SCREEN_SOURCE_ID

                elif EncoderTask.current_screen == Constants.SCREEN_FOLDERS_GLOBAL_PRESETS_ID:
                    print("GLOBAL PRESETS FOLDERS")
                    if 0 <= EncoderTask.current_item_in_screen < Constants.MAX_FILE_SYSTEM_ITEMS:
                        EncoderTask.current_folder = EncoderTask.current_item_in_screen
                        EncoderTask.current_screen = Constants.SCREEN_FILES_GLOBAL_PRESETS_ID
                        # EncoderTask.current_item_in_screen = 0
                        EncoderTask.current_item_in_screen = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID
                        EncoderTask.selected_item_in_file_system = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID
                        Data.file_names = dbus_to_python(MonitorTask.command_get_data_global_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        self.calc_params_for_file_system_on_click(0, len(Data.file_names))
                        if len(Data.file_names) == 0:
                            EncoderTask.current_item_in_screen = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM + 1
                    elif EncoderTask.current_item_in_screen == Constants.MAX_FILE_SYSTEM_ITEMS:
                        EncoderTask.current_folder = 0
                        EncoderTask.current_screen = Constants.SCREEN_MENU_PRESETS_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_PRESETS_SCREEN_GLOBAL_ID

                elif EncoderTask.current_screen == Constants.SCREEN_FILES_GLOBAL_PRESETS_ID:
                    print("GLOBAL PRESETS FILES")
                    if 0 <= EncoderTask.current_item_in_screen < Constants.MAX_FILE_SYSTEM_ITEMS:
                        # print(str(Data.folder_names[EncoderTask.current_folder]))
                        # print(str(Data.file_names[EncoderTask.current_item_in_screen]))
                        if "Default Folder" not in Data.folder_names[EncoderTask.current_folder] and "Default Preset" not in Data.file_names[EncoderTask.current_item_in_screen] or "Default Folder" not in Data.folder_names[EncoderTask.current_folder] :
                            EncoderTask.current_file_in_folder = EncoderTask.current_item_in_screen
                            EncoderTask.current_screen = Constants.SCREEN_CHANNEL_APPLY_CHANGE_ID
                            EncoderTask.current_item_in_screen = Constants.APPLY_CHANGE_YES_ID
                    elif EncoderTask.current_item_in_screen == Constants.MAX_FILE_SYSTEM_ITEMS:
                        self.calc_params_for_file_system_on_click(EncoderTask.current_folder, len(Data.folder_names))
                        EncoderTask.current_screen = Constants.SCREEN_FOLDERS_GLOBAL_PRESETS_ID
                        # EncoderTask.current_item_in_screen = EncoderTask.current_folder
                        EncoderTask.current_item_in_screen = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID
                        EncoderTask.selected_item_in_file_system = Constants.FOLDERS_GLOBAL_PRESETS_INIT_ID

                elif EncoderTask.current_screen == Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID:
                    print("SPEAKER PRESETS FOLDERS")
                    if 0 <= EncoderTask.current_item_in_screen < Constants.MAX_FILE_SYSTEM_ITEMS:
                        EncoderTask.current_folder = EncoderTask.current_item_in_screen
                        EncoderTask.current_screen = Constants.SCREEN_FILES_SPEAKER_PRESETS_ID
                        EncoderTask.current_item_in_screen = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                        EncoderTask.selected_item_in_file_system = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                        # Data.file_names = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                            temp = dbus_to_python(MonitorTask.command_get_data_all_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        else:
                            temp = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        Data.file_names = sorted(temp, key=str.lower)
                        self.calc_params_for_file_system_on_click(0, len(Data.file_names))
                        if len(Data.file_names) == 0:
                            EncoderTask.current_item_in_screen = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM + 1
                    elif EncoderTask.current_item_in_screen == Constants.MAX_FILE_SYSTEM_ITEMS:
                        EncoderTask.current_folder = 0
                        EncoderTask.current_screen = Constants.SCREEN_MENU_PRESETS_ID
                        EncoderTask.current_item_in_screen = Constants.MENU_PRESETS_SCREEN_SPEAKER_ID

                elif EncoderTask.current_screen == Constants.SCREEN_FILES_SPEAKER_PRESETS_ID:
                    print("SPEAKER PRESETS FILES")
                    if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                        # Data.file_names = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))+
                        temp = dbus_to_python(MonitorTask.command_get_data_all_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        Data.file_names = sorted(temp, key=str.lower)
                        if 0 <= EncoderTask.selected_item_in_file_system < len(Data.file_names):
                            EncoderTask.current_file_in_folder = EncoderTask.selected_item_in_file_system
                            EncoderTask.current_channel = 0
                            EncoderTask.is_global_preset = False
                            EncoderTask.current_screen = Constants.SCREEN_CHANNEL_APPLY_CHANGE_ID
                            EncoderTask.current_item_in_screen = Constants.APPLY_CHANGE_YES_ID
                        # elif EncoderTask.current_item_in_screen == Constants.APPLY_CHANGE_YES_ID:
                        elif EncoderTask.current_item_in_screen == Constants.MAX_FILE_SYSTEM_ITEMS:
                            self.calc_params_for_file_system_on_click(EncoderTask.current_folder, len(Data.folder_names))
                            EncoderTask.current_screen = Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID
                            EncoderTask.current_item_in_screen = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                            EncoderTask.selected_item_in_file_system = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                    else:
                        # Data.file_names = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        temp = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                        Data.file_names = sorted(temp, key=str.lower)
                        if 0 <= EncoderTask.selected_item_in_file_system < len(Data.file_names):
                        # if 0 <= EncoderTask.current_item_in_screen < Constants.MAX_FILE_SYSTEM_ITEMS:
                            EncoderTask.current_file_in_folder = EncoderTask.selected_item_in_file_system
                            # EncoderTask.current_file_in_folder = EncoderTask.current_item_in_screen
                            EncoderTask.current_screen = Constants.SCREEN_CHANNEL_CHOICE_SPEAKER_PRESET_ID
                            EncoderTask.current_item_in_screen = Constants.CHOOSE_CHANNEL_1_ID
                        elif EncoderTask.current_item_in_screen == Constants.MAX_FILE_SYSTEM_ITEMS:
                            self.calc_params_for_file_system_on_click(EncoderTask.current_folder, len(Data.folder_names))
                            EncoderTask.current_screen = Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID
                            # EncoderTask.current_item_in_screen = 0
                            # EncoderTask.selected_item_in_file_system = 0
                            EncoderTask.current_item_in_screen = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID
                            EncoderTask.selected_item_in_file_system = Constants.FOLDERS_SPEAKER_PRESETS_INIT_ID

                elif EncoderTask.current_screen == Constants.SCREEN_CHANNEL_CHOICE_SPEAKER_PRESET_ID:
                    print("SPEAKER PRESET CHANNEL CHOICE")
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.CHOOSE_CHANNEL_1_ID <= EncoderTask.current_item_in_screen <= Constants.CHOOSE_CHANNEL_16_ID:
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            EncoderTask.is_global_preset = False
                            EncoderTask.current_screen = Constants.SCREEN_CHANNEL_APPLY_CHANGE_ID
                            EncoderTask.current_item_in_screen = Constants.APPLY_CHANGE_YES_ID
                        elif EncoderTask.current_item_in_screen == Constants.CHOOSE_CHANNEL_SCREEN_BACK_ID:
                            self.calc_params_for_file_system_on_click(EncoderTask.current_file_in_folder, len(Data.file_names))
                            EncoderTask.current_item_in_screen = 0
                            EncoderTask.selected_item_in_file_system = 0
                            EncoderTask.start_position = 0
                            if len(Data.file_names) > Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM:
                                EncoderTask.stop_position = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
                            else:
                                EncoderTask.stop_position = len(Data.file_names) - 1
                                # EncoderTask.stop_position = len(Data.file_names) -1
                            # EncoderTask.current_item_in_screen = EncoderTask.current_file_in_folder
                            EncoderTask.current_screen = Constants.SCREEN_FILES_SPEAKER_PRESETS_ID
                    else:
                        if Constants.CHOOSE_CHANNEL_1_ID <= EncoderTask.current_item_in_screen <= Constants.CHOOSE_CHANNEL_4_ID:
                            EncoderTask.current_channel = EncoderTask.current_item_in_screen
                            EncoderTask.is_global_preset = False
                            EncoderTask.current_screen = Constants.SCREEN_CHANNEL_APPLY_CHANGE_ID
                            EncoderTask.current_item_in_screen = Constants.APPLY_CHANGE_YES_ID
                        elif EncoderTask.current_item_in_screen == Constants.CHOOSE_CHANNEL_SCREEN_BACK_ID:
                            self.calc_params_for_file_system_on_click(EncoderTask.current_file_in_folder, len(Data.file_names))
                            EncoderTask.current_item_in_screen = 0
                            EncoderTask.selected_item_in_file_system = 0
                            EncoderTask.start_position = 0
                            if len(Data.file_names) > Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM:
                                EncoderTask.stop_position = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
                            else:
                                EncoderTask.stop_position = len(Data.file_names) - 1
                                # EncoderTask.stop_position = len(Data.file_names) -1
                            # EncoderTask.current_item_in_screen = EncoderTask.current_file_in_folder
                            EncoderTask.current_screen = Constants.SCREEN_FILES_SPEAKER_PRESETS_ID

                elif EncoderTask.current_screen == Constants.SCREEN_CHANNEL_APPLY_CHANGE_ID:
                    if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                        EncoderTask.current_channel = 0
                    print("APPLY CHANGE SCREEN " + str(EncoderTask.is_global_preset))
                    if EncoderTask.current_item_in_screen == Constants.APPLY_CHANGE_YES_ID:  # changes are confirmed
                        if EncoderTask.is_global_preset:
                            MonitorTask.command_set_global_preset(Data.folder_names[EncoderTask.current_folder],
                                                                Data.file_names[EncoderTask.current_file_in_folder])
                        else:
                            if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                                MonitorTask.command_set_all_speaker_preset(Data.folder_names[EncoderTask.current_folder],
                                                                    Data.file_names[EncoderTask.current_file_in_folder])
                            else:
                                MonitorTask.command_set_speaker_preset(EncoderTask.current_channel,
                                                                    Data.folder_names[EncoderTask.current_folder],
                                                                    Data.file_names[EncoderTask.current_file_in_folder])

                            MonitorTask.command_set_channel_name(EncoderTask.current_channel,
                                                                Data.file_names[EncoderTask.current_file_in_folder])
                            audio_source_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_source())
                            for i in range(0, Constants.NUM_OF_CHANNELS):
                                Data.channels_preview[i]["name"] = audio_source_screen_data["names"][i]

                    EncoderTask.is_global_preset = True
                    EncoderTask.start_position = 0
                    EncoderTask.stop_position = 0
                    EncoderTask.current_folder = 0
                    EncoderTask.current_file_in_folder = 0
                    EncoderTask.selected_item_in_file_system = 0
                    EncoderTask.current_screen = Constants.SCREEN_MENU_PRESETS_ID
                    EncoderTask.current_item_in_screen = Constants.MENU_PRESETS_SCREEN_GLOBAL_ID

                if not (EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_BACK_ID and EncoderTask.current_screen == Constants.MENU_SCREEN_NETWORK_ID):
                    create_screen(EncoderTask.current_screen,
                                EncoderTask.current_item_in_screen,
                                EncoderTask.current_channel, 
                                EncoderTask.current_peq,
                                EncoderTask.is_item_in_focus,
                                EncoderTask.start_position,
                                EncoderTask.stop_position)

    @staticmethod
    def get_home_page_data():
        home_page_screen_data = dbus_to_python(MonitorTask.command_get_data_home_page_status())

        if (home_page_screen_data["locate"]):
            MonitorTask.command_reset_locate()
            EncoderTask.home_screen_timer.cancel()
            EncoderTask.home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
            EncoderTask.home_screen_timer.start()
            EncoderTask.current_screen = Constants.SCREEN_LOCATE
            create_screen(EncoderTask.current_screen, EncoderTask.current_item_in_screen, EncoderTask.current_channel, EncoderTask.current_peq, EncoderTask.is_item_in_focus)

        with open(PEAK_READBACK_FILE, "r", os.O_NONBLOCK) as readback_file:
            raw_readback_data = readback_file.read()
        try:
            # convert dictionary string to dictionary
            readback_data = json.loads(raw_readback_data)
        except Exception:
            return
        
        sum_channel = []
        for i in range (0, Constants.NUM_OF_CHANNELS):
            sum_channel.append(0)

        for i in range (0, Constants.NUM_OF_CHANNELS):
            Data.channels_preview[i]["gain_slider"] = readback_data[CHANNEL+str(i+1)]

            sum_channel[i] = abs(readback_data[USER_RMS_LIM + str(i+1)]) + \
                             abs(readback_data[USER_PEAK_LIM + str(i+1)]) + \
                             abs(readback_data[SPEAKER_RMS_LIM + str(i+1)]) + \
                             abs(readback_data[SPEAKER_PEAK_LIM + str(i+1)]) + \
                             abs(readback_data[AMP_LIM + str(i+1)])
            
            if sum_channel[i] > 3.0:
                Data.channels_preview[i]["rate_limiter_status"] = 2
            elif sum_channel[i] > 1.0 :
                Data.channels_preview[i]["rate_limiter_status"] = 1
            else:
                Data.channels_preview[i]["rate_limiter_status"] = 0

            Data.channels_preview[i]["name"] = home_page_screen_data["names"][i]
            Data.channels_preview[i]["mute"] = home_page_screen_data["mute_channels"][i]
            Data.channels_preview[i]["fault"] = home_page_screen_data["faults"][i]

        temp_t = 0
        volt_t = 0
        standby_t = 0
        status_t = 0

        for i in range (0, Constants.NUM_OF_MODULES):
            if (temp_t < readback_data[TEMP + str(i+1)]):
                temp_t = readback_data[TEMP + str(i+1)]
            if (volt_t < readback_data[VOLTAGE + str(i+1)]):
                volt_t = readback_data[VOLTAGE + str(i+1)]
            if (standby_t < readback_data[AMP_ON + str(i+1)]):
                standby_t = readback_data[AMP_ON + str(i+1)]
            if (status_t < readback_data[OVERTEMP + str(i+1)]):
                status_t = readback_data[OVERTEMP + str(i+1)]
                
        Data.settings_preview["amp_temperature"] = temp_t
        Data.settings_preview["amp_voltage"] = volt_t
        
        if (standby_t == 0):
            Data.settings_preview["amp_standby"] = True
        else:
            Data.settings_preview["amp_standby"] = False

        if (status_t == 0):
            Data.settings_preview["amp_status"] = 1
        else:
            Data.settings_preview["amp_status"] = 2


        Data.settings_preview["limiter_sum"] = round(max(sum_channel),1)

        Data.settings_preview["cloud_status"] = home_page_screen_data["cloud_enable"]
        Data.settings_preview["hotspot_status"] = home_page_screen_data["hotspot_status"]
        Data.settings_preview["oem_status"] = home_page_screen_data["oem_status"]

        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
            audio_gain_screen_data = dbus_to_python(MonitorTask.command_get_data_audio_gain())
            for i in range(0, Constants.NUM_OF_CHANNELS):
                Data.channels_preview[i]["name"] = audio_gain_screen_data["names"][i]
                Data.channels_preview[i]["gain"] = audio_gain_screen_data["gains"][i]

        EncoderTask.front_lock = MonitorTask.command_get_front_lock()

    @staticmethod
    def on_scroll(dy):
        #Main display maximum dimming
        set_screen_dim_full()
        #Reset and start timer for back to main display and screen dimming
        EncoderTask.home_screen_timer.cancel()
        EncoderTask.home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
        EncoderTask.home_screen_timer.start()

        if (EncoderTask.front_lock or EncoderTask.current_screen == Constants.SCREEN_LOCATE) :
            pass
        else :

            if EncoderTask.is_item_in_focus:
                if EncoderTask.current_screen == Constants.SCREEN_MENU_HOTSPOT_ID:
                    if EncoderTask.current_item_in_screen == Constants.HOTSPOT_SCREEN_ON_OFF_ID:
                        Data.settings_preview["hotspot_status"] = not Data.settings_preview.get("hotspot_status")

                if EncoderTask.current_screen == Constants.SCREEN_MENU_CLOUD_ID:
                    if EncoderTask.current_item_in_screen == Constants.CLOUD_SCREEN_ON_OFF_ID:
                        Data.settings_preview["cloud_status"] = not Data.settings_preview.get("cloud_status")

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_NETWORK_ID:
                    if EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_MODE_ID:
                        if Data.settings_preview["new_network_mode"]:
                            Data.settings_preview["new_network_mode"] = False
                        else:
                            Data.settings_preview["new_network_mode"] = True

                    elif Constants.NETWORK_SCREEN_IP_0_ID <= EncoderTask.current_item_in_screen <= Constants.NETWORK_SCREEN_IP_3_ID:
                        if (Data.settings_preview["new_IP"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_IP_0_ID] == 255 and dy == 1:
                            (Data.settings_preview["new_IP"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_IP_0_ID] = 0
                        elif (Data.settings_preview["new_IP"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_IP_0_ID] == 0 and dy == -1:
                            (Data.settings_preview["new_IP"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_IP_0_ID] = 255
                        else:
                            (Data.settings_preview["new_IP"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_IP_0_ID] += dy

                    elif Constants.NETWORK_SCREEN_SUBNET_0_ID <= EncoderTask.current_item_in_screen <= Constants.NETWORK_SCREEN_SUBNET_3_ID:
                        if (Data.settings_preview["new_subnet"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_SUBNET_0_ID] == 255 and dy == 1:
                            (Data.settings_preview["new_subnet"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_SUBNET_0_ID] = 0
                        elif (Data.settings_preview["new_subnet"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_SUBNET_0_ID] == 0 and dy == -1:
                            (Data.settings_preview["new_subnet"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_SUBNET_0_ID] = 255
                        else:
                            (Data.settings_preview["new_subnet"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_SUBNET_0_ID] += dy

                    elif Constants.NETWORK_SCREEN_GW_0_ID <= EncoderTask.current_item_in_screen <= Constants.NETWORK_SCREEN_GW_3_ID:
                        if (Data.settings_preview["new_gateway"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_GW_0_ID] == 255 and dy == 1:
                            (Data.settings_preview["new_gateway"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_GW_0_ID] = 0
                        elif (Data.settings_preview["new_gateway"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_GW_0_ID] == 0 and dy == -1:
                            (Data.settings_preview["new_gateway"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_GW_0_ID] = 255
                        else:
                            (Data.settings_preview["new_gateway"])[EncoderTask.current_item_in_screen - Constants.NETWORK_SCREEN_GW_0_ID] += dy

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SIGGEN_ID:
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SIGGEN_SCREEN_FREQ_FREQ_ID:
                        print("edit frequency generator freq")
                        try:
                            index_freq = Constants.SIGGEN_FREQUENCY.index(Data.settings_preview["signal_generator"]["frequency_generator"]["frequency"])
                        except ValueError:
                            index_freq = 1

                        if index_freq + dy * Constants.XOVER_TYPE_STEP <= 0:
                            Data.settings_preview["signal_generator"]["frequency_generator"]["frequency"] = Constants.SIGGEN_FREQUENCY[0]
                        elif index_freq + dy * Constants.XOVER_TYPE_STEP >= (len(Constants.SIGGEN_FREQUENCY)-1):
                            Data.settings_preview["signal_generator"]["frequency_generator"]["frequency"] = Constants.SIGGEN_FREQUENCY[(len(Constants.SIGGEN_FREQUENCY)-1)]
                        else:
                            Data.settings_preview["signal_generator"]["frequency_generator"]["frequency"] = Constants.SIGGEN_FREQUENCY[int(index_freq + dy * Constants.XOVER_TYPE_STEP)]
                        MonitorTask.command_set_freq_gen_frequency(Data.settings_preview["signal_generator"]["frequency_generator"]["frequency"])


                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SIGGEN_SCREEN_FREQ_GAIN_ID:
                        print("edit frequency generator gain")
                        if Data.settings_preview["signal_generator"]["frequency_generator"]["gain"] + dy * Constants.SIGGEN_GAIN_STEP <= Constants.SIGGEN_GAIN_MIN:
                            Data.settings_preview["signal_generator"]["frequency_generator"]["gain"] = Constants.SIGGEN_GAIN_MIN
                        elif Data.settings_preview["signal_generator"]["frequency_generator"]["gain"] + dy * Constants.SIGGEN_GAIN_STEP >= Constants.SIGGEN_GAIN_MAX:
                            Data.settings_preview["signal_generator"]["frequency_generator"]["gain"] = Constants.SIGGEN_GAIN_MAX
                        else:
                            Data.settings_preview["signal_generator"]["frequency_generator"]["gain"] += float(dy * Constants.SIGGEN_GAIN_STEP)
                        MonitorTask.command_set_freq_gen_gain(Data.settings_preview["signal_generator"]["frequency_generator"]["gain"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_SIGGEN_SCREEN_PINK_GAIN_ID:
                        print("edit pink noise gain")
                        if Data.settings_preview["signal_generator"]["pink_noise"]["gain"] + dy * Constants.SIGPN_GAIN_STEP <= Constants.SIGPN_GAIN_MIN:
                            Data.settings_preview["signal_generator"]["pink_noise"]["gain"] = Constants.SIGPN_GAIN_MIN
                        elif Data.settings_preview["signal_generator"]["pink_noise"]["gain"] + dy * Constants.SIGGEN_GAIN_STEP >= Constants.SIGPN_GAIN_MAX:
                            Data.settings_preview["signal_generator"]["pink_noise"]["gain"] = Constants.SIGPN_GAIN_MAX
                        else:
                            Data.settings_preview["signal_generator"]["pink_noise"]["gain"] += float(dy * Constants.SIGPN_GAIN_STEP)
                        MonitorTask.command_set_pink_noise_gain(Data.settings_preview["signal_generator"]["pink_noise"]["gain"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_LIMITER_EDIT_ID:
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_MODE_ID:
                        print("edit mode")
                        if EncoderTask.current_peq + dy * Constants.LIMITER_TYPE_STEP <= Constants.LIMITER_TYPE_MIN:
                            EncoderTask.current_peq = Constants.LIMITER_TYPE_MIN
                        elif EncoderTask.current_peq + dy * Constants.LIMITER_TYPE_STEP >= Constants.LIMITER_TYPE_MAX:
                            EncoderTask.current_peq = Constants.LIMITER_TYPE_MAX
                        else:
                            EncoderTask.current_peq += int(dy * Constants.LIMITER_TYPE_STEP)

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_THRES_ID:
                        print("edit rms thres")
                        # Volts RMS, 2Ohms, 2.7Ohms, 4Ohms, 8Ohms, 16Ohms
                        if Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] + dy * Constants.LIMITER_RMS_THRES_M0_STEP <= Constants.LIMITER_RMS_THRES_M0_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] = Constants.LIMITER_RMS_THRES_M0_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] + dy * Constants.LIMITER_RMS_THRES_M0_STEP >= Constants.LIMITER_RMS_THRES_M0_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] = Constants.LIMITER_RMS_THRES_M0_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"] += float(dy * Constants.LIMITER_RMS_THRES_M0_STEP)
                        lim_rms_thres_in_db = round((20*math.log10(Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_thres"]))-37,2)
                        MonitorTask.command_set_limiter_rms_thres(EncoderTask.current_channel,lim_rms_thres_in_db)

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_ATTACK_ID:
                        print("edit rms attack")
                        if Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"] + dy * Constants.LIMITER_RMS_ATTACK_STEP <= Constants.LIMITER_RMS_ATTACK_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"] = Constants.LIMITER_RMS_ATTACK_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"] + dy * Constants.LIMITER_RMS_ATTACK_STEP >= Constants.LIMITER_RMS_ATTACK_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"] = Constants.LIMITER_RMS_ATTACK_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"] += float(dy * Constants.LIMITER_RMS_ATTACK_STEP)
                        MonitorTask.command_set_limiter_rms_attack(EncoderTask.current_channel,
                                                                Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_attack"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_RMS_RELEASE_ID:
                        print("edit rms release")
                        if Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"] + dy * Constants.LIMITER_RMS_RELEASE_STEP <= Constants.LIMITER_RMS_RELEASE_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"] = Constants.LIMITER_RMS_RELEASE_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"] + dy * Constants.LIMITER_RMS_RELEASE_STEP >= Constants.LIMITER_RMS_RELEASE_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"] = Constants.LIMITER_RMS_RELEASE_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"] += float(dy * Constants.LIMITER_RMS_RELEASE_STEP)
                        MonitorTask.command_set_limiter_rms_release(EncoderTask.current_channel,
                                                            Data.channels_preview[EncoderTask.current_channel]["lim_rms"]["lim_rms_release"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_THRES_ID:
                        print("edit peak thres")
                        if Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] + dy * Constants.LIMITER_PEAK_THRES_M0_STEP <= Constants.LIMITER_PEAK_THRES_M0_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] = Constants.LIMITER_PEAK_THRES_M0_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] + dy * Constants.LIMITER_PEAK_THRES_M0_STEP >= Constants.LIMITER_PEAK_THRES_M0_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] = Constants.LIMITER_PEAK_THRES_M0_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"] += float(dy * Constants.LIMITER_PEAK_THRES_M0_STEP)
                        lim_rms_thres_in_db = round((20*math.log10(Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_thres"]))-41,2)
                        MonitorTask.command_set_limiter_peak_thres(EncoderTask.current_channel,lim_rms_thres_in_db)


                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_LIMITER_EDIT_SCREEN_LIMITER_PEAK_REL_ID:
                        print("edit peak release")
                        if Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"] + dy * Constants.LIMITER_PEAK_RELEASE_STEP <= Constants.LIMITER_PEAK_RELEASE_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"] = Constants.LIMITER_PEAK_RELEASE_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"] + dy * Constants.LIMITER_PEAK_RELEASE_STEP >= Constants.LIMITER_PEAK_RELEASE_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"] = Constants.LIMITER_PEAK_RELEASE_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"] += float(dy * Constants.LIMITER_PEAK_RELEASE_STEP)
                        MonitorTask.command_set_limiter_peak_release(EncoderTask.current_channel,
                                                            Data.channels_preview[EncoderTask.current_channel]["lim_peak"]["lim_peak_release"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_XOVER_EDIT_ID:
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_INDEX_ID:
                        print("edit index")
                        if dy == -1:
                            EncoderTask.current_peq = 0
                        elif dy == 1:
                            EncoderTask.current_peq = 1

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_ENABLE_ID:
                        print("edit enable")
                        if dy == -1:
                            # High Pass Filter
                            if EncoderTask.current_peq == 0:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_enable"] = False
                            # Low Pass Filter
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_enable"] = False
                        elif dy == 1:
                            # High Pass Filter
                            if EncoderTask.current_peq == 0:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_enable"] = True
                            # Low Pass Filter
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_enable"] = True

                        # High Pass Filter
                        if EncoderTask.current_peq == 0:
                            MonitorTask.command_set_xover_hp_enable(EncoderTask.current_channel,
                                                            Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_enable"])
                        # Low Pass Filter
                        else:
                            MonitorTask.command_set_xover_lp_enable(EncoderTask.current_channel,
                                                            Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_enable"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_TYPE_ID:
                        print("edit type")
                        # High Pass Filter
                        if EncoderTask.current_peq == 0:
                            if Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"] + dy * Constants.XOVER_TYPE_STEP <= Constants.XOVER_TYPE_MIN:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"] = Constants.XOVER_TYPE_MIN
                            elif Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"] + dy * Constants.XOVER_TYPE_STEP >= Constants.XOVER_TYPE_MAX:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"] = Constants.XOVER_TYPE_MAX
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"] += int(dy * Constants.XOVER_TYPE_STEP)
                            MonitorTask.command_set_xover_hp_type(EncoderTask.current_channel, Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_type"])
                        # LOW Pass Filter
                        else:
                            if Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"] + dy * Constants.XOVER_TYPE_STEP <= Constants.XOVER_TYPE_MIN:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"] = Constants.XOVER_TYPE_MIN
                            elif Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"] + dy * Constants.XOVER_TYPE_STEP >= Constants.XOVER_TYPE_MAX:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"] = Constants.XOVER_TYPE_MAX
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"] += int(dy * Constants.XOVER_TYPE_STEP)
                            MonitorTask.command_set_xover_lp_type(EncoderTask.current_channel, Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_type"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_XOVER_EDIT_SCREEN_XOVER_FREQ_ID:
                        print("edit frequency")
                        # High Pass Filter
                        if EncoderTask.current_peq == 0:
                            if Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"] + dy * Constants.PEQ_FREQ_STEP <= Constants.PEQ_FREQ_MIN:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"] = Constants.PEQ_FREQ_MIN
                            elif Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"] + dy * Constants.PEQ_FREQ_STEP >= Constants.PEQ_FREQ_MAX:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"] = Constants.PEQ_FREQ_MAX
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"] += float(dy * Constants.PEQ_FREQ_STEP)
                            MonitorTask.command_set_xover_hp_freq(EncoderTask.current_channel, Data.channels_preview[EncoderTask.current_channel]["xover_hp_filter"]["xover_hp_freq"])
                        # LOW Pass Filter
                        else:
                            if Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"] + dy * Constants.PEQ_FREQ_STEP <= Constants.PEQ_FREQ_MIN:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"] = Constants.PEQ_FREQ_MIN
                            elif Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"] + dy * Constants.PEQ_FREQ_STEP >= Constants.PEQ_FREQ_MAX:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"] = Constants.PEQ_FREQ_MAX
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"] += float(dy * Constants.PEQ_FREQ_STEP)
                            MonitorTask.command_set_xover_lp_freq(EncoderTask.current_channel, Data.channels_preview[EncoderTask.current_channel]["xover_lp_filter"]["xover_lp_freq"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_PEQ_EDIT_ID:
                    if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_INDEX_ID:
                        print("edit index")
                        if EncoderTask.current_peq + dy * Constants.PEQ_INDEX_STEP <= Constants.PEQ_INDEX_MIN:
                            EncoderTask.current_peq = Constants.PEQ_INDEX_MIN
                        elif EncoderTask.current_peq + dy * Constants.PEQ_INDEX_STEP >= Constants.PEQ_INDEX_MAX:
                            EncoderTask.current_peq = Constants.PEQ_INDEX_MAX
                        else:
                            EncoderTask.current_peq += int(dy * Constants.PEQ_INDEX_STEP)

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_ENABLE_ID:
                        print("edit enable")
                        if dy == -1:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["enable"] = False
                        elif dy == 1:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["enable"] = True
                        MonitorTask.command_set_peq_enable(EncoderTask.current_channel, EncoderTask.current_peq,
                                                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["enable"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_TYPE_ID:
                        print("edit type")
                        if Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"] + dy * Constants.PEQ_TYPE_STEP <= Constants.PEQ_TYPE_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"] = Constants.PEQ_TYPE_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"] + dy * Constants.PEQ_TYPE_STEP >= Constants.PEQ_TYPE_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"] = Constants.PEQ_TYPE_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"] += int(dy * Constants.PEQ_TYPE_STEP)
                        MonitorTask.command_set_peq_type(EncoderTask.current_channel, EncoderTask.current_peq,
                                                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["type"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_FREQ_ID:
                        print("edit frequency")
                        if Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"] + dy * Constants.PEQ_FREQ_STEP <= Constants.PEQ_FREQ_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"] = Constants.PEQ_FREQ_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"] + dy * Constants.PEQ_FREQ_STEP >= Constants.PEQ_FREQ_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"] = Constants.PEQ_FREQ_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"] += float(dy * Constants.PEQ_FREQ_STEP)
                        MonitorTask.command_set_peq_freq(EncoderTask.current_channel, EncoderTask.current_peq,
                                                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["freq"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_GAIN_ID:
                        print("edit gain")
                        if Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"] + dy * Constants.PEQ_GAIN_STEP <= Constants.PEQ_GAIN_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"] = Constants.PEQ_GAIN_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"] + dy * Constants.PEQ_GAIN_STEP >= Constants.PEQ_GAIN_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"] = Constants.PEQ_GAIN_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"] += float(dy * Constants.PEQ_GAIN_STEP)
                        MonitorTask.command_set_peq_gain(EncoderTask.current_channel, EncoderTask.current_peq,
                                                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["gain"])

                    elif EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_PEQ_EDIT_SCREEN_PEQ_Q_ID:
                        print("edit q")
                        if Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"] + dy * Constants.PEQ_Q_STEP <= Constants.PEQ_Q_MIN:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"] = Constants.PEQ_Q_MIN
                        elif Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"] + dy * Constants.PEQ_Q_STEP >= Constants.PEQ_Q_MAX:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"] = Constants.PEQ_Q_MAX
                        else:
                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"] += float(dy * Constants.PEQ_Q_STEP)
                        MonitorTask.command_set_peq_q(EncoderTask.current_channel, EncoderTask.current_peq,
                                                            Data.channels_preview[EncoderTask.current_channel]["peq"][EncoderTask.current_peq]["q"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_DELAY_ID:
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_15_ID:
                            #ADJUST DELAY STEP (0.1ms) < 100 AND (1ms) >= 100
                            if (Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + dy * Constants.DELAY_STEP) >= 100:
                                autoDelayStep = Constants.DELAY_STEP_100
                            else:
                                autoDelayStep = Constants.DELAY_STEP

                            if Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + dy * autoDelayStep <= Constants.MIN_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = Constants.MIN_DELAY
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"] + dy * autoDelayStep >= Constants.MAX_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = float(Constants.MAX_DELAY - Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"])
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] += float(dy * autoDelayStep)
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + dy * Constants.DELAY_STEP <= Constants.MIN_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = Constants.MIN_DELAY
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"] + dy * Constants.DELAY_STEP >= Constants.MAX_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = float(Constants.MAX_DELAY - Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"])
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] += float(dy * Constants.DELAY_STEP)
                            MonitorTask.command_set_channel_delay(EncoderTask.current_item_in_screen,
                                                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"])
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] > 0:
                                MonitorTask.command_set_channel_delay_enable(EncoderTask.current_item_in_screen,True)
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] == 0:
                                MonitorTask.command_set_channel_delay_enable(EncoderTask.current_item_in_screen,False)
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_2_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + dy * Constants.DELAY_STEP <= Constants.MIN_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = Constants.MIN_DELAY
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"] + dy * Constants.DELAY_STEP >= Constants.MAX_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = float(Constants.MAX_DELAY - Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"])
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] += float(dy * Constants.DELAY_STEP)
                    else:
                        if Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_DELAY_SCREEN_CHANNEL_3_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + dy * Constants.DELAY_STEP <= Constants.MIN_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = Constants.MIN_DELAY
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] + Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"] + dy * Constants.DELAY_STEP >= Constants.MAX_DELAY:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] = float(Constants.MAX_DELAY - Data.channels_preview[EncoderTask.current_item_in_screen]["group_delay"])
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] += float(dy * Constants.DELAY_STEP)

                    MonitorTask.command_set_channel_delay(EncoderTask.current_item_in_screen, Data.channels_preview[EncoderTask.current_item_in_screen]["delay"])
                    if Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] > 0:
                        MonitorTask.command_set_channel_delay_enable(EncoderTask.current_item_in_screen,True)
                    elif Data.channels_preview[EncoderTask.current_item_in_screen]["delay"] == 0:
                        MonitorTask.command_set_channel_delay_enable(EncoderTask.current_item_in_screen,False)

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_GAIN_ID:
                    if (CURRENT_VARIANT_VALUE == "variant7.code" or CURRENT_VARIANT_VALUE == "variant8.code") :
                        if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_15_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MAX_GAIN
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] += float(dy * Constants.GAIN_STEP)
                    elif (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                        if EncoderTask.current_item_in_screen == Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MAX_GAIN
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] += float(dy * Constants.GAIN_STEP)
                            MonitorTask.command_set_channel_gain(EncoderTask.current_item_in_screen,
                                                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"])
                    elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                        if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_2_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MAX_GAIN
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] += float(dy * Constants.GAIN_STEP)
                    else :
                        if Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_0_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_GAIN_SCREEN_CHANNEL_3_ID:
                            if Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] + dy * Constants.GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] = Constants.MAX_GAIN
                            else:
                                Data.channels_preview[EncoderTask.current_item_in_screen]["gain"] += float(dy * Constants.GAIN_STEP)
                    
                    MonitorTask.command_set_channel_gain(EncoderTask.current_item_in_screen, Data.channels_preview[EncoderTask.current_item_in_screen]["gain"])

                elif EncoderTask.current_screen == Constants.SCREEN_MENU_AUDIO_SOURCE_EDIT_ID:
                    if Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_A1_ID <= EncoderTask.current_item_in_screen <= Constants.MENU_AUDIO_SOURCE_EDIT_SCREEN_G2_ID:
                        if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code") :
                            print("edit mixer gain")
                            mixerInputIndex = EncoderTask.current_item_in_screen
                            if mixerInputIndex == 1:
                                mixerInputIndex = 8
                            elif mixerInputIndex == 2:
                                mixerInputIndex = 9
                            elif mixerInputIndex == 3:
                                mixerInputIndex = 10
                            elif mixerInputIndex == 4:
                                mixerInputIndex = 11
                            if Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] + dy * Constants.MIXER_GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] + dy * Constants.MIXER_GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = round(Constants.MAX_GAIN)
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] += float(dy * Constants.MIXER_GAIN_STEP)
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = round(Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])
                            MonitorTask.command_set_channel_source_mixer(EncoderTask.current_channel, mixerInputIndex, Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])
                        elif (CURRENT_VARIANT_VALUE == "variant9.code") :
                            print("edit mixer gain")
                            mixerInputIndex = EncoderTask.current_item_in_screen
                            if mixerInputIndex == 1:
                                mixerInputIndex = 2
                            if mixerInputIndex == 2:
                                mixerInputIndex = 8
                            elif mixerInputIndex == 3:
                                mixerInputIndex = 9
                            elif mixerInputIndex == 4:
                                mixerInputIndex = 10
                            elif mixerInputIndex == 5:
                                mixerInputIndex = 11
                            if Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] + dy * Constants.MIXER_GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] + dy * Constants.MIXER_GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = round(Constants.MAX_GAIN)
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] += float(dy * Constants.MIXER_GAIN_STEP)
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = round(Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])
                            MonitorTask.command_set_channel_source_mixer(EncoderTask.current_channel, mixerInputIndex, Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])
                        else:
                            print("edit mixer gain")
                            mixerInputIndex = EncoderTask.current_item_in_screen
                            if CURRENT_VARIANT_VALUE == "variant7.code":
                                if mixerInputIndex == 5:
                                    mixerInputIndex = 8
                                elif mixerInputIndex == 6:
                                    mixerInputIndex = 9
                                elif mixerInputIndex == 7:
                                    mixerInputIndex = 10
                                elif mixerInputIndex == 8:
                                    mixerInputIndex = 11

                            if Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] + dy * Constants.MIXER_GAIN_STEP <= Constants.MIN_GAIN:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = Constants.MIN_GAIN
                            elif Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] + dy * Constants.MIXER_GAIN_STEP >= Constants.MAX_GAIN:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = round(Constants.MAX_GAIN)
                            else:
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] += float(dy * Constants.MIXER_GAIN_STEP)
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"] = round(Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])
                            MonitorTask.command_set_channel_source_mixer(EncoderTask.current_channel, mixerInputIndex,
                                Data.channels_preview[EncoderTask.current_channel]["mixer"][mixerInputIndex]["gain"])

                create_screen(EncoderTask.current_screen, EncoderTask.current_item_in_screen, EncoderTask.current_channel, EncoderTask.current_peq, EncoderTask.is_item_in_focus)

            else:
                if EncoderTask.current_screen == Constants.SCREEN_MENU_NETWORK_ID:
                    if dy > 0:
                        if EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_MODE_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_IP_0_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_0_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_SUBNET_0_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_0_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_GW_0_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_0_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_BACK_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_BACK_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_MODE_ID
                    else:
                        if EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_MODE_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_BACK_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_IP_0_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_MODE_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_SUBNET_0_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_IP_0_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_GW_0_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_SUBNET_0_ID
                        elif EncoderTask.current_item_in_screen == Constants.NETWORK_SCREEN_BACK_ID:
                            EncoderTask.current_item_in_screen = Constants.NETWORK_SCREEN_GW_0_ID
                    create_screen(Constants.SCREEN_MENU_NETWORK_ID, EncoderTask.current_item_in_screen, EncoderTask.is_item_in_focus)
                elif EncoderTask.current_screen == Constants.SCREEN_FOLDERS_GLOBAL_PRESETS_ID:
                    Data.folder_names = dbus_to_python(MonitorTask.command_get_data_global_presets_folder())
                    EncoderTask.calc_params_for_file_system_on_scroll(dy, len(Data.folder_names))
                elif EncoderTask.current_screen == Constants.SCREEN_FILES_GLOBAL_PRESETS_ID:
                    Data.file_names = dbus_to_python(MonitorTask.command_get_data_global_presets_file(Data.folder_names[EncoderTask.current_folder]))
                    EncoderTask.calc_params_for_file_system_on_scroll(dy, len(Data.file_names))
                elif EncoderTask.current_screen == Constants.SCREEN_FOLDERS_SPEAKER_PRESETS_ID:
                    if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                        Data.folder_names = dbus_to_python(MonitorTask.command_get_data_all_speaker_presets_folder())
                        EncoderTask.calc_params_for_file_system_on_scroll(dy, len(Data.folder_names))
                    else:
                        Data.folder_names = dbus_to_python(MonitorTask.command_get_data_speaker_presets_folder())
                        EncoderTask.calc_params_for_file_system_on_scroll(dy, len(Data.folder_names))

                elif EncoderTask.current_screen == Constants.SCREEN_FILES_SPEAKER_PRESETS_ID:
                    # Data.file_names = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                    if (CURRENT_VARIANT_VALUE == "variant5.code" or CURRENT_VARIANT_VALUE == "variant6.code" or CURRENT_VARIANT_VALUE == "variant9.code") :
                        temp = dbus_to_python(MonitorTask.command_get_data_all_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                    else:
                        temp = dbus_to_python(MonitorTask.command_get_data_speaker_presets_file(Data.folder_names[EncoderTask.current_folder]))
                    Data.file_names = sorted(temp, key=str.lower)
                    EncoderTask.calc_params_for_file_system_on_scroll(dy, len(Data.file_names))

                else:
                    EncoderTask.current_item_in_screen += dy
                    if EncoderTask.current_item_in_screen < 0:
                        EncoderTask.current_item_in_screen = Constants.MAX_SELECTION_ARRAY[EncoderTask.current_screen - 1] - 1
                    elif EncoderTask.current_item_in_screen > Constants.MAX_SELECTION_ARRAY[EncoderTask.current_screen - 1] - 1:
                        EncoderTask.current_item_in_screen = 0

                if EncoderTask.current_screen == Constants.SCREEN_HOME_PAGE_ID:
                    EncoderTask.home_screen_timer.cancel()
                    if EncoderTask.cancel_timers is False:
                        EncoderTask.home_screen_timer = Timer(Constants.CLEANUP_TIME, clear_home_screen)
                        EncoderTask.home_screen_timer.start()
                    EncoderTask.is_home_screen_inactive = False
                    create_screen(Constants.SCREEN_HOME_PAGE_ID, EncoderTask.current_item_in_screen)

                if EncoderTask.current_screen != Constants.SCREEN_MENU_NETWORK_ID:
                    create_screen(EncoderTask.current_screen, EncoderTask.current_item_in_screen, 
                                EncoderTask.current_channel, EncoderTask.current_peq,EncoderTask.is_item_in_focus, 
                                EncoderTask.start_position, EncoderTask.stop_position)

    @staticmethod
    def calc_params_for_file_system_on_click(selected, folder_num):
        if selected > Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM:
            EncoderTask.current_item_in_screen = (EncoderTask.current_folder + 1) % Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
            EncoderTask.start_position = ((folder_num + 1) % Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM) * Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
            EncoderTask.start_position = ((folder_num + 1) % Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM + 1) * Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
        elif selected == 0:
            EncoderTask.current_item_in_screen = 0
            EncoderTask.start_position = Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM
            if folder_num <= Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM:
                EncoderTask.stop_position = folder_num - 1
            else:
                EncoderTask.stop_position = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
        else:
            EncoderTask.current_item_in_screen = EncoderTask.current_folder
            EncoderTask.start_position = Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM
            if folder_num <= Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM:
                EncoderTask.stop_position = folder_num - 1
            else:
                EncoderTask.stop_position = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM

    @staticmethod
    def calc_params_for_file_system_on_scroll(dy, max_items):

        # first two branches are reserved for back button logic

        # No files to display => only return button
        if max_items == 0:
            EncoderTask.current_item_in_screen = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM + 1
            EncoderTask.start_position = 0
            EncoderTask.stop_position = -1
            EncoderTask.selected_item_in_file_system = 0
            # print("SA")

        elif max_items == 1:
        #Amout of files between 1 and 8
            if EncoderTask.selected_item_in_file_system == Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM:
                if dy > 0 :
                    EncoderTask.selected_item_in_file_system = 8
                    EncoderTask.current_item_in_screen = 8
                else:
                    EncoderTask.selected_item_in_file_system = 0
                    EncoderTask.current_item_in_screen = 0
            elif EncoderTask.selected_item_in_file_system == 8:
                if dy > 0 :
                    EncoderTask.selected_item_in_file_system = 8
                    EncoderTask.current_item_in_screen = 8
                else:
                    EncoderTask.selected_item_in_file_system = 0
                    EncoderTask.current_item_in_screen = 0

        elif max_items <= Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM + 1:
            EncoderTask.start_position = 0
            EncoderTask.stop_position = max_items-1
            #Current position is 0
            if EncoderTask.selected_item_in_file_system == Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM:
                if dy > 0:
                    EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen += dy
                    # print("SB")
            elif EncoderTask.selected_item_in_file_system == max_items - 1 :
                if dy > 0:
                    EncoderTask.selected_item_in_file_system = max_items
                    EncoderTask.current_item_in_screen = 8
                    # print("SQ")
                else:
                    EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen += dy
                    # print("SR")
            elif EncoderTask.selected_item_in_file_system == max_items:
                if dy < 0:
                    EncoderTask.selected_item_in_file_system = max_items - 1
                    EncoderTask.current_item_in_screen = max_items - 1
                    # print("SD")
                else:
                    EncoderTask.selected_item_in_file_system = max_items
                    EncoderTask.current_item_in_screen = 8
                    # print("SE")
            else:
                if (EncoderTask.selected_item_in_file_system >= 0 and EncoderTask.selected_item_in_file_system < max_items):
                    EncoderTask.selected_item_in_file_system += dy
                if (EncoderTask.current_item_in_screen >= 0 and EncoderTask.current_item_in_screen <= Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM):
                    EncoderTask.current_item_in_screen += dy
                # EncoderTask.selected_item_in_file_system += dy
                # EncoderTask.current_item_in_screen += dy
                # print("SF")

        # #Amout of files above 8
        elif max_items > Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM +1:
            if EncoderTask.selected_item_in_file_system == Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM and EncoderTask.start_position == Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM:
                if dy < 0:
                    EncoderTask.selected_item_in_file_system = 0
                    EncoderTask.current_item_in_screen = 0
                    # print("SG")
                else:
                    EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen += dy
                    # print("SH")
            elif (EncoderTask.selected_item_in_file_system >= Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM and EncoderTask.selected_item_in_file_system < max_items-1) :
                if dy > 0:
                    EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen = Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM
                    if (EncoderTask.start_position >= 0 and EncoderTask.stop_position < max_items-1):
                        EncoderTask.start_position += dy
                        EncoderTask.stop_position += dy
                    # print("SL")
                else :
                    EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen += dy
                    # print("SN")
            elif EncoderTask.selected_item_in_file_system >= max_items-1:
                if dy < 0:
                    EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen += dy
                    # print("SI")
                else:
                    EncoderTask.selected_item_in_file_system = max_items
                    EncoderTask.current_item_in_screen = 8
                    # print("SJ")
            elif (EncoderTask.selected_item_in_file_system > Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM and EncoderTask.current_item_in_screen == EncoderTask.start_position):
                if dy < 0:
                    if (EncoderTask.selected_item_in_file_system + dy) >= 0:
                        EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen = Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM
                    if (EncoderTask.start_position > 0 and EncoderTask.stop_position < max_items):
                        EncoderTask.start_position += dy
                        EncoderTask.stop_position += dy
                    # print("SM")
            elif (EncoderTask.selected_item_in_file_system < Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM and EncoderTask.current_item_in_screen == Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM):
                if dy < 0:
                    if (EncoderTask.selected_item_in_file_system + dy) >= 0:
                        EncoderTask.selected_item_in_file_system += dy
                    EncoderTask.current_item_in_screen = Constants.MIN_SELECTED_POSITION_IN_FILE_SYSTEM
                    if (EncoderTask.start_position > 0 and EncoderTask.stop_position < max_items):
                        EncoderTask.start_position += dy
                        EncoderTask.stop_position += dy
                    # print("SO")
                else:
                    EncoderTask.current_item_in_screen += dy
                    EncoderTask.selected_item_in_file_system += dy
                    # print("SP")
            else:
                if (EncoderTask.selected_item_in_file_system >= 0 and EncoderTask.selected_item_in_file_system < max_items):
                    EncoderTask.selected_item_in_file_system += dy
                if (EncoderTask.current_item_in_screen >= 0 and EncoderTask.current_item_in_screen <= Constants.MAX_SELECTED_POSITION_IN_FILE_SYSTEM):
                    EncoderTask.current_item_in_screen += dy

                # print("SK")

        # print("current item : " + str(EncoderTask.current_item_in_screen))
        # print("selected item in fs : " + str(EncoderTask.selected_item_in_file_system))
        # print("start position : " + str(EncoderTask.start_position))
        # print("stop position : " + str(EncoderTask.stop_position))
        # print("max item : " + str(max_items))
        # print("dy : " + str(dy))
