# import ipc_dsp_addresses

from ipc_common import DSP_VARIANT_FILE

file = open(DSP_VARIANT_FILE, "r")
about_string = str(file.read()).split(" ")
current_variant_value = about_string[0]
file.close()


NUM_OF_CHANNELS = 4
NUM_OF_MODULES = 4

if (current_variant_value == "variant1.code"):
    import ipc_dsp_addresses_variant1 as ipc_dsp_addresses
elif (current_variant_value == "variant2.code"):
    import ipc_dsp_addresses_variant2 as ipc_dsp_addresses
elif (current_variant_value == "variant3.code"):
    import ipc_dsp_addresses_variant3 as ipc_dsp_addresses
elif (current_variant_value == "variant4.code"):
    import ipc_dsp_addresses_variant4 as ipc_dsp_addresses
elif (current_variant_value == "variant5.code"):
    import ipc_dsp_addresses_variant5 as ipc_dsp_addresses
elif (current_variant_value == "variant6.code"):
    import ipc_dsp_addresses_variant6 as ipc_dsp_addresses
elif (current_variant_value == "variant7.code"):
    import ipc_dsp_addresses_variant7 as ipc_dsp_addresses
    NUM_OF_CHANNELS = 16
elif (current_variant_value == "variant8.code"):
    import ipc_dsp_addresses_variant2 as ipc_dsp_addresses
    NUM_OF_CHANNELS = 16
elif (current_variant_value == "variant9.code"):
    import ipc_dsp_addresses_variant5 as ipc_dsp_addresses
else:
    import ipc_dsp_addresses_variant1 as ipc_dsp_addresses

SERVICE_VERSION = "V1.3.5S"

DEFAULT_STRING = ""
DEFAULT_FLOAT = 0.0
DEFAULT_INT = 0
DEFAULT_BOOL = False
DEFAULT_ARRAY_4 = [0, 0, 0, 0]
DEFAULT_ARRAY_6 = [0, 0, 0, 0, 0, 0]
DEFAULT_ARRAY_EMPTY = []
DEFAULT_FILTER = {"a0": 1.0, "a1": 0, "a2": 0, "b0": 1.0, "b1": 0, "b2": 0}
DEFAULT_PEQ = {"ena": False, "frequency": 100, "gain": 0.0, "q": 2.5, "type": 0}
DEFAULT_GAIN_VALUE = 0.0
DEFAULT_POLARITY_VALUE = False
DEFAULT_XOVER_FILTER = [DEFAULT_FILTER, DEFAULT_FILTER, DEFAULT_FILTER, DEFAULT_FILTER]
DEFAULT_LAN_CONFIG_DICTIONARY = {"ip": "0.0.0.0", "mask": "0.0.0.0", "gateway": "0.0.0.0", "dhcp": True}
DEFAULT_SPOTIFY_CONFIG_DICTIONARY = {"device_name": "xxx", "email": "xx@xx.xx", "password": "xxx", "enable": False}

OLD_CHANNEL_NAME = ["Output Name 1", "Output Name 2", "Output Name 3", "Output Name 4", "Output Name 5", "Output Name 6", "Output Name 7", "Output Name 8", "Output Name 9", "Output Name 10", "Output Name 11", "Output Name 12", "Output Name 13", "Output Name 14", "Output Name 15", "Output Name 16"]
NEW_CHANNEL_NAME = ["Output A", "Output B", "Output C", "Output D", "Output E", "Output F", "Output G", "Output H", "Output I", "Output J", "Output K", "Output L", "Output M", "Output N", "Output O", "Output P"]

# Hi-Z filter
DEFAULT_HIZ_DISABLE = [0.999773323535919, -1.99954664707184, 0.999773323535919, -0.999546647071838, 1.99954658746719]
DEFAULT_HIZ_ENABLE = [0.990786671638489, -1.98157340288162, 0.990786671638489, -0.981658279895782, 1.98148852586746]

DEFAULT_GAIN_POLARITY = False

DEFAULT_DELAY_VALUE = 0.0
DEFAULT_DELAY_ENABLE = False

DEFAULT_PEQ_ENABLE = False
DEFAULT_PEQ_TYPE = 0
DEFAULT_PEQ_FREQ = [50, 100, 200, 300, 400, 500, 1000, 2000, 3000, 4000, 5000, 10000]
DEFAULT_PEQ_GAIN = 0.0
DEFAULT_PEQ_Q = 2.5

DSP_1_I2C_ADDRESS = 0x3b
DSP_2_I2C_ADDRESS = 0x3a
DSP_3_I2C_ADDRESS = 0x39
DSP_4_I2C_ADDRESS = 0x38

XOVER_HP_TYPE = 0
XOVER_LP_TYPE = 1

MAX_USER_AND_GROUP_DELAY_VALUE = 250.0
MAX_SPEAKER_DELAY_VALUE = 30.0

NUM_OF_LIM_RMS_THRESHOLD_POINTS = 106
NUM_OF_LIM_PEAK_THRESHOLD_POINTS = 124
NUM_OF_FIR_COEFFICIENT = 768
NUM_OF_PEQ_FILTERS = 12
# # NUM_OF_CHANNELS = 4
# NUM_OF_CHANNELS = 16
NUM_OF_GROUPS = 6
NUM_OF_INPUTS = 12
NUM_OF_SOURCE = 12
NUM_OF_SOURCE_REDUCED = 10

UDP_GAIN_MIN = -80.0
UDP_GAIN_MAX = 15.0

LIM_RMS_THRES_MAX = 5.3
LIM_PEAK_THRES_MAX = 4.1

#Frequency generator default value
SIG_GEN_FREQ_DEFAULT = 1000
SIG_GEN_FREQ_GAIN_DEFAULT = -50.0
SIG_GEN_PINK_NOISE_GAIN_DEFAULT = -50.0

THR_N40 = {"value": -40.0, "position": 0}
THR_N30 = {"value": -30.0, "position": 79}
THR_N20 = {"value": -20.0, "position": 181}
THR_N10 = {"value": -10.0, "position": 314}
THR_P00 = {"value": 0.0, "position": 485}
THR_P05 = {"value": 5.0, "position": 596}
THR_P10 = {"value": 10.0, "position": 712}
THR_P15 = {"value": 15.0, "position": 845}
THR_P20 = {"value": 20.0, "position": 1000}

ATT_01_0 = {"value": 1.0, "position": 0}
ATT_02_5 = {"value": 2.5, "position": 139}
ATT_05_0 = {"value": 5.0, "position": 270}
ATT_10_0 = {"value": 10.0, "position": 422}
ATT_20_0 = {"value": 20.0, "position": 591}
ATT_30_0 = {"value": 30.0, "position": 690}
ATT_50_0 = {"value": 50.0, "position": 822}
ATT_100_0 = {"value": 100.0, "position": 1000}

REL_05 = {"value": 5.0, "position": 0}
REL_10 = {"value": 10.0, "position": 108}
REL_25 = {"value": 25.0, "position": 295}
REL_50 = {"value": 50.0, "position": 453}
REL_100 = {"value": 100.0, "position": 613}
REL_250 = {"value": 250.0, "position": 835}
REL_500 = {"value": 500.0, "position": 1000}

LIM_00dB = {"dbValue": 0, "sliderValue": 1000}
LIM_05dB = {"dbValue": -5, "sliderValue": 873}
LIM_10dB = {"dbValue": -10, "sliderValue": 748}
LIM_15dB = {"dbValue": -15, "sliderValue": 624}
LIM_20dB = {"dbValue": -20, "sliderValue": 498}
LIM_25dB = {"dbValue": -25, "sliderValue": 400}
LIM_30dB = {"dbValue": -30, "sliderValue": 299}
LIM_35dB = {"dbValue": -35, "sliderValue": 212}
LIM_40dB = {"dbValue": -40, "sliderValue": 150}
LIM_50dB = {"dbValue": -50, "sliderValue": 75}
LIM_60dB = {"dbValue": -60, "sliderValue": 25}

CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_GROUP_0_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_GROUP_1_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_GROUP_2_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_GROUP_3_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_GROUP_4_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_GROUP_5_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_GROUP_0_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_GROUP_1_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_GROUP_2_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_GROUP_3_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_GROUP_4_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_GROUP_5_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_0_USER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_USER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_USER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_USER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PEQ_ALG0_STAGE11_B2_ADDR]


CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_1_SPEAKER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PEQ_ALG0_STAGE11_B2_ADDR]

CHANNEL_3_SPEAKER_PEQ_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE1_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE2_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE3_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE4_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE5_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE6_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE7_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE8_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE9_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE10_B2_ADDR,
                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PEQ_ALG0_STAGE11_B2_ADDR]

VARIANT_12_GROUP_0_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_PHASE_ADDR]

VARIANT_3_GROUP_0_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_PHASE_ADDR]

VARIANT_4_GROUP_0_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_PHASE_ADDR]

VARIANT_12_GROUP_1_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_PHASE_ADDR]

VARIANT_3_GROUP_1_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_PHASE_ADDR]

VARIANT_4_GROUP_1_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_PHASE_ADDR]

VARIANT_12_GROUP_2_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_PHASE_ADDR]

VARIANT_3_GROUP_2_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_PHASE_ADDR]

VARIANT_4_GROUP_2_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_PHASE_ADDR]

VARIANT_12_GROUP_3_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_PHASE_ADDR]

VARIANT_3_GROUP_3_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_PHASE_ADDR]

VARIANT_4_GROUP_3_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_PHASE_ADDR]

VARIANT_12_GROUP_4_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_PHASE_ADDR]

VARIANT_3_GROUP_4_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_PHASE_ADDR]

VARIANT_4_GROUP_4_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_PHASE_ADDR]

VARIANT_12_GROUP_5_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PHASE_ADDR,
                                         ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_PHASE_ADDR]

VARIANT_3_GROUP_5_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_PHASE_ADDR]

VARIANT_4_GROUP_5_POLARITY_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR,
                                        ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_PHASE_ADDR]

VARIANT_12_GROUP_0_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_2_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_4_GAIN_ALG0_TARGET_ADDR]

VARIANT_3_GROUP_0_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_3_GAIN_ALG0_TARGET_ADDR]

VARIANT_4_GROUP_0_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP1_1_GAIN_ALG0_TARGET_ADDR]

VARIANT_12_GROUP_1_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_2_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_4_GAIN_ALG0_TARGET_ADDR]

VARIANT_3_GROUP_1_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_3_GAIN_ALG0_TARGET_ADDR]

VARIANT_4_GROUP_1_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP2_1_GAIN_ALG0_TARGET_ADDR]

VARIANT_12_GROUP_2_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_2_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_4_GAIN_ALG0_TARGET_ADDR]

VARIANT_3_GROUP_2_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_3_GAIN_ALG0_TARGET_ADDR]

VARIANT_4_GROUP_2_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP3_1_GAIN_ALG0_TARGET_ADDR]

VARIANT_12_GROUP_3_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_2_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_4_GAIN_ALG0_TARGET_ADDR]

VARIANT_3_GROUP_3_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_3_GAIN_ALG0_TARGET_ADDR]

VARIANT_4_GROUP_3_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP4_1_GAIN_ALG0_TARGET_ADDR]

VARIANT_12_GROUP_4_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_2_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_4_GAIN_ALG0_TARGET_ADDR]

VARIANT_3_GROUP_4_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_3_GAIN_ALG0_TARGET_ADDR]

VARIANT_4_GROUP_4_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP5_1_GAIN_ALG0_TARGET_ADDR]

VARIANT_12_GROUP_5_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_2_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_GAIN_ALG0_TARGET_ADDR,
                                     ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_4_GAIN_ALG0_TARGET_ADDR]

VARIANT_3_GROUP_5_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_3_GAIN_ALG0_TARGET_ADDR]

VARIANT_4_GROUP_5_GAIN_ADDRESSES = [ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR,
                                    ipc_dsp_addresses.MOD_GROUP_SETTINGS_GROUP6_1_GAIN_ALG0_TARGET_ADDR]

CHANNEL_0_SOURCE_ADDRESSES = [ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_00_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_01_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_02_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_03_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_04_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_05_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_06_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_07_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_08_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_09_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_10_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_1_ALG0_STAGE0_TARGET_00_11_ADDR]

CHANNEL_1_SOURCE_ADDRESSES = [ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_00_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_01_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_02_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_03_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_04_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_05_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_06_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_07_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_08_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_09_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_10_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_2_ALG0_STAGE0_TARGET_00_11_ADDR]

CHANNEL_2_SOURCE_ADDRESSES = [ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_00_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_01_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_02_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_03_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_04_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_05_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_06_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_07_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_08_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_09_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_10_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_3_ALG0_STAGE0_TARGET_00_11_ADDR]

CHANNEL_3_SOURCE_ADDRESSES = [ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_00_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_01_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_02_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_03_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_04_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_05_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_06_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_07_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_08_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_09_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_10_ADDR,
                              ipc_dsp_addresses.MOD_SOURCE_4_ALG0_STAGE0_TARGET_00_11_ADDR]

VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR,
                                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2POINTS0_ADDR,
                                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3POINTS0_ADDR,
                                                      ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4POINTS0_ADDR]

VARIANT_3_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3POINTS0_ADDR]

VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1POINTS0_ADDR]

VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3POINTS0_ADDR,
                                                     ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4POINTS0_ADDR]

VARIANT_3_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR,
                                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3POINTS0_ADDR,
                                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR,
                                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3POINTS0_ADDR]

VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES = [ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR,
                                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR,
                                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR,
                                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1POINTS0_ADDR]

VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR,
                                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X6POINTS0_ADDR,
                                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7POINTS0_ADDR,
                                                         ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X8POINTS0_ADDR]

VARIANT_3_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7POINTS0_ADDR]

VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5POINTS0_ADDR]

VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7POINTS0_ADDR,
                                                        ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8POINTS0_ADDR]

VARIANT_3_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR,
                                                       ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7POINTS0_ADDR,
                                                       ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR,
                                                       ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7POINTS0_ADDR]

VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR,
                                                       ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR,
                                                       ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR,
                                                       ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5POINTS0_ADDR]

VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR,
                                                ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_FIR_ALG0_FIRSIGMA300ALG2FIRCOEFF0_ADDR,
                                                ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_FIR_ALG0_FIRSIGMA300ALG3FIRCOEFF0_ADDR,
                                                ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_FIR_ALG0_FIRSIGMA300ALG4FIRCOEFF0_ADDR]

VARIANT_3_SPEAKER_FIR_TABLE_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR,
                                               ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_FIR_ALG0_FIRSIGMA300ALG3FIRCOEFF0_ADDR,
                                               ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR,
                                               ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_FIR_ALG0_FIRSIGMA300ALG3FIRCOEFF0_ADDR]

VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES = [ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR,
                                               ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR,
                                               ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR,
                                               ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_FIR_ALG0_FIRSIGMA300ALG1FIRCOEFF0_ADDR]

VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES = [ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_2_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_3_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_4_ALG0_STAGE0_B2_ADDR]

VARIANT_3_HIZ_DCBLOCK_START_ADDRESSES = [ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_3_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_3_ALG0_STAGE0_B2_ADDR]

VARIANT_4_HIZ_DCBLOCK_START_ADDRESSES = [ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR,
                                         ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_DCBLOCKING_1_ALG0_STAGE0_B2_ADDR]

                                         
#  these adresses are fixed in Sigma studio
READBACK_OUTPUT_LEVEL_1_ADDRESS = 24592
READBACK_OUTPUT_LEVEL_2_ADDRESS = 24593
READBACK_OUTPUT_LEVEL_3_ADDRESS = 24594
READBACK_OUTPUT_LEVEL_4_ADDRESS = 24595

READBACK_USER_1_LIM_RMS_ADDRESS = 24596
READBACK_USER_1_LIM_PEAK_ADDRESS = 24597
READBACK_SPEAKER_1_LIM_RMS_ADDRESS = 24598
READBACK_SPEAKER_1_LIM_PEAK_ADDRESS = 24599
READBACK_AMP_1_LIM_ADDRESS = 24600
READBACK_USER_2_LIM_RMS_ADDRESS = 24601
READBACK_USER_2_LIM_PEAK_ADDRESS = 24602
READBACK_SPEAKER_2_LIM_RMS_ADDRESS = 24603
READBACK_SPEAKER_2_LIM_PEAK_ADDRESS = 24604
READBACK_AMP_2_LIM_ADDRESS = 24605
READBACK_USER_3_LIM_RMS_ADDRESS = 24606
READBACK_USER_3_LIM_PEAK_ADDRESS = 24607
READBACK_SPEAKER_3_LIM_RMS_ADDRESS = 24608
READBACK_SPEAKER_3_LIM_PEAK_ADDRESS = 24609
READBACK_AMP_3_LIM_ADDRESS = 24610
READBACK_USER_4_LIM_RMS_ADDRESS = 24611
READBACK_USER_4_LIM_PEAK_ADDRESS = 24612
READBACK_SPEAKER_4_LIM_RMS_ADDRESS = 24613
READBACK_SPEAKER_4_LIM_PEAK_ADDRESS = 24614
READBACK_AMP_4_LIM_ADDRESS = 24615


READBACK_STATUS_START_READ = 24586
READBACK_STATUS_LENGTH = 24 # 6 bytes
READBACK_AMPON_ADDRESS = 24586
READBACK_SMPS_ADDRESS = 24587
READBACK_TEMPRAW_ADDRESS = 24588
READBACK_SW_REVISION_ADDRESS = 24589
READBACK_AVERAGE_POWER_ADDRESS = 24590
READBACK_OVERTEMP_ADDRESS = 24591


READBACK_LIMITER_ADDRESSES = [READBACK_USER_1_LIM_RMS_ADDRESS,
                              READBACK_USER_2_LIM_RMS_ADDRESS,
                              READBACK_USER_3_LIM_RMS_ADDRESS,
                              READBACK_USER_4_LIM_RMS_ADDRESS,
                              READBACK_USER_1_LIM_PEAK_ADDRESS,
                              READBACK_USER_2_LIM_PEAK_ADDRESS,
                              READBACK_USER_3_LIM_PEAK_ADDRESS,
                              READBACK_USER_4_LIM_PEAK_ADDRESS,
                              READBACK_SPEAKER_1_LIM_RMS_ADDRESS,
                              READBACK_SPEAKER_2_LIM_RMS_ADDRESS,
                              READBACK_SPEAKER_3_LIM_RMS_ADDRESS,
                              READBACK_SPEAKER_4_LIM_RMS_ADDRESS,
                              READBACK_SPEAKER_1_LIM_PEAK_ADDRESS,
                              READBACK_SPEAKER_2_LIM_PEAK_ADDRESS,
                              READBACK_SPEAKER_3_LIM_PEAK_ADDRESS,
                              READBACK_SPEAKER_4_LIM_PEAK_ADDRESS,
                              READBACK_AMP_1_LIM_ADDRESS,
                              READBACK_AMP_2_LIM_ADDRESS,
                              READBACK_AMP_3_LIM_ADDRESS,
                              READBACK_AMP_4_LIM_ADDRESS]
