from multiprocessing.dummy import Array
import ipc_constants
import ipc_filters
import ipc_util
from ipc_constants import DSP_1_I2C_ADDRESS, DSP_2_I2C_ADDRESS, DSP_3_I2C_ADDRESS, DSP_4_I2C_ADDRESS
from ipc_util import convert_to_8_24
from smbus2 import SMBus, i2c_msg
from ipc_common import DSP_VARIANT_FILE
from ipc_util import transform_register_address
import time

file = open(DSP_VARIANT_FILE, "r")
about_string = str(file.read()).split(" ")
current_variant_value = about_string[0]
file.close()

if (current_variant_value == "variant1.code"):
    import ipc_dsp_addresses_variant1 as ipc_dsp_addresses
elif (current_variant_value == "variant2.code"):
    import ipc_dsp_addresses_variant2 as ipc_dsp_addresses
elif (current_variant_value == "variant3.code"):
    import ipc_dsp_addresses_variant3 as ipc_dsp_addresses
elif (current_variant_value == "variant4.code"):
    import ipc_dsp_addresses_variant4 as ipc_dsp_addresses
elif (current_variant_value == "variant5.code"):
    import ipc_dsp_addresses_variant5 as ipc_dsp_addresses
elif (current_variant_value == "variant6.code"):
    import ipc_dsp_addresses_variant6 as ipc_dsp_addresses
elif (current_variant_value == "variant7.code"):
    import ipc_dsp_addresses_variant7 as ipc_dsp_addresses
elif (current_variant_value == "variant8.code"):
    import ipc_dsp_addresses_variant2 as ipc_dsp_addresses
elif (current_variant_value == "variant9.code"):
    import ipc_dsp_addresses_variant5 as ipc_dsp_addresses
else:
    import ipc_dsp_addresses_variant1 as ipc_dsp_addresses


# import ipc_dsp_addresses


VARIANT_7_DSP_ADDRESSES = [DSP_1_I2C_ADDRESS,
                           DSP_2_I2C_ADDRESS,
                           DSP_3_I2C_ADDRESS,
                           DSP_4_I2C_ADDRESS]

VARIANT_4_DSP_ADDRESSES = [DSP_1_I2C_ADDRESS,
                           DSP_2_I2C_ADDRESS,
                           DSP_3_I2C_ADDRESS,
                           DSP_4_I2C_ADDRESS]

VARIANT_3_DSP_ADDRESSES = [DSP_1_I2C_ADDRESS,
                           DSP_1_I2C_ADDRESS,
                           DSP_2_I2C_ADDRESS,
                           DSP_2_I2C_ADDRESS]

def dsp_amp_module_disable(variant, channel, disabled):
    if disabled:
        data_for_dsp = int(1)
    else:
        data_for_dsp = int(0)

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 4:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 5:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 6:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 7:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 8:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 9:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 10:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 11:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 12:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 13:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 14:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 15:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)

def dsp_amp_stage_disable(variant, disabled):
    if disabled:
        data_for_dsp = int(1)
    else:
        data_for_dsp = int(0)

    if (variant == "variant7" or variant == "variant8"):
        send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    elif variant == "variant6":
        send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    elif variant == "variant4":
        send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    elif variant == "variant3":
        send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
        send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5
        send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_POWER_AMPLIFIERS_AMP_DISABLE_DCINPALG145X7VALUE_ADDR, data_for_dsp)


def dsp_solo_mute(variant, channel, muted):
    if muted:
        data_for_dsp = int(0)
    else:
        data_for_dsp = int(1)

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 4:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 5:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 6:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 7:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 8:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 9:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 10:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 11:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 12:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 13:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 14:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 15:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
    elif variant == "variant9":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_MUTE_ALG0_MUTE_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_MUTE_ALG0_MUTE_ADDR, data_for_dsp)


def dsp_channel_delay_config(variant, channel, delay_in_ms):
    delay_in_samples = delay_in_ms * (ipc_filters.fs / 1000)

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_2_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_4_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 4:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 5:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_2_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 6:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 7:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_4_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 8:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 9:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_2_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 10:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 11:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_4_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 12:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 13:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_2_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 14:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 15:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_4_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant6":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant4":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant3":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant9.code":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_2_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_4_DELAYAMT_ADDR, delay_in_samples)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_1_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_2_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_3_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_DELAYPOOL_4_DELAYAMT_ADDR, delay_in_samples)


def dsp_channel_delay_speaker_config(variant, channel, delay_in_ms):
    delay_in_samples = delay_in_ms * (ipc_filters.fs / 1000)

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 4:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 5:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 6:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 7:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 8:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 9:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 10:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 11:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 12:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 13:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 14:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 15:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_DELAY_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant6":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant4":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant3":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
    elif variant == "variant9":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_DELAY_DELAYAMT_ADDR, delay_in_samples)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_DELAY_DELAYAMT_ADDR, delay_in_samples)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_DELAY_DELAYAMT_ADDR, delay_in_samples)


def dsp_channel_gain_solo_config(variant, channel, gain):
    #  Condition from Liviau
    if gain > -85:
        data_for_dsp = pow(10, float(gain) / 20)
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 4:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 5:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 6:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 7:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 8:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 9:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 10:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 11:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 12:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 13:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 14:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 15:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant9":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)


def dsp_channel_gain_speaker_config(variant, channel, gain):
    #  Condition from Liviau
    if gain > -85:
        data_for_dsp = pow(10, float(gain) / 20)
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 4:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 5:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 6:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 7:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 8:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 9:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 10:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 11:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 12:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 13:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 14:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 15:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_GAIN_ALG0_TARGET_ADDR, data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_GAIN_ALG0_TARGET_ADDR, data_for_dsp)


def dsp_channel_source_config(variant, channel, source, data):  # data 0 or 1, 0 if inactive source, 1 if active
    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], int(data))
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], int(data))
        elif channel == 4:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 5:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], int(data))
        elif channel == 6:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 7:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], int(data))
        elif channel == 8:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 9:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], int(data))
        elif channel == 10:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 11:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], int(data))
        elif channel == 12:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 13:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], int(data))
        elif channel == 14:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 15:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], int(data))
    elif variant == "variant6":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
    elif variant == "variant4":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 1:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 2:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 3:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
    elif variant == "variant3":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 2:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 3:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
    elif variant == "variant9":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], int(data))
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], int(data))
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], int(data))
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], int(data))
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], int(data))
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], int(data))


def dsp_channel_source_mixer(variant, channel, source, gain):
    #  Condition from Liviau
    if gain > -80:
        data_for_dsp = pow(10, float(gain) / 20)
    else:
        data_for_dsp = 0

    #invert signal from dante board to by in phase with analog in
    if source == 4 or source == 5 or source == 6 or source == 7:
        data_for_dsp = -data_for_dsp

    if variant == "variant8":
        #AMP1 receive 1->4 dante flows
        #AMP2 receive 1->4 dante flows
        #AMP3 receive 1->4 dante flows
        #AMP4 receive 1->4 dante flows
        #WebUI send dante flow as network input 1 (channel == 4)
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 4:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 5:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 6:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 7:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 8:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 9:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 10:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 11:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 12:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 13:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 14:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 15:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
    elif variant == "variant7":
        #AMP1 receive 1->4 dante flows
        #AMP2 receive 5->8 dante flows
        #AMP3 receive 9->12 dante flows
        #AMP4 receive 13->16 dante flows
        #WebUI send dante flow as network input 1 (channel == 4)
        if (source <=4) or (source >=8):
            if channel == 0:
                if source == 4:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
                else:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 1:
                if source == 4:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[(source+1)], data_for_dsp)
                else:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 2:
                if source == 4:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[(source+2)], data_for_dsp)
                else:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 3:
                if source == 4:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[(source+3)], data_for_dsp)
                else:
                    send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 4:
                if source == 4:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
                else:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 5:
                if source == 4:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[(source+1)], data_for_dsp)
                else:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 6:
                if source == 4:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[(source+2)], data_for_dsp)
                else:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 7:
                if source == 4:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[(source+3)], data_for_dsp)
                else:
                    send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 8:
                if source == 4:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
                else:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 9:
                if source == 4:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[(source+1)], data_for_dsp)
                else:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 10:
                if source == 4:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[(source+2)], data_for_dsp)
                else:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 11:
                if source == 4:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[(source+3)], data_for_dsp)
                else:
                    send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 12:
                if source == 4:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
                else:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 13:
                if source == 4:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[(source+1)], data_for_dsp)
                else:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 14:
                if source == 4:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[(source+2)], data_for_dsp)
                else:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
            elif channel == 15:
                if source == 4:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[(source+3)], data_for_dsp)
                else:
                    send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
    elif variant == "variant9":
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SOURCE_ADDRESSES[source], data_for_dsp)
        elif channel == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SOURCE_ADDRESSES[source], data_for_dsp)


def dsp_generator_set_sinewave_freq(variant, frequency):
    data_for_dsp = frequency/24000

    if (variant == "variant7" or variant == "variant8"):
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[1], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[3], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
    elif variant == "variant4":
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[1], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[3], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
    elif variant == "variant3":
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5 and 6 and 9
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SINEWAVE_ALG0_INCREMENT_ADDR, data_for_dsp)


def dsp_generator_set_sinewave_gain(variant, gain):
    # Condition from Liviau
    if gain > -80.0:
        data_for_dsp = pow(10, float(gain) / 20)
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[1], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[3], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
    elif variant == "variant4":
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[1], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[3], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
    elif variant == "variant3":
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5 and 6 nad 9
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SINEWAVE_ALG0_SINEPHASEGAINALGS3001GAIN00_ADDR, data_for_dsp)


def dsp_generator_set_pinknoise_gain(variant, gain):
    # Condition from Liviau
    if gain > -80.0:
        data_for_dsp = pow(10, float(gain) / 20)
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[1], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[3], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
    elif variant == "variant4":
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[1], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[3], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
    elif variant == "variant3":
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[0], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[2], ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5 and 6 and 9
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_PINKNOISE_ALG0_PINKFALGS3001OUTPUTGAIN_ADDR, data_for_dsp)


def dsp_group_gain_set(variant, channel, group_number, gain):
    # Condition from Liviau
    if gain > -85:
        data_for_dsp = pow(10, float(gain) / 20)
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
        if group_number == 0:
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_0_GAIN_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 1:
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_1_GAIN_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 2:
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_2_GAIN_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 3:
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_3_GAIN_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 4:
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_4_GAIN_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 5:
            send_float_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_5_GAIN_ADDRESSES[channel%4], data_for_dsp)
    elif variant == "variant6":
        if group_number == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
    elif variant == "variant4":
        if group_number == 0:
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_1_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_2_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_3_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_4_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_float_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_5_GAIN_ADDRESSES[channel], data_for_dsp)
    elif variant == "variant3":
        if group_number == 0:
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_1_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_2_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_3_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_4_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_float_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_5_GAIN_ADDRESSES[channel], data_for_dsp)
    else:  # variant 1 and 2 and 5 and 9
        if group_number == 0:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_0_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_1_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_2_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_3_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_4_GAIN_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_float_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_5_GAIN_ADDRESSES[channel], data_for_dsp)


def dsp_group_polarity(variant, channel, group_number, polarity):
    if polarity:
        data_for_dsp = 1
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
        if group_number == 0:
            send_int_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_0_POLARITY_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 1:
            send_int_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_1_POLARITY_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 2:
            send_int_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_2_POLARITY_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 3:
            send_int_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_3_POLARITY_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 4:
            send_int_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_4_POLARITY_ADDRESSES[channel%4], data_for_dsp)
        elif group_number == 5:
            send_int_data_command(VARIANT_7_DSP_ADDRESSES[channel//4], ipc_constants.VARIANT_12_GROUP_5_POLARITY_ADDRESSES[channel%4], data_for_dsp)
    elif variant == "variant6":
        if group_number == 0:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_0_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_1_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_2_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_3_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_4_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_5_POLARITY_ADDRESSES[channel], data_for_dsp)
    elif variant == "variant4":
        if group_number == 0:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_0_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_1_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_2_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_3_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_4_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_int_data_command(VARIANT_4_DSP_ADDRESSES[channel], ipc_constants.VARIANT_4_GROUP_5_POLARITY_ADDRESSES[channel], data_for_dsp)
    elif variant == "variant3":
        if group_number == 0:
            send_int_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_0_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_int_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_1_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_int_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_2_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_int_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_3_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_int_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_4_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_int_data_command(VARIANT_3_DSP_ADDRESSES[channel], ipc_constants.VARIANT_3_GROUP_5_POLARITY_ADDRESSES[channel], data_for_dsp)
    else:  # variant 1 and 2 and 5 and 9
        if group_number == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_0_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_1_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_2_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_3_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 4:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_4_POLARITY_ADDRESSES[channel], data_for_dsp)
        elif group_number == 5:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_GROUP_5_POLARITY_ADDRESSES[channel], data_for_dsp)


def dsp_solo_polarity(variant, channel, polarity):
    if polarity:
        data_for_dsp = 1
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PHASE_ADDR, data_for_dsp)
        elif channel == 4:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 5:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 6:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 7:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PHASE_ADDR, data_for_dsp)
        elif channel == 8:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 9:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 10:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 11:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PHASE_ADDR, data_for_dsp)
        elif channel == 12:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 13:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 14:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 15:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PHASE_ADDR, data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
    elif variant == "variant9":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PHASE_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_PHASE_ADDR, data_for_dsp)


def dsp_speaker_polarity(variant, channel, polarity):
    if polarity:
        data_for_dsp = 1
    else:
        data_for_dsp = 0

    if (variant == "variant7" or variant == "variant8"):
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PHASE_ADDR, data_for_dsp)
        elif channel == 4:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 5:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 6:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 7:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PHASE_ADDR, data_for_dsp)
        elif channel == 8:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 9:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 10:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 11:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PHASE_ADDR, data_for_dsp)
        elif channel == 12:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 13:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 14:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 15:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PHASE_ADDR, data_for_dsp)
    elif variant == "variant6":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
    elif variant == "variant4":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
    elif variant == "variant3":
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
    else:  # variant 1 and 2 and 5 and 9
        if channel == 0:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_PHASE_ADDR, data_for_dsp)
        elif channel == 1:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_PHASE_ADDR, data_for_dsp)
        elif channel == 2:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_PHASE_ADDR, data_for_dsp)
        elif channel == 3:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_PHASE_ADDR, data_for_dsp)


def dsp_global_boot_preset(variant, user_settings, group_settings, speaker_settings, global_settings):

    # First, mute channels
    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        dsp_solo_mute(variant, i_channel, True)

    # SIGNAL GENERATOR
    # set signal generator settiings
    dsp_generator_set_pinknoise_gain(variant, global_settings["signal_generator"]["pink_noise"]["gain"])
    dsp_generator_set_sinewave_freq(variant, global_settings["signal_generator"]["frequency_generator"]["frequency"])
    dsp_generator_set_sinewave_gain(variant, global_settings["signal_generator"]["frequency_generator"]["gain"])

    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        # # Set source
        # if 0 == user_settings[i_channel]["active_source"]:  # primary source is active
        #     dsp_channel_source_config(variant, i_channel, user_settings[i_channel]["source_pri"], 1)
        # elif 1 == user_settings[i_channel]["active_source"]:  # secondary source is active
        #     dsp_channel_source_config(variant, i_channel, user_settings[i_channel]["source_sec"], 1)
        for j_source in range(0, ipc_constants.NUM_OF_INPUTS):
            dsp_channel_source_mixer(variant, i_channel, j_source, user_settings[i_channel]["mixer"][j_source]["gain"])
        ################################################################################################################
        # USER PART
        #  set speaker gain
        dsp_channel_gain_solo_config(variant, i_channel, float(user_settings[i_channel]["gain"]))
        #  set speaker polarity
        dsp_solo_polarity(variant, i_channel, bool(user_settings[i_channel]["polarity"]))
        #  set speaker delay
        sum_delay_value = int(user_settings[i_channel]["delay_enable"]) * user_settings[i_channel]["delay_value"] + user_settings[i_channel]["group_delay_value"]
        if sum_delay_value > ipc_constants.MAX_USER_AND_GROUP_DELAY_VALUE:
            dsp_channel_delay_config(variant, i_channel, ipc_constants.MAX_USER_AND_GROUP_DELAY_VALUE)
        else:
            dsp_channel_delay_config(variant, i_channel, sum_delay_value)
        # #  set speaker IIR HPF (if enabled)
        if user_settings[i_channel]["xover_hp_filter"]["xover_hp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(user_settings[i_channel]["xover_hp_filter"]["xover_hp_type"],
                                                                  ipc_constants.XOVER_HP_TYPE,
                                                                  user_settings[i_channel]["xover_hp_filter"]["xover_hp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_solo_xover_hp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker IIR LPF (if enabled)
        if user_settings[i_channel]["xover_lp_filter"]["xover_lp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(user_settings[i_channel]["xover_lp_filter"]["xover_lp_type"],
                                                                  ipc_constants.XOVER_LP_TYPE,
                                                                  user_settings[i_channel]["xover_lp_filter"]["xover_lp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_solo_xover_lp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker 12 x PEQ (if each of them is enabled)
        for peq_channel in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
            array_coeff = ipc_util.recalculate_peq_values(user_settings, i_channel, peq_channel)
            dsp_set_solo_peq_filter_coeff(variant, i_channel, peq_channel, array_coeff)
        #  set speaker RMS LIM threshold
        threshold_points = ipc_util.calculate_compressor_rms_coefficients(user_settings[i_channel]["lim_rms"]["lim_rms_thres"])
        dsp_set_solo_lim_rms_thres(variant, i_channel, threshold_points)
        #  set speaker RMS LIM attack
        dsp_set_solo_lim_rms_attack(variant, i_channel, user_settings[i_channel]["lim_rms"]["lim_rms_attack"])
        #  set speaker RMS LIM release
        dsp_set_solo_lim_rms_release(variant, i_channel, user_settings[i_channel]["lim_rms"]["lim_rms_release"])
        #  set speaker PEAK LIM threshold
        threshold_points = ipc_util.calculate_compressor_peak_coefficients(user_settings[i_channel]["lim_peak"]["lim_peak_thres"])
        dsp_set_solo_lim_peak_thres(variant, i_channel, threshold_points)
        #  set speaker PEAK LIM release
        dsp_set_solo_lim_peak_release(variant, i_channel, user_settings[i_channel]["lim_peak"]["lim_peak_release"])
        ################################################################################################################
        # GROUP PART
        for i_group in range(0, ipc_constants.NUM_OF_GROUPS):
            if 0 == int(user_settings[i_channel]["assigned_to_group"][i_group]):
                # mute is send at the end
                # delay values, already sent
                # sending default gain value
                dsp_group_gain_set(variant, i_channel, i_group, ipc_constants.DEFAULT_GAIN_VALUE)
                # sending polarity
                dsp_group_polarity(variant, i_channel, i_group, ipc_constants.DEFAULT_POLARITY_VALUE)
                # sending filter PEQ values
                a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(ipc_constants.DEFAULT_FILTER["a0"],
                                                                 ipc_constants.DEFAULT_FILTER["a1"],
                                                                 ipc_constants.DEFAULT_FILTER["a2"],
                                                                 ipc_constants.DEFAULT_FILTER["b0"],
                                                                 ipc_constants.DEFAULT_FILTER["b1"],
                                                                 ipc_constants.DEFAULT_FILTER["b2"])
                for i in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
                    dsp_set_group_peq_filter_coeff(variant, i_channel, i_group, i, [b2, b1, b0, a2, a1])
            else:
                # mute is send at the end
                # delay values, already sent
                # sending default gain value
                dsp_group_gain_set(variant, i_channel, i_group, group_settings[i_group]["gain"])
                # sending polarity
                dsp_group_polarity(variant, i_channel, i_group, group_settings[i_group]["polarity"])
                # sending filter PEQ values
                for i in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
                    if group_settings[i_group]["peq"][i]["enable"]:
                        a0, a1, a2, b0, b1, b2 = ipc_filters.compute_peq_coeff(group_settings[i_group]["peq"][i]["type"],
                                                                               group_settings[i_group]["peq"][i]["freq"],
                                                                               group_settings[i_group]["peq"][i]["gain"],
                                                                               group_settings[i_group]["peq"][i]["q"])
                        a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(a0, a1, a2, b0, b1, b2)
                    else:
                        a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(ipc_constants.DEFAULT_FILTER["a0"],
                                                                         ipc_constants.DEFAULT_FILTER["a1"],
                                                                         ipc_constants.DEFAULT_FILTER["a2"],
                                                                         ipc_constants.DEFAULT_FILTER["b0"],
                                                                         ipc_constants.DEFAULT_FILTER["b1"],
                                                                         ipc_constants.DEFAULT_FILTER["b2"])
                    dsp_set_group_peq_filter_coeff(variant, i_channel, i_group, i, [b2, b1, b0, a2, a1])
        ################################################################################################################
        # SPEAKER PART
        #  set speaker gain
        dsp_channel_gain_speaker_config(variant, i_channel, float(speaker_settings[i_channel]["gain"]))
        #  set speaker polarity
        dsp_speaker_polarity(variant, i_channel, bool(speaker_settings[i_channel]["polarity"]))
        #  set speaker delay
        if speaker_settings[i_channel]["delay_enable"]:
            dsp_channel_delay_speaker_config(variant, i_channel, speaker_settings[i_channel]["delay_value"])
        else:
            dsp_channel_delay_speaker_config(variant, i_channel, 0)
        #  set speaker IIR HPF (if enabled)
        if speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_type"],
                                                                  ipc_constants.XOVER_HP_TYPE,
                                                                  speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_speaker_xover_hp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker IIR LPF (if enabled)
        if speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_type"],
                                                                  ipc_constants.XOVER_LP_TYPE,
                                                                  speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_speaker_xover_lp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker FIR 768 tabs
        dsp_set_speaker_fir_table(variant, i_channel, speaker_settings[i_channel]["fir_table"])
        #  set speaker 12 x PEQ (if each of them is enabled)
        for i_peq in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
            array_coeff = ipc_util.recalculate_peq_values(speaker_settings, i_channel, i_peq)
            dsp_set_speaker_peq_filter_coeff(variant, i_channel, i_peq, array_coeff)
        #  set speaker RMS LIM threshold
        threshold_points = ipc_util.calculate_compressor_rms_coefficients(speaker_settings[i_channel]["lim_rms"]["lim_rms_thres"])
        dsp_set_speaker_lim_rms_thres(variant, i_channel, threshold_points)
        #  set speaker RMS LIM attack
        dsp_set_speaker_lim_rms_attack(variant, i_channel, speaker_settings[i_channel]["lim_rms"]["lim_rms_attack"])
        #  set speaker RMS LIM release
        dsp_set_speaker_lim_rms_release(variant, i_channel, speaker_settings[i_channel]["lim_rms"]["lim_rms_release"])
        #  set speaker PEAK LIM threshold
        threshold_points = ipc_util.calculate_compressor_peak_coefficients(speaker_settings[i_channel]["lim_peak"]["lim_peak_thres"])
        dsp_set_speaker_lim_peak_thres(variant, i_channel, threshold_points)
        #  set speaker PEAK LIM release
        dsp_set_speaker_lim_peak_release(variant, i_channel, speaker_settings[i_channel]["lim_peak"]["lim_peak_release"])
        ################################################################################################################

        # global amplifier parameter : HIGH Z FILTER (only apply it when it's true)
        if (global_settings["high_impedance_filter"][i_channel]):
            dsp_set_hiz_filter_coeff(variant,i_channel,global_settings["high_impedance_filter"][i_channel])


    bridge12 = bool(global_settings["bridge_mode_12"])
    bridge34 = bool(global_settings["bridge_mode_34"])
    bridge56 = bool(global_settings["bridge_mode_56"])
    bridge78 = bool(global_settings["bridge_mode_78"])
    bridge910 = bool(global_settings["bridge_mode_910"])
    bridge1112 = bool(global_settings["bridge_mode_1112"])
    bridge1314 = bool(global_settings["bridge_mode_1314"])
    bridge1516 = bool(global_settings["bridge_mode_1516"])

    if bridge12:
        dsp_set_bridge_mode(variant, 0, True)
    else:
        dsp_set_bridge_mode(variant, 0, False)

    if bridge34:
        dsp_set_bridge_mode(variant, 1, True)
    else:
        dsp_set_bridge_mode(variant, 1, False)

    if bridge56:
        dsp_set_bridge_mode(variant, 2, True)
    else:
        dsp_set_bridge_mode(variant, 2, False)

    if bridge78:
        dsp_set_bridge_mode(variant, 3, True)
    else:
        dsp_set_bridge_mode(variant, 3, False)

    if bridge910:
        dsp_set_bridge_mode(variant, 4, True)
    else:
        dsp_set_bridge_mode(variant, 4, False)

    if bridge1112:
        dsp_set_bridge_mode(variant, 5, True)
    else:
        dsp_set_bridge_mode(variant, 5, False)

    if bridge1314:
        dsp_set_bridge_mode(variant, 6, True)
    else:
        dsp_set_bridge_mode(variant, 6, False)

    if bridge1516:
        dsp_set_bridge_mode(variant, 7, True)
    else:
        dsp_set_bridge_mode(variant, 7, False)

    #  Lastly, unmute channels
    #  logical OR (current state or group mute state) only if group is assigned to channel
    if (variant == "variant7" or variant == "variant8"):
        final_mute_state = [bool(user_settings[0]["mute"]),
                            bool(user_settings[1]["mute"]),
                            bool(user_settings[2]["mute"]),
                            bool(user_settings[3]["mute"]),
                            bool(user_settings[4]["mute"]),
                            bool(user_settings[5]["mute"]),
                            bool(user_settings[6]["mute"]),
                            bool(user_settings[7]["mute"]),
                            bool(user_settings[8]["mute"]),
                            bool(user_settings[9]["mute"]),
                            bool(user_settings[10]["mute"]),
                            bool(user_settings[11]["mute"]),
                            bool(user_settings[12]["mute"]),
                            bool(user_settings[13]["mute"]),
                            bool(user_settings[14]["mute"]),
                            bool(user_settings[15]["mute"])]
    else :
            final_mute_state = [bool(user_settings[0]["mute"]),
                            bool(user_settings[1]["mute"]),
                            bool(user_settings[2]["mute"]),
                            bool(user_settings[3]["mute"])]
    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        for i_group in range(0, ipc_constants.NUM_OF_GROUPS):
            if 1 == user_settings[i_channel]["assigned_to_group"][i_group]:
                final_mute_state[i_channel] = final_mute_state[i_channel] or bool(group_settings[i_group]["mute"])

    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        dsp_solo_mute(variant, i_channel, final_mute_state[i_channel])


def dsp_global_audio_preset(variant, user_settings, group_settings, speaker_settings):

    # First, mute channels
    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        dsp_solo_mute(variant, i_channel, True)

    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        # Set source
        # if 0 == user_settings[i_channel]["active_source"]:  # primary source is active
        #     dsp_channel_source_config(variant, i_channel, user_settings[i_channel]["source_pri"], 1)
        # elif 1 == user_settings[i_channel]["active_source"]:  # secondary source is active
        #     dsp_channel_source_config(variant, i_channel, user_settings[i_channel]["source_sec"], 1)
        for j_source in range(0, ipc_constants.NUM_OF_INPUTS):
            dsp_channel_source_mixer(variant, i_channel, j_source, user_settings[i_channel]["mixer"][j_source]["gain"])
        ################################################################################################################
        # USER PART
        #  set speaker gain
        dsp_channel_gain_solo_config(variant, i_channel, float(user_settings[i_channel]["gain"]))
        #  set speaker polarity
        dsp_solo_polarity(variant, i_channel, bool(user_settings[i_channel]["polarity"]))
        #  set speaker delay
        sum_delay_value = int(user_settings[i_channel]["delay_enable"]) * user_settings[i_channel]["delay_value"] + user_settings[i_channel]["group_delay_value"]
        if sum_delay_value > ipc_constants.MAX_USER_AND_GROUP_DELAY_VALUE:
            dsp_channel_delay_config(variant, i_channel, ipc_constants.MAX_USER_AND_GROUP_DELAY_VALUE)
        else:
            dsp_channel_delay_config(variant, i_channel, sum_delay_value)
        # #  set speaker IIR HPF (if enabled)
        if user_settings[i_channel]["xover_hp_filter"]["xover_hp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(user_settings[i_channel]["xover_hp_filter"]["xover_hp_type"],
                                                                  ipc_constants.XOVER_HP_TYPE,
                                                                  user_settings[i_channel]["xover_hp_filter"]["xover_hp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_solo_xover_hp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker IIR LPF (if enabled)
        if user_settings[i_channel]["xover_lp_filter"]["xover_lp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(user_settings[i_channel]["xover_lp_filter"]["xover_lp_type"],
                                                                  ipc_constants.XOVER_LP_TYPE,
                                                                  user_settings[i_channel]["xover_lp_filter"]["xover_lp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_solo_xover_lp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker 12 x PEQ (if each of them is enabled)
        for peq_channel in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
            array_coeff = ipc_util.recalculate_peq_values(user_settings, i_channel, peq_channel)
            dsp_set_solo_peq_filter_coeff(variant, i_channel, peq_channel, array_coeff)
        #  set speaker RMS LIM threshold
        threshold_points = ipc_util.calculate_compressor_rms_coefficients(user_settings[i_channel]["lim_rms"]["lim_rms_thres"])
        dsp_set_solo_lim_rms_thres(variant, i_channel, threshold_points)
        #  set speaker RMS LIM attack
        dsp_set_solo_lim_rms_attack(variant, i_channel, user_settings[i_channel]["lim_rms"]["lim_rms_attack"])
        #  set speaker RMS LIM release
        dsp_set_solo_lim_rms_release(variant, i_channel, user_settings[i_channel]["lim_rms"]["lim_rms_release"])
        #  set speaker PEAK LIM threshold
        threshold_points = ipc_util.calculate_compressor_peak_coefficients(user_settings[i_channel]["lim_peak"]["lim_peak_thres"])
        dsp_set_solo_lim_peak_thres(variant, i_channel, threshold_points)
        #  set speaker PEAK LIM release
        dsp_set_solo_lim_peak_release(variant, i_channel, user_settings[i_channel]["lim_peak"]["lim_peak_release"])
        ################################################################################################################
        # GROUP PART
        for i_group in range(0, ipc_constants.NUM_OF_GROUPS):
            if 0 == int(user_settings[i_channel]["assigned_to_group"][i_group]):
                # mute is send at the end
                # delay values, already sent
                # sending default gain value
                dsp_group_gain_set(variant, i_channel, i_group, ipc_constants.DEFAULT_GAIN_VALUE)
                # sending polarity
                dsp_group_polarity(variant, i_channel, i_group, ipc_constants.DEFAULT_POLARITY_VALUE)
                # sending filter PEQ values
                a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(ipc_constants.DEFAULT_FILTER["a0"],
                                                                 ipc_constants.DEFAULT_FILTER["a1"],
                                                                 ipc_constants.DEFAULT_FILTER["a2"],
                                                                 ipc_constants.DEFAULT_FILTER["b0"],
                                                                 ipc_constants.DEFAULT_FILTER["b1"],
                                                                 ipc_constants.DEFAULT_FILTER["b2"])
                for i in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
                    dsp_set_group_peq_filter_coeff(variant, i_channel, i_group, i, [b2, b1, b0, a2, a1])
            else:
                # mute is send at the end
                # delay values, already sent
                # sending default gain value
                dsp_group_gain_set(variant, i_channel, i_group, group_settings[i_group]["gain"])
                # sending polarity
                dsp_group_polarity(variant, i_channel, i_group, group_settings[i_group]["polarity"])
                # sending filter PEQ values
                for i in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
                    if group_settings[i_group]["peq"][i]["enable"]:
                        a0, a1, a2, b0, b1, b2 = ipc_filters.compute_peq_coeff(group_settings[i_group]["peq"][i]["type"],
                                                                               group_settings[i_group]["peq"][i]["freq"],
                                                                               group_settings[i_group]["peq"][i]["gain"],
                                                                               group_settings[i_group]["peq"][i]["q"])
                        a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(a0, a1, a2, b0, b1, b2)
                    else:
                        a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(ipc_constants.DEFAULT_FILTER["a0"],
                                                                         ipc_constants.DEFAULT_FILTER["a1"],
                                                                         ipc_constants.DEFAULT_FILTER["a2"],
                                                                         ipc_constants.DEFAULT_FILTER["b0"],
                                                                         ipc_constants.DEFAULT_FILTER["b1"],
                                                                         ipc_constants.DEFAULT_FILTER["b2"])
                    dsp_set_group_peq_filter_coeff(variant, i_channel, i_group, i, [b2, b1, b0, a2, a1])
        ################################################################################################################
        # SPEAKER PART
        #  set speaker gain
        dsp_channel_gain_speaker_config(variant, i_channel, float(speaker_settings[i_channel]["gain"]))
        #  set speaker polarity
        dsp_speaker_polarity(variant, i_channel, bool(speaker_settings[i_channel]["polarity"]))
        #  set speaker delay
        if speaker_settings[i_channel]["delay_enable"]:
            dsp_channel_delay_speaker_config(variant, i_channel, speaker_settings[i_channel]["delay_value"])
        else:
            dsp_channel_delay_speaker_config(variant, i_channel, 0)
        #  set speaker IIR HPF (if enabled)
        if speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_type"],
                                                                  ipc_constants.XOVER_HP_TYPE,
                                                                  speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_speaker_xover_hp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker IIR LPF (if enabled)
        if speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_type"],
                                                                  ipc_constants.XOVER_LP_TYPE,
                                                                  speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_speaker_xover_lp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker FIR 768 tabs
        # NEEDS TO BE SOLVED
        dsp_set_speaker_fir_table(variant, i_channel, speaker_settings[i_channel]["fir_table"])
        #  set speaker 12 x PEQ (if each of them is enabled)
        for i_peq in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
            array_coeff = ipc_util.recalculate_peq_values(speaker_settings, i_channel, i_peq)
            dsp_set_speaker_peq_filter_coeff(variant, i_channel, i_peq, array_coeff)
        #  set speaker RMS LIM threshold
        threshold_points = ipc_util.calculate_compressor_rms_coefficients(speaker_settings[i_channel]["lim_rms"]["lim_rms_thres"])
        dsp_set_speaker_lim_rms_thres(variant, i_channel, threshold_points)
        #  set speaker RMS LIM attack
        dsp_set_speaker_lim_rms_attack(variant, i_channel, speaker_settings[i_channel]["lim_rms"]["lim_rms_attack"])
        #  set speaker RMS LIM release
        dsp_set_speaker_lim_rms_release(variant, i_channel, speaker_settings[i_channel]["lim_rms"]["lim_rms_release"])
        #  set speaker PEAK LIM threshold
        threshold_points = ipc_util.calculate_compressor_peak_coefficients(speaker_settings[i_channel]["lim_peak"]["lim_peak_thres"])
        dsp_set_speaker_lim_peak_thres(variant, i_channel, threshold_points)
        #  set speaker PEAK LIM release
        dsp_set_speaker_lim_peak_release(variant, i_channel, speaker_settings[i_channel]["lim_peak"]["lim_peak_release"])
        ################################################################################################################

    #  Lastly, unmute channels
    #  logical OR (current state or group mute state) only if group is assigned to channel
    #  Lastly, unmute channels
    #  logical OR (current state or group mute state) only if group is assigned to channel
    if (variant == "variant7" or variant == "variant8"):
        final_mute_state = [bool(user_settings[0]["mute"]),
                            bool(user_settings[1]["mute"]),
                            bool(user_settings[2]["mute"]),
                            bool(user_settings[3]["mute"]),
                            bool(user_settings[4]["mute"]),
                            bool(user_settings[5]["mute"]),
                            bool(user_settings[6]["mute"]),
                            bool(user_settings[7]["mute"]),
                            bool(user_settings[8]["mute"]),
                            bool(user_settings[9]["mute"]),
                            bool(user_settings[10]["mute"]),
                            bool(user_settings[11]["mute"]),
                            bool(user_settings[12]["mute"]),
                            bool(user_settings[13]["mute"]),
                            bool(user_settings[14]["mute"]),
                            bool(user_settings[15]["mute"])]
    else :
            final_mute_state = [bool(user_settings[0]["mute"]),
                            bool(user_settings[1]["mute"]),
                            bool(user_settings[2]["mute"]),
                            bool(user_settings[3]["mute"])]
            
    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        for i_group in range(0, ipc_constants.NUM_OF_GROUPS):
            if 1 == user_settings[i_channel]["assigned_to_group"][i_group]:
                final_mute_state[i_channel] = final_mute_state[i_channel] or bool(group_settings[i_group]["mute"])

    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        dsp_solo_mute(variant, i_channel, final_mute_state[i_channel])

def dsp_all_speaker_preset(variant, speaker_settings, final_mute_state):

    # First, mute channels
    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        dsp_solo_mute(variant, i_channel, True)

    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        #  set speaker gain
        dsp_channel_gain_speaker_config(variant, i_channel, float(speaker_settings[i_channel]["gain"]))
        #  set speaker polarity
        dsp_speaker_polarity(variant, i_channel, bool(speaker_settings[i_channel]["polarity"]))
        #  set speaker delay
        if speaker_settings[i_channel]["delay_enable"]:
            dsp_channel_delay_speaker_config(variant, i_channel, speaker_settings[i_channel]["delay_value"])
        else:
            dsp_channel_delay_speaker_config(variant, i_channel, 0)
        #  set speaker IIR HPF (if enabled)
        if speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_type"],
                                                                  ipc_constants.XOVER_HP_TYPE,
                                                                  speaker_settings[i_channel]["xover_hp_filter"]["xover_hp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_speaker_xover_hp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker IIR LPF (if enabled)
        if speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_enable"]:
            coefficients = ipc_filters.compute_xover_coefficients(speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_type"],
                                                                  ipc_constants.XOVER_LP_TYPE,
                                                                  speaker_settings[i_channel]["xover_lp_filter"]["xover_lp_freq"])
        else:
            coefficients = ipc_constants.DEFAULT_XOVER_FILTER
        dsp_set_speaker_xover_lp_coeff(variant, i_channel, ipc_util.scale_xover_coeff(coefficients))
        #  set speaker FIR 768 tabs
        dsp_set_speaker_fir_table(variant, i_channel, speaker_settings[i_channel]["fir_table"])

        for i_peq in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
            if speaker_settings[i_channel]["peq"][i_peq]["enable"]:  # if enabled, recalculate and send
                a0, a1, a2, b0, b1, b2 = ipc_filters.compute_peq_coeff(speaker_settings[i_channel]["peq"][i_peq]["type"],
                                                                    speaker_settings[i_channel]["peq"][i_peq]["freq"],
                                                                    speaker_settings[i_channel]["peq"][i_peq]["gain"],
                                                                    speaker_settings[i_channel]["peq"][i_peq]["q"])
                a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(a0, a1, a2, b0, b1, b2)
            else:
                a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(ipc_constants.DEFAULT_FILTER["a0"],
                                                                ipc_constants.DEFAULT_FILTER["a1"],
                                                                ipc_constants.DEFAULT_FILTER["a2"],
                                                                ipc_constants.DEFAULT_FILTER["b0"],
                                                                ipc_constants.DEFAULT_FILTER["b1"],
                                                                ipc_constants.DEFAULT_FILTER["b2"])
            dsp_set_speaker_peq_filter_coeff(variant, i_channel, i_peq, [b2, b1, b0, a2, a1])

        # #  set speaker 12 x PEQ (if each of them is enabled)
        # for i_peq in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
        #     array_coeff = ipc_util.recalculate_peq_values(speaker_settings, i_channel, i_peq)
        #     dsp_set_speaker_peq_filter_coeff(variant, i_channel, i_peq, array_coeff)
        #  set speaker RMS LIM threshold
        threshold_points = ipc_util.calculate_compressor_rms_coefficients(speaker_settings[i_channel]["lim_rms"]["lim_rms_thres"])
        dsp_set_speaker_lim_rms_thres(variant, i_channel, threshold_points)
        #  set speaker RMS LIM attack
        dsp_set_speaker_lim_rms_attack(variant, i_channel, speaker_settings[i_channel]["lim_rms"]["lim_rms_attack"])
        #  set speaker RMS LIM release
        dsp_set_speaker_lim_rms_release(variant, i_channel, speaker_settings[i_channel]["lim_rms"]["lim_rms_release"])
        #  set speaker PEAK LIM threshold
        threshold_points = ipc_util.calculate_compressor_peak_coefficients(speaker_settings[i_channel]["lim_peak"]["lim_peak_thres"])
        dsp_set_speaker_lim_peak_thres(variant, i_channel, threshold_points)
        #  set speaker PEAK LIM release
        dsp_set_speaker_lim_peak_release(variant, i_channel, speaker_settings[i_channel]["lim_peak"]["lim_peak_release"])

    # Then, mute channels
    for i_channel in range(0, ipc_constants.NUM_OF_CHANNELS):
        dsp_solo_mute(variant, i_channel, final_mute_state)


def dsp_speaker_preset(variant, channel, settings, final_mute_state):
    # First, mute channel
    dsp_solo_mute(variant, channel, True)
    #  set speaker gain
    dsp_channel_gain_speaker_config(variant, channel, float(settings["gain"]))
    #  set speaker polarity
    dsp_speaker_polarity(variant, channel, bool(settings["polarity"]))
    #  set speaker delay
    if settings["delay_enable"]:
        dsp_channel_delay_speaker_config(variant, channel, settings["delay_value"])
    else:
        dsp_channel_delay_speaker_config(variant, channel, 0)
    #  set speaker IIR HPF (if enabled)
    if settings["xover_hp_filter"]["xover_hp_enable"]:
        coefficients = ipc_filters.compute_xover_coefficients(settings["xover_hp_filter"]["xover_hp_type"],
                                                              ipc_constants.XOVER_HP_TYPE,
                                                              settings["xover_hp_filter"]["xover_hp_freq"])
    else:
        coefficients = ipc_constants.DEFAULT_XOVER_FILTER
    dsp_set_speaker_xover_hp_coeff(variant, channel, ipc_util.scale_xover_coeff(coefficients))
    #  set speaker IIR LPF (if enabled)
    if settings["xover_lp_filter"]["xover_lp_enable"]:
        coefficients = ipc_filters.compute_xover_coefficients(settings["xover_lp_filter"]["xover_lp_type"],
                                                              ipc_constants.XOVER_LP_TYPE,
                                                              settings["xover_lp_filter"]["xover_lp_freq"])
    else:
        coefficients = ipc_constants.DEFAULT_XOVER_FILTER
    dsp_set_speaker_xover_lp_coeff(variant, channel, ipc_util.scale_xover_coeff(coefficients))
    #  set speaker FIR 768 tabs #
    dsp_set_speaker_fir_table(variant, channel, settings["fir_table"])
    #  set speaker 12 x PEQ (if each of them is enabled)
    for i_peq in range(0, ipc_constants.NUM_OF_PEQ_FILTERS):
        if settings["peq"][i_peq]["enable"]:  # if enabled, recalculate and send
            a0, a1, a2, b0, b1, b2 = ipc_filters.compute_peq_coeff(settings["peq"][i_peq]["type"],
                                                                   settings["peq"][i_peq]["freq"],
                                                                   settings["peq"][i_peq]["gain"],
                                                                   settings["peq"][i_peq]["q"])
            a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(a0, a1, a2, b0, b1, b2)
        else:
            a1, a2, b0, b1, b2 = ipc_util.rescale_peq_values(ipc_constants.DEFAULT_FILTER["a0"],
                                                             ipc_constants.DEFAULT_FILTER["a1"],
                                                             ipc_constants.DEFAULT_FILTER["a2"],
                                                             ipc_constants.DEFAULT_FILTER["b0"],
                                                             ipc_constants.DEFAULT_FILTER["b1"],
                                                             ipc_constants.DEFAULT_FILTER["b2"])
        dsp_set_speaker_peq_filter_coeff(variant, channel, i_peq, [b2, b1, b0, a2, a1])
    #  set speaker RMS LIM threshold
    threshold_points = ipc_util.calculate_compressor_rms_coefficients(settings["lim_rms"]["lim_rms_thres"])
    dsp_set_speaker_lim_rms_thres(variant, channel, threshold_points)
    #  set speaker RMS LIM attack
    dsp_set_speaker_lim_rms_attack(variant, channel, settings["lim_rms"]["lim_rms_attack"])
    #  set speaker RMS LIM release
    dsp_set_speaker_lim_rms_release(variant, channel, settings["lim_rms"]["lim_rms_release"])
    #  set speaker PEAK LIM threshold
    threshold_points = ipc_util.calculate_compressor_peak_coefficients(settings["lim_peak"]["lim_peak_thres"])
    dsp_set_speaker_lim_peak_thres(variant, channel, threshold_points)
    #  set speaker PEAK LIM release
    dsp_set_speaker_lim_peak_release(variant, channel, settings["lim_peak"]["lim_peak_release"])

    #  Lastly, unmute channel
    dsp_solo_mute(variant, channel, final_mute_state)


def dsp_set_group_peq_filter_coeff(variant, channel, group_num, peq_channel, coef):

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 4 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 5 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 6 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 7 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 8 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 9 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 10 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 11 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 12 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 13 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 14 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 15 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant6":
        if 0 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 4 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 5 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant4":
        if 0 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 4 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 5 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant3":
        if 0 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 4 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 5 == group_num:
            if channel == 0:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 1:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 2:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
            elif channel == 3:
                send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            if 0 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_0_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 1 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_1_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 2 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_2_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 3 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_3_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 4 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_4_PEQ_START_ADDRESSES[peq_channel], coef)
            elif 5 == group_num:
                send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_GROUP_5_PEQ_START_ADDRESSES[peq_channel], coef)


def dsp_set_solo_peq_filter_coeff(variant, channel, peq_channel, coef):
    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_USER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant9":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_USER_PEQ_START_ADDRESSES[peq_channel], coef)
    else:  # variant 1 and 2 and 5
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_USER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_USER_PEQ_START_ADDRESSES[peq_channel], coef)


def dsp_set_speaker_peq_filter_coeff(variant, channel, peq_channel, coef):

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_1_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_3_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_1_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_3_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_1_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_3_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_0_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_1_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_2_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.CHANNEL_3_SPEAKER_PEQ_START_ADDRESSES[peq_channel], coef)


def dsp_set_solo_xover_hp_coeff(variant, channel, coef):
    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant9":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    else:  # variant 1 and 2 and 5
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])


def dsp_set_speaker_xover_hp_coeff(variant, channel, coef):

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_HPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_HPF_ALG0_STAGE3_B2_ADDR, coef[3])


def dsp_set_solo_xover_lp_coeff(variant, channel, coef):

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant9":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    else:  # variant 1 and 2 and 5
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])


def dsp_set_speaker_xover_lp_coeff(variant, channel, coef):

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LPF_ALG0_STAGE3_B2_ADDR, coef[3])
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE0_B2_ADDR, coef[0])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE1_B2_ADDR, coef[1])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE2_B2_ADDR, coef[2])
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LPF_ALG0_STAGE3_B2_ADDR, coef[3])


def dsp_set_solo_lim_rms_thres(variant, channel, threshold_points):
    # Point coefficients[0..105] are packed into 22 safeload packets:
    # {0, 1, 2, 3, 4} {5, 6, 7, 8, 9}...{100, 101, 102, 103, 104} {105, -, -, -, -}
    i = 0
    coeff = [0, 0, 0, 0, 0]  # Array init

    while i < ipc_constants.NUM_OF_LIM_RMS_THRESHOLD_POINTS:
        coeff[0] = threshold_points[i]
        if i < 105:
            coeff[1] = threshold_points[i + 1]
            coeff[2] = threshold_points[i + 2]
            coeff[3] = threshold_points[i + 3]
            coeff[4] = threshold_points[i + 4]
        else:
            coeff[1] = 0
            coeff[2] = 0
            coeff[3] = 0
            coeff[4] = 0

        if (variant == "variant7" or variant == "variant8"):
            if i < 105:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        1)
        elif variant == "variant6":
            if 0 == channel:
                if i < 105:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            5)
                else:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            1)
        elif variant == "variant4":
            if i < 105:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)
        elif variant == "variant3":
            if i < 105:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)
        elif variant == "variant9":
            if i < 105:
                if 0 == channel:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[0][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[0][0] + i,
                                            coeff,
                                            5)
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[1][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[1][0] + i,
                                            coeff,
                                            5)
                else:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            5)
            else:
                if 0 == channel:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[0][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[0][0] + i,
                                            coeff,
                                            1)
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[1][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[1][0] + i,
                                            coeff,
                                            1)
                else:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            1)
        else:  # variant 1 and 2 and 5
            if i < 105:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)

        i = i + 5


def dsp_set_speaker_lim_rms_thres(variant, channel, threshold_points):
    # Point coefficients[0..105] are packed into 22 safeload packets:
    # {0, 1, 2, 3, 4} {5, 6, 7, 8, 9}...{100, 101, 102, 103, 104} {105, -, -, -, -}
    i = 0
    coeff = [0, 0, 0, 0, 0]  # Array init

    while i < ipc_constants.NUM_OF_LIM_RMS_THRESHOLD_POINTS:
        coeff[0] = threshold_points[i]
        if i < 105:
            coeff[1] = threshold_points[i + 1]
            coeff[2] = threshold_points[i + 2]
            coeff[3] = threshold_points[i + 3]
            coeff[4] = threshold_points[i + 4]
        else:
            coeff[1] = 0
            coeff[2] = 0
            coeff[3] = 0
            coeff[4] = 0

        if (variant == "variant7" or variant == "variant8"):
            if i < 105:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        1)
        elif variant == "variant6":
            if 0 == channel:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)
        elif variant == "variant4":
            if i < 105:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)
        elif variant == "variant3":
            if i < 105:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)
        else:  # variant 1 and 2 and 5 and 9
            if i < 105:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_RMS_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        1)

        i = i + 5


def dsp_set_solo_lim_rms_attack(variant, channel, attack):
    attack_for_dsp = 1.0 / float(attack) * 0.042143809

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4TC_ADDR,
                                    attack_for_dsp)
        elif 4 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 5 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2TC_ADDR,
                                    attack_for_dsp)
        elif 6 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 7 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4TC_ADDR,
                                    attack_for_dsp)
        elif 8 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 9 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2TC_ADDR,
                                    attack_for_dsp)
        elif 10 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 11 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4TC_ADDR,
                                    attack_for_dsp)
        elif 12 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 13 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2TC_ADDR,
                                    attack_for_dsp)
        elif 14 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 15 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant6":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant4":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant3":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant9":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4TC_ADDR,
                                    attack_for_dsp)
    else:  # variant 1 and 2 and 5
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4TC_ADDR,
                                    attack_for_dsp)


def dsp_set_speaker_lim_rms_attack(variant, channel, attack):
    attack_for_dsp = 1.0 / float(attack) * 0.042143809

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8TC_ADDR,
                                    attack_for_dsp)
        elif 4 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 5 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6TC_ADDR,
                                    attack_for_dsp)
        elif 6 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
        elif 7 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8TC_ADDR,
                                    attack_for_dsp)
        elif 8 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 9 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6TC_ADDR,
                                    attack_for_dsp)
        elif 10 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
        elif 11 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8TC_ADDR,
                                    attack_for_dsp)
        elif 12 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 13 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6TC_ADDR,
                                    attack_for_dsp)
        elif 14 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
        elif 15 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant6":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant4":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
    elif variant == "variant3":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5TC_ADDR,
                                    attack_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6TC_ADDR,
                                    attack_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7TC_ADDR,
                                    attack_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8TC_ADDR,
                                    attack_for_dsp)


def dsp_set_solo_lim_rms_release(variant, channel, release):
    release_for_dsp = 1.0 / float(round(release)) * 0.001885851

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4DECAY_ADDR,
                                    release_for_dsp)
        elif 4 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 5 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2DECAY_ADDR,
                                    release_for_dsp)
        elif 6 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 7 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4DECAY_ADDR,
                                    release_for_dsp)
        elif 8 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 9 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2DECAY_ADDR,
                                    release_for_dsp)
        elif 10 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 11 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4DECAY_ADDR,
                                    release_for_dsp)
        elif 12 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 13 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2DECAY_ADDR,
                                    release_for_dsp)
        elif 14 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 15 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant6":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant4":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant3":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant9":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4DECAY_ADDR,
                                    release_for_dsp)
    else:  # variant 1 and 2
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG2DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG3DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG4DECAY_ADDR,
                                    release_for_dsp)


def dsp_set_speaker_lim_rms_release(variant, channel, release):
    release_for_dsp = 1.0 / float(round(release)) * 0.001885851

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8DECAY_ADDR,
                                    release_for_dsp)
        elif 4 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 5 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6DECAY_ADDR,
                                    release_for_dsp)
        elif 6 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
        elif 7 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8DECAY_ADDR,
                                    release_for_dsp)
        elif 8 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 9 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6DECAY_ADDR,
                                    release_for_dsp)
        elif 10 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
        elif 11 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8DECAY_ADDR,
                                    release_for_dsp)
        elif 12 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 13 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6DECAY_ADDR,
                                    release_for_dsp)
        elif 14 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
        elif 15 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant6":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant4":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant3":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG6DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG7DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_RMS_ALG0_STDRMSCOMPRESSOREXTDETS300ALG8DECAY_ADDR,
                                    release_for_dsp)


def dsp_set_bridge_mode(variant, num, enabled):
    if enabled:
        data = 11
    else:
        data = 0
    
    if (variant == "variant7" or variant == "variant8"):
        if 0 == num:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_12_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG1TABLEINDEX_ADDR, data)
        elif 1 == num:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_34_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG2TABLEINDEX_ADDR, data)
        elif 2 == num:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_12_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG1TABLEINDEX_ADDR, data)
        elif 3 == num:
            send_int_data_command(DSP_2_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_34_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG2TABLEINDEX_ADDR, data)
        elif 4 == num:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_12_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG1TABLEINDEX_ADDR, data)
        elif 5 == num:
            send_int_data_command(DSP_3_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_34_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG2TABLEINDEX_ADDR, data)
        elif 6 == num:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_12_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG1TABLEINDEX_ADDR, data)
        elif 7 == num:
            send_int_data_command(DSP_4_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_34_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG2TABLEINDEX_ADDR, data)

    elif variant == "variant1" or variant == "variant2" or variant == "variant5" :  # variant 1 and 2 and 5 and 6
        if 0 == num:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_12_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG1TABLEINDEX_ADDR, data)
        elif 1 == num:
            send_int_data_command(DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_BRIDGE_SETTINGS_BRIDGE_34_ALG0_AUDIOSIGNALROUTERINDXSEL32S300ALG2TABLEINDEX_ADDR,  data)


def dsp_set_solo_lim_peak_thres(variant, channel, threshold_points):
    # Point coefficients[0..105] are packed into 22 safeload packets:
    # {0, 1, 2, 3, 4} {5, 6, 7, 8, 9}...{100, 101, 102, 103, 104} {105, -, -, -, -}
    i = 0
    coeff = [0, 0, 0, 0, 0]  # Array init

    while i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS:
        coeff[0] = threshold_points[i]
        coeff[1] = threshold_points[i + 1]
        coeff[2] = threshold_points[i + 2]
        coeff[3] = threshold_points[i + 3]
        if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
            coeff[4] = threshold_points[i + 4]
        else:
            coeff[4] = 0

        if (variant == "variant7" or variant == "variant8"):
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        4)
        elif variant == "variant6":
            if 0 == channel:
                if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            5)
                else:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            4)
        elif variant == "variant4":
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        4)
        elif variant == "variant3":
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        4)
        elif variant == "variant9":
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                if 0 == channel:
                        send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                                ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[0][1],
                                                ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[0][0] + i,
                                                coeff,
                                                5)
                        send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                                ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[1][1],
                                                ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[1][0] + i,
                                                coeff,
                                                5)
                else:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            5)
            else:
                if 0 == channel:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[0][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[0][0] + i,
                                            coeff,
                                            4)
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[1][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[1][0] + i,
                                            coeff,
                                            4)
                else:
                    send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            4)
        else:  # variant 1 and 2 and 5
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SOLO_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        4)

        i = i + 5


def dsp_set_speaker_lim_peak_thres(variant, channel, threshold_points):
    # Point coefficients[0..105] are packed into 22 safeload packets:
    # {0, 1, 2, 3, 4} {5, 6, 7, 8, 9}...{100, 101, 102, 103, 104} {105, -, -, -, -}
    i = 0
    coeff = [0, 0, 0, 0, 0]  # Array init

    while i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS:
        coeff[0] = threshold_points[i]
        coeff[1] = threshold_points[i + 1]
        coeff[2] = threshold_points[i + 2]
        coeff[3] = threshold_points[i + 3]
        if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
            coeff[4] = threshold_points[i + 4]
        else:
            coeff[4] = 0

        if (variant == "variant7" or variant == "variant8"):
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel%4][0] + i,
                                        coeff,
                                        4)
        elif variant == "variant6":
            if 0 == channel:
                if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            5)
                else:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            4)
        elif variant == "variant4":
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        4)
        elif variant == "variant3":
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        4)
        else:  # variant 1 and 2 and 5 and 9
            if i < ipc_constants.NUM_OF_LIM_PEAK_THRESHOLD_POINTS-4:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SPEAKER_THRESHOLD_LIM_PEAK_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        4)

        i = i + 5


def dsp_set_solo_lim_peak_release(variant, channel, release):
    release_for_dsp = 1.0 / float(round(release)) * 0.001885851

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4DECAY_ADDR,
                                    release_for_dsp)
        elif 4 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 5 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2DECAY_ADDR,
                                    release_for_dsp)
        elif 6 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 7 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4DECAY_ADDR,
                                    release_for_dsp)
        elif 8 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 9 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2DECAY_ADDR,
                                    release_for_dsp)
        elif 10 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 11 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4DECAY_ADDR,
                                    release_for_dsp)
        elif 12 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 13 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2DECAY_ADDR,
                                    release_for_dsp)
        elif 14 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 15 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant6":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant4":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant3":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant9":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4DECAY_ADDR,
                                    release_for_dsp)
    else:  # variant 1 and 2 and 5
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X1DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X2DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X3DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_USER_SETTINGS_USER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X4DECAY_ADDR,
                                    release_for_dsp)


def dsp_set_speaker_lim_peak_release(variant, channel, release):
    release_for_dsp = 1.0 / float(round(release)) * 0.001885851

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X6DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X8DECAY_ADDR,
                                    release_for_dsp)
        elif 4 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 5 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X6DECAY_ADDR,
                                    release_for_dsp)
        elif 6 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
        elif 7 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X8DECAY_ADDR,
                                    release_for_dsp)
        elif 8 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 9 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X6DECAY_ADDR,
                                    release_for_dsp)
        elif 10 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
        elif 11 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X8DECAY_ADDR,
                                    release_for_dsp)
        elif 12 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 13 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X6DECAY_ADDR,
                                    release_for_dsp)
        elif 14 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
        elif 15 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X8DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant6":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant4":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_3_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_4_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
    elif variant == "variant3":
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_2_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
    else:  # variant 1 and 2 and 9
        if 0 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_1_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X5DECAY_ADDR,
                                    release_for_dsp)
        elif 1 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_2_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X6DECAY_ADDR,
                                    release_for_dsp)
        elif 2 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_3_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X7DECAY_ADDR,
                                    release_for_dsp)
        elif 3 == channel:
            send_float_data_command(DSP_1_I2C_ADDRESS,
                                    ipc_dsp_addresses.MOD_SPEAKER_SETTINGS_SPEAKER_4_LIM_PEAK_ALG0_STDPEAKCOMPRESSORWITHEXTDETECTALGADAU145X8DECAY_ADDR,
                                    release_for_dsp)


def dsp_set_speaker_fir_table(variant, channel, fir_table):
    i = 0
    coeff = [0, 0, 0, 0, 0]  # Array init

    while i < ipc_constants.NUM_OF_FIR_COEFFICIENT:
        coeff[0] = fir_table[i]
        coeff[1] = fir_table[i + 1]
        coeff[2] = fir_table[i + 2]
        if i < ipc_constants.NUM_OF_FIR_COEFFICIENT-3:
            coeff[3] = fir_table[i + 3]
            coeff[4] = fir_table[i + 4]
        else:
            coeff[3] = 0
            coeff[4] = 0

        if (variant == "variant7" or variant == "variant8"):
            if i < ipc_constants.NUM_OF_FIR_COEFFICIENT-3:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[(channel//4)],
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[(channel%4)][1],
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[(channel%4)][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_7_DSP_ADDRESSES[channel//4],
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[(channel%4)][1],
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[(channel%4)][0] + i,
                                        coeff,
                                        3)
        elif variant == "variant6":
            if 0 == channel:
                if i < ipc_constants.NUM_OF_FIR_COEFFICIENT-3:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            5)
                else:
                    send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                            ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                            ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                            coeff,
                                            3)
        elif variant == "variant4":
            if i < ipc_constants.NUM_OF_FIR_COEFFICIENT-3:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_4_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_4_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        3)
        elif variant == "variant3":
            if i < ipc_constants.NUM_OF_FIR_COEFFICIENT-3:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(VARIANT_3_DSP_ADDRESSES[channel],
                                        ipc_constants.VARIANT_3_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_3_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        3)
        else:  # variant 1 and 2 and 5 and 9
            if i < ipc_constants.NUM_OF_FIR_COEFFICIENT-3:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        5)
            else:
                send_data_chunk_command(DSP_1_I2C_ADDRESS,
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][1],
                                        ipc_constants.VARIANT_12_SPEAKER_FIR_TABLE_START_ADDRESSES[channel][0] + i,
                                        coeff,
                                        3)
        i = i + 5


def dsp_set_hiz (variant, channel, filter):
        dsp_solo_mute(variant, channel, True)
        time.sleep(2)
        dsp_set_hiz_filter_coeff(variant, channel, filter)
        time.sleep(2)
        dsp_solo_mute(variant, channel, False)


def dsp_set_hiz_filter_coeff(variant, channel, hiz):
    coef = ipc_constants.DEFAULT_HIZ_DISABLE
    if hiz:
        coef = ipc_constants.DEFAULT_HIZ_ENABLE

    if (variant == "variant7" or variant == "variant8"):
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 4 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 5 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 6 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 7 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 8 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 9 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 10 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 11 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 12 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 13 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 14 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
        elif 15 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel%4], coef)
    elif variant == "variant6":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
    elif variant == "variant4":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_4_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_4_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_3_I2C_ADDRESS, ipc_constants.VARIANT_4_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_4_I2C_ADDRESS, ipc_constants.VARIANT_4_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
    elif variant == "variant3":
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_3_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_3_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_3_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_2_I2C_ADDRESS, ipc_constants.VARIANT_3_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
    else:  # variant 1 and 2 and 5 and 9
        if 0 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 1 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 2 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)
        elif 3 == channel:
            send_filter_params_command(DSP_1_I2C_ADDRESS, ipc_constants.VARIANT_12_HIZ_DCBLOCK_START_ADDRESSES[channel], coef)


def send_float_data_command(dsp_address, target_address, data):
    coeff = [0, 0, 0, 0, 0, 0, 0, 0]  # 8 zeros
    dataBuffer = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]  # 32 zeros (4x8)
    j = 0

    data = convert_to_8_24(data)
    safeLoadRegister = [0x60, 0x00]

    coeff[0] = data
    coeff[1] = 0
    coeff[2] = 0
    coeff[3] = 0
    coeff[4] = 0
    coeff[5] = target_address[0]
    if 0 == int(target_address[1]):
        coeff[6] = 1
        coeff[7] = 0
    else:
        coeff[6] = 0
        coeff[7] = 1

    for i in range(0, 8):
        dataBuffer[j] = int((coeff[i] >> 24) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 16) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 8) & 0xFF)
        j = j + 1
        dataBuffer[j] = int(coeff[i] & 0xFF)
        j = j + 1

    dataBuffer = safeLoadRegister + dataBuffer

    try:
        with SMBus(0) as bus:
            write_message = i2c_msg.write(dsp_address, dataBuffer)
            bus.i2c_rdwr(write_message)
    except:
        print("Send float data command is not performed!")


def send_int_data_command(dsp_address, target_address, data):
    coeff = [0, 0, 0, 0, 0, 0, 0, 0]  # 8 zeros
    dataBuffer = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]  # 32 zeros (4x8)
    j = 0

    safeLoadRegister = [0x60, 0x00]

    coeff[0] = int(data)
    coeff[1] = 0
    coeff[2] = 0
    coeff[3] = 0
    coeff[4] = 0
    coeff[5] = target_address[0]
    if 0 == int(target_address[1]):
        coeff[6] = 1
        coeff[7] = 0
    else:
        coeff[6] = 0
        coeff[7] = 1

    for i in range(0, 8):
        dataBuffer[j] = int((coeff[i] >> 24) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 16) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 8) & 0xFF)
        j = j + 1
        dataBuffer[j] = int(coeff[i] & 0xFF)
        j = j + 1

    dataBuffer = safeLoadRegister + dataBuffer

    try:
        with SMBus(0) as bus:
            write_message = i2c_msg.write(dsp_address, dataBuffer)
            bus.i2c_rdwr(write_message)
    except:
        print("Send int data command is not performed!")


def send_filter_params_command(dsp_address, target_address, filter_coef):
    coeff = [0, 0, 0, 0, 0, 0, 0, 0]  # 8 zeros
    dataBuffer = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]  # 32 zeros (4x8)
    j = 0

    safeLoadRegister = [0x60, 0x00]

    coeff[0] = convert_to_8_24(filter_coef[0])
    coeff[1] = convert_to_8_24(filter_coef[1])
    coeff[2] = convert_to_8_24(filter_coef[2])
    coeff[3] = convert_to_8_24(filter_coef[3])
    coeff[4] = convert_to_8_24(filter_coef[4])
    coeff[5] = target_address[0]
    if 0 == int(target_address[1]):
        coeff[6] = 5
        coeff[7] = 0
    else:
        coeff[6] = 0
        coeff[7] = 5

    for i in range(0, 7):
        dataBuffer[j] = int((coeff[i] >> 24) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 16) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 8) & 0xFF)
        j = j + 1
        dataBuffer[j] = int(coeff[i] & 0xFF)
        j = j + 1

    dataBuffer = safeLoadRegister + dataBuffer

    try:
        with SMBus(0) as bus:
            write_message = i2c_msg.write(dsp_address, dataBuffer)
            bus.i2c_rdwr(write_message)
    except:
        print("Send filter params command is not performed!")


def send_data_chunk_command(dsp_address, page, target_address, points, num_of_points):  # this function sends 5 points instead of 1
    coeff = [0, 0, 0, 0, 0, 0, 0, 0]  # 8 zeros
    dataBuffer = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]  # 32 zeros (4x8)
    j = 0

    safeLoadRegister = [0x60, 0x00]

    coeff[0] = convert_to_8_24(points[0])
    coeff[1] = convert_to_8_24(points[1])
    coeff[2] = convert_to_8_24(points[2])
    coeff[3] = convert_to_8_24(points[3])
    coeff[4] = convert_to_8_24(points[4])
    coeff[5] = target_address
    if 0 == int(page):
        coeff[6] = num_of_points
        coeff[7] = 0
    else:
        coeff[6] = 0
        coeff[7] = num_of_points

    for i in range(0, 8):
        dataBuffer[j] = int((coeff[i] >> 24) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 16) & 0xFF)
        j = j + 1
        dataBuffer[j] = int((coeff[i] >> 8) & 0xFF)
        j = j + 1
        dataBuffer[j] = int(coeff[i] & 0xFF)
        j = j + 1

    dataBuffer = safeLoadRegister + dataBuffer

    try:
        with SMBus(0) as bus:
            write_message = i2c_msg.write(dsp_address, dataBuffer)
            bus.i2c_rdwr(write_message)
    except:
        print("Send data chunk command is not performed!")


# def status_readback(variant):
#     print("Status readback started.")
#     status = {"byte_status" : [], "temperature" : [], "rtorvoltage" : [], "mainvoltage" : []}
#     ret = list()
#     print(variant)
#     try:
#         with SMBus(0) as bus:
#             if variant == "variant7":
#                 pass
#             elif variant == "variant4":
#                 pass
#             elif variant == "variant3":
#                 pass
#             else:  # variant 1 and 2
#                 print("start variant2 test")
#                 mempage_message = i2c_msg.write(ipc_constants.DSP_1_I2C_ADDRESS, [0xF8, 0x99, 0x00, 0x00])  # Reset register page to 0
#                 #rail to rail voltage
#                 write_message1 = i2c_msg.write(ipc_constants.DSP_1_I2C_ADDRESS, ipc_dsp_addresses.MOD_AMPLIFIER_ENABLE_CONTROL_I2CSMPSSTATUS_ALG0_DATA_BYTES_ADDR[0])
#                 read_message1 = i2c_msg.read(ipc_constants.DSP_1_I2C_ADDRESS, 4)
#                 #main voltage
#                 write_message2 = i2c_msg.write(ipc_constants.DSP_1_I2C_ADDRESS, transform_register_address(ipc_dsp_addresses.MOD_AMPLIFIER_ENABLE_CONTROL_MAINS_READBACKALGNEWSIGMA30015VALUE_ADDR[0]))
#                 read_message2 = i2c_msg.read(ipc_constants.DSP_1_I2C_ADDRESS, 4)
#                 #byte status from power supply : dc error ...
#                 write_message3 = i2c_msg.write(ipc_constants.DSP_1_I2C_ADDRESS, transform_register_address(ipc_dsp_addresses.MOD_AMPLIFIER_ENABLE_CONTROL_READBACK1_2_READBACKALGNEWSIGMA30012VALUE_ADDR[0]))
#                 read_message3 = i2c_msg.read(ipc_constants.DSP_1_I2C_ADDRESS, 4)
#                 #temperature amplifier stage
#                 write_message4 = i2c_msg.write(ipc_constants.DSP_1_I2C_ADDRESS, transform_register_address(ipc_dsp_addresses.MOD_AMPLIFIER_ENABLE_CONTROL_TEMPRAW_READBACKALGNEWSIGMA3008VALUE_ADDR[0]))
#                 read_message4 = i2c_msg.read(ipc_constants.DSP_1_I2C_ADDRESS, 4)

#                 bus.i2c_rdwr(mempage_message, write_message1, read_message1)
#                 # bus.i2c_rdwr(mempage_message, write_message2, read_message2)
#                 # bus.i2c_rdwr(mempage_message, write_message3, read_message3)
#                 # bus.i2c_rdwr(mempage_message, write_message4, read_message4)

#                 readback_raw = list(read_message1)
#                 # readback_raw = list(read_message1) + list(read_message2) + list(read_message3) + list(read_message4)

#                 # if(readback_raw[0]<80):
#                 #     readback_raw[0] = readback_raw[0] + 127

#                 status["rtorvoltage"].append(readback_raw[0])
#                 status["mainvoltage"].append(readback_raw[1])
#                 status["byte_status"].append(readback_raw[2])
#                 status["temperature"].append(readback_raw[3])

#     except OSError as e:
#         print(e)

#     return status