# from intelhex import IntelHex
# pip install intelhex (only needed for power supply programming, have to read Hex file)
from smbus2 import SMBus, i2c_msg 
import time
import functools
import sys
import getopt
#sys.path.append("/home/orangepi/IpcSystemService/")
# from ipc_dsp_addresses import SW_VERSION

from ipc_common import DSP_VARIANT_FILE
file = open(DSP_VARIANT_FILE, "r")
about_string = str(file.read()).split(" ")
current_variant_value = about_string[0]
file.close()

if (current_variant_value == "variant1.code"):
	from ipc_dsp_addresses_variant1 import SW_VERSION
elif (current_variant_value == "variant2.code"):
	from ipc_dsp_addresses_variant2 import SW_VERSION
elif (current_variant_value == "variant3.code"):
	from ipc_dsp_addresses_variant3 import SW_VERSION
elif (current_variant_value == "variant4.code"):
	from ipc_dsp_addresses_variant4 import SW_VERSION
elif (current_variant_value == "variant5.code"):
	from ipc_dsp_addresses_variant5 import SW_VERSION
elif (current_variant_value == "variant6.code"):
	from ipc_dsp_addresses_variant6 import SW_VERSION
elif (current_variant_value == "variant7.code"):
	from ipc_dsp_addresses_variant7 import SW_VERSION
elif (current_variant_value == "variant8.code"):
	from ipc_dsp_addresses_variant2 import SW_VERSION
elif (current_variant_value == "variant9.code"):
	from ipc_dsp_addresses_variant5 import SW_VERSION
else:
	from ipc_dsp_addresses_variant1 import SW_VERSION

print = functools.partial(print, flush=True)		# For realtime console output

DSP_I2C_ADDRESS = 0x3b
DSP_I2C_ADDRESS_1 = 0x3b 
DSP_I2C_ADDRESS_2 = 0x3a
DSP_I2C_ADDRESS_3 = 0x39
DSP_I2C_ADDRESS_4 = 0x38
DSP_DELAY = 0.3 					# We should expect 3 selfboot eeprom reads which can fail and wait for them to finish otherwise DSP will not accept commands
PSU_PRIM_BLOCKSIZE = 192 				# Only send 3 bytes, so not send 4th byte 
PSU_SEC_BLOCKSIZE = 64 					# Send secondary PIC by 64 byte blocks
EEPROM_BLOCKSIZE = 128


def send_data_command(register_address, data, dsp_address):
	Data_Pointer = 0
	Length = len(data)  # Keep in mind, Total packet length = data + 2 address bytes
	if Length > 1024:
		while Data_Pointer <= Length:
			Reg_H = (register_address >> 8) & 0xFF
			Reg_L = register_address & 0xFF
			Payload = [Reg_H, Reg_L, *data[Data_Pointer:Data_Pointer + 1024]]
			with SMBus(0) as bus:
				write_message = i2c_msg.write(dsp_address, Payload)
				bus.i2c_rdwr(write_message)
			Data_Pointer += 1024
			register_address += 256  # Register addresses must increment per 4 bytes, so datapointer/4
	else:
		Reg_H = (register_address >> 8) & 0xFF
		Reg_L = register_address & 0xFF
		Payload = [Reg_H, Reg_L, *data]
		with SMBus(0) as bus:
			write_message = i2c_msg.write(dsp_address, Payload)
			bus.i2c_rdwr(write_message)


def dsp_masterport_eeprom_config(file_name, dsp_address):
	start = time.time()
	print("Configuring dsp masterport for EEPROM...", end='')
	parse_file_and_write(file_name, 0, dsp_address)
	finish = time.time()
	elapsed = finish - start
	print("Done in", int(elapsed * 1000), "mS")


def dsp_masterport_psu_config(dsp_address):
	start = time.time()
	print("Configuring dsp masterport for PSU...", end='')
	parse_file_and_write("/home/orangepi/IpcSystemService/psu_masterport.code", 0, dsp_address)
	finish = time.time()
	elapsed = finish - start
	print("Done in", int(elapsed * 1000), "mS")


def dsp_databridge(file_name, dsp_address):
	start = time.time()
	print("Set DSP in databridge mode...", end='')
	parse_file_and_write(file_name, 0, dsp_address)
	finish = time.time()
	elapsed = finish - start
	print("Done in", int(elapsed * 1000), "mS")


def dsp_loadcode(file_name, dsp_address):
	start = time.time()
	print("Loading program code in DSP...", end='')
	parse_file_and_write(file_name, 0, dsp_address)
	finish = time.time()
	elapsed = finish - start
	print("Done in", int(elapsed * 1000), "mS")


def write_eeprom_firmware(file_name, dsp_address):
	start = time.time()
	print("Writing firmware in EEPROM...", end='')
	parse_file_and_write(file_name, 0.01, dsp_address)
	finish = time.time()
	elapsed = finish - start
	print("Done in", int(elapsed * 1000), "mS")
	time.sleep(0.1)  # it seems we have to wait a bit before we do other things


# def write_psu_prim_firmware(file_name):
#
# 	start = time.time()
# 	print("Writing HEX firmware to Primary PIC...", end = '')
# 	data = parse_hexfile(file_name)
# 	for i in range (0, len(data)):
# 		dsp_masterport_write(register, data, size)
#
# 	finish = time.time()
# 	elapsed = finish - start
# 	print("Done in", int(elapsed * 1000), "mS")
# 	time.sleep(0.1)  # it seems we have to wait a bit before we do other things


def write_eeprom(registeraddress, writesize, data, dsp_address):
	start = time.time()
	print("Writing", writesize, "bytes in EEPROM at startaddress", registeraddress)
	Reg_H = (registeraddress >> 8) & 0xFF
	Reg_L = registeraddress & 0xFF
	if len(data) <= 4:
		DataBuffer = [0, 0, 0, 0]  # create databuffer ith at least 4 bytes in case user writes only 1 byte
		for i in range(len(data)):
			DataBuffer[i] = data[i]
	else:
		DataBuffer = data
	Payload = [0, 0, Reg_H, Reg_L]
	send_data_command(55, Payload, dsp_address)  # set page address
	send_data_command(64, DataBuffer, dsp_address)  # dump data in DSP
	Payload = [0, 0, 0, writesize]
	send_data_command(54, Payload, dsp_address)  # set pagesize
	time.sleep(0.005)
	finish = time.time()
	elapsed = finish - start
	print("Done in", int(elapsed * 1000), "mS")


def dsp_masterport_write(register, data, write_size, dsp_address):
	Reg_H = (register >> 8) & 0xFF
	Reg_L = register & 0xFF
	payload = [0, 0, Reg_H, Reg_L]
	send_data_command(55, payload, dsp_address)  # set page address
	send_data_command(64, data, dsp_address)  # dump data in DSP
	Payload = [0, 0, 0, write_size]
	send_data_command(54, Payload, dsp_address)


def dsp_reset(dsp_address):
	print("Restarting DSP and wait 3 sec or selfboot completion...")
	data = [0, 0]
	send_data_command(63632, data, dsp_address)
	data = [0, 1]
	send_data_command(63632, data, dsp_address)
	time.sleep(3)


def dsp_readreg(register_address, read_size, dsp_address):
	print("Reading DSP register at address", register_address, "  ", end='')
	Reg_H = (register_address >> 8) & 0xFF
	Reg_L = register_address & 0xFF
	data = [Reg_H, Reg_L]
	with SMBus(0) as bus:
		Write = i2c_msg.write(dsp_address, data)
		Read = i2c_msg.read(dsp_address, read_size)
		bus.i2c_rdwr(Write, Read)
		print("".join("\\x%02x" % i for i in Read))


def dsp_getstatus(dsp_address):
	print("Check DSP status... ", end='')
	data = [0xF4, 0x05]
	with SMBus(0) as bus:
		Write = i2c_msg.write(dsp_address, data)
		Read = i2c_msg.read(dsp_address, 2)
		bus.i2c_rdwr(Write, Read)
		Result = "".join("%02x" % i for i in Read)
		Result = int(Result, 16)
	if Result == 1 or Result == 3:  # 1 is normal, 3 is sleep(is also normal, but just waiting for the next audio sample)
		print('\033[92m' + "RUNNING" + '\033[0m')
		return 1
	else:
		print('\033[91m' + "NOT RUNNING" + '\033[0m')
		return 0


def dsp_checksoftware(required, dsp_address):
	print("Check SW Version running... ", end='')
	data = [0x60, 0x0D]
	with SMBus(0) as bus:
		Write = i2c_msg.write(dsp_address, data)
		Read = i2c_msg.read(dsp_address, 4)
		bus.i2c_rdwr(Write, Read)
		Result = "".join("%02x" % i for i in Read)
		Result = int(Result, 16)
		#  required = int(required, 16)
	print(Result)
	print("Check Matching... ", end='')
	if Result == required:
		print('\033[92m' + "MATCHED" + '\033[0m')
		return 0
	else:
		print('\033[91m' + "DOES NOT MATCH" + '\033[0m')
		return 1


def dsp_getcalibration(dsp_address):
	dsp_readreg(24586, 4, dsp_address)
	dsp_readreg(24587, 4, dsp_address)
	dsp_readreg(24588, 4, dsp_address)


def dsp_getreadback(dsp_address):
	dsp_readreg(24592, 4, dsp_address)  # outputlevel 1
	dsp_readreg(24593, 4, dsp_address)  # outputlevel 2
	dsp_readreg(24594, 4, dsp_address)  # outputlevel 3
	dsp_readreg(24595, 4, dsp_address)  # outputlevel 4

	dsp_readreg(24596, 4, dsp_address)  # user_1_lim_rms
	dsp_readreg(24597, 4, dsp_address)  # user_1_lim_peak
	dsp_readreg(24598, 4, dsp_address)  # speaker_1_lim_rms
	dsp_readreg(24599, 4, dsp_address)  # speaker_1_lim_peak
	dsp_readreg(24600, 4, dsp_address)  # amp_1_lim
	dsp_readreg(24601, 4, dsp_address)  # user_2_lim_rms
	dsp_readreg(24602, 4, dsp_address)  # user_2_lim_peak
	dsp_readreg(24603, 4, dsp_address)  # speaker_2_lim_rms
	dsp_readreg(24604, 4, dsp_address)  # speaker_2_lim_peak
	dsp_readreg(24605, 4, dsp_address)  # amp_2_lim
	dsp_readreg(24606, 4, dsp_address)  # user_3_lim_rms
	dsp_readreg(24607, 4, dsp_address)  # user_3_lim_peak
	dsp_readreg(24608, 4, dsp_address)  # speaker_3_lim_rms
	dsp_readreg(24609, 4, dsp_address)  # speaker_3_lim_peak
	dsp_readreg(24610, 4, dsp_address)  # amp_3_lim
	dsp_readreg(24611, 4, dsp_address)  # user_4_lim_rms
	dsp_readreg(24612, 4, dsp_address)  # user_4_lim_peak
	dsp_readreg(24613, 4, dsp_address)  # speaker_4_lim_rms
	dsp_readreg(24614, 4, dsp_address)  # speaker_4_lim_peak
	dsp_readreg(24615, 4, dsp_address)  # amp_4_lim


def parse_file_and_write(file_name, line_delay, dsp_address):
	codelist = open(file_name, "r")

	for line in codelist:
		line = line.rstrip("\n")  # remove CR
		RegData = line.split('		')  # Split in two parts before and anfer tab
		Reg = RegData[0]
		Data = RegData[1].split(',')  # split data string and put in array
		Data_Length = len(Data)
		if Reg == '      ':
			time.sleep(DSP_DELAY)
		else:
			Reg_int = int(Reg, 16)
			for i in range(Data_Length):
				Data[i] = int(Data[i], 16)
			send_data_command(Reg_int, Data, dsp_address)
			time.sleep(line_delay)

# def parse_hexfile(file_name, size):
# 	ih = IntelHex()
# 	ih.loadhex(file_name)
# 	ihdata = ih.todict()  # dump data to pydict
# 	return ihdata


def read_eeprom(register_address, read_size, dsp_address):
	print("Reading EEPROM at address", register_address)
	Reg_H = (register_address >> 8) & 0xFF
	Reg_L = register_address & 0xFF
	data = [0, 0, Reg_H, Reg_L]
	send_data_command(55, data, dsp_address)
	data = [0, 0, 0, read_size]
	send_data_command(57, data, dsp_address)
	time.sleep(0.2)
	with SMBus(0) as bus:
		Write = i2c_msg.write(dsp_address, [0, 64])
		Read = i2c_msg.read(dsp_address, read_size)
		bus.i2c_rdwr(Write, Read)
		print("".join("\\x%02x" % i for i in Read))
	time.sleep(0.1)


def dsp_update_eeprom(file_name, dsp_address):
	dsp_databridge("/home/orangepi/IpcSystemService/dspbridge_SMA2.code", dsp_address)
	dsp_masterport_eeprom_config("/home/orangepi/IpcSystemService/eeprom_masterport.code", dsp_address)
	write_eeprom_firmware(file_name, dsp_address)


# MAIN *********************************************************************************************************
full_cmd_arguments = sys.argv
argument_list = full_cmd_arguments[1:]
short_options = "hru:cl"						# semicolon after indicates getopt to require a value
long_options = ["help", "resetdsp=", "updatedsp=", "getcalibration=", "getreadback="]

try:
	arguments, values = getopt.getopt(argument_list, short_options, long_options)
except getopt.error as err:
	print(str(err))
	sys.exit(2)

for current_argument, current_value in arguments:
	if current_argument in ("-r", "--resetdsp"):
		print("Reset dsp n°" + str(current_value))
		if current_value == "1":
			dsp_reset(DSP_I2C_ADDRESS_1)
		elif current_value == "2":
			dsp_reset(DSP_I2C_ADDRESS_2)
		elif current_value == "3":
			dsp_reset(DSP_I2C_ADDRESS_3)
		elif current_value == "4":
			dsp_reset(DSP_I2C_ADDRESS_4)
		else:
			print("Wrong argument, DSP index between 1 and 4")

	elif current_argument in ("-h", "--help"):
		print(long_options)
		print("resetdsp=x, getcalibration=x, getreadback=x => x = DSP index between 1 and 4")
		print("updatedsp=x  => x=variantx with x between 1 and 4")

	elif current_argument in ("-u", "--updatedsp"):
		print("Check SW version requirement... %s" % SW_VERSION)
		running = dsp_getstatus(DSP_I2C_ADDRESS_1)
		need_update = 0

		if current_value == "debug":
			filename = input("Enter firmware filename: ")
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_1)
			dsp_reset(DSP_I2C_ADDRESS_1)
			dsp_getstatus(DSP_I2C_ADDRESS_1)
		elif current_value == "debug1504":
			filename = input("Enter firmware filename: ")
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_1)
			dsp_reset(DSP_I2C_ADDRESS_1)
			dsp_getstatus(DSP_I2C_ADDRESS_1)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_2)
			dsp_reset(DSP_I2C_ADDRESS_2)
			dsp_getstatus(DSP_I2C_ADDRESS_2)
		elif current_value == "debug3004":
			filename = input("Enter firmware filename: ")
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_1)
			dsp_reset(DSP_I2C_ADDRESS_1)
			dsp_getstatus(DSP_I2C_ADDRESS_1)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_2)
			dsp_reset(DSP_I2C_ADDRESS_2)
			dsp_getstatus(DSP_I2C_ADDRESS_2)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_3)
			dsp_reset(DSP_I2C_ADDRESS_3)
			dsp_getstatus(DSP_I2C_ADDRESS_3)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_4)
			dsp_reset(DSP_I2C_ADDRESS_4)
			dsp_getstatus(DSP_I2C_ADDRESS_4)
		elif current_value == "debug0716":
			filename = input("Enter firmware filename: ")
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_1)
			dsp_reset(DSP_I2C_ADDRESS_1)
			dsp_getstatus(DSP_I2C_ADDRESS_1)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_2)
			dsp_reset(DSP_I2C_ADDRESS_2)
			dsp_getstatus(DSP_I2C_ADDRESS_2)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_3)
			dsp_reset(DSP_I2C_ADDRESS_3)
			dsp_getstatus(DSP_I2C_ADDRESS_3)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_4)
			dsp_reset(DSP_I2C_ADDRESS_4)
			dsp_getstatus(DSP_I2C_ADDRESS_4)
		elif current_value == "debug7164":
			filename = input("Enter firmware filename: ")
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_1)
			dsp_reset(DSP_I2C_ADDRESS_1)
			dsp_getstatus(DSP_I2C_ADDRESS_1)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_2)
			dsp_reset(DSP_I2C_ADDRESS_2)
			dsp_getstatus(DSP_I2C_ADDRESS_2)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_3)
			dsp_reset(DSP_I2C_ADDRESS_3)
			dsp_getstatus(DSP_I2C_ADDRESS_3)
			time.sleep(2)
			dsp_update_eeprom(filename, DSP_I2C_ADDRESS_4)
			dsp_reset(DSP_I2C_ADDRESS_4)
			dsp_getstatus(DSP_I2C_ADDRESS_4)

		else:
			if running == 1 and (current_value == "variant1" or current_value == "variant2" or current_value == "variant5" or current_value == "variant6" or current_value == "variant9"):
				need_update = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
			elif current_value == "variant3":
				dsp_check1 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_1)
				dsp_check2 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_2)
				if (dsp_check1+dsp_check2>0):
					need_update=1
			elif current_value == "variant4":				
				dsp_check1 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_1)
				dsp_check2 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_2)
				dsp_check3 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_3)
				dsp_check4 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_4)
				if (dsp_check1+dsp_check2+dsp_check3+dsp_check4>0):
					need_update=1
			elif current_value == "variant7":
				dsp_check1 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_1)
				dsp_check2 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_2)
				dsp_check3 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_3)
				dsp_check4 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_4)
				if (dsp_check1+dsp_check2+dsp_check3+dsp_check4>0):
					need_update=1
			elif current_value == "variant8":
				dsp_check1 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_1)
				dsp_check2 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_2)
				dsp_check3 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_3)
				dsp_check4 = dsp_checksoftware(SW_VERSION,DSP_I2C_ADDRESS_4)
				if (dsp_check1+dsp_check2+dsp_check3+dsp_check4>0):
					need_update=1
			else:
				need_update = 1

			if need_update == 1 or running == 0:
				print("Starting update process...")
				if current_value == "variant1":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant1.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					if after_update == 1:				# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					elif after_update == 0:
						sys.exit(0)
				elif current_value == "variant2":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant2.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					if after_update == 1:				# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					else:
						sys.exit(0)
				elif current_value == "variant3":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant3.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update_dsp1 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant3.code", DSP_I2C_ADDRESS_2)
					dsp_reset(DSP_I2C_ADDRESS_2)
					dsp_getstatus(DSP_I2C_ADDRESS_2)
					after_update_dsp2 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_2)
					if after_update_dsp1 == 1 and after_update_dsp2 == 1:				# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					else:
						sys.exit(0)
				elif current_value == "variant4":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant4.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update_dsp1 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant4.code", DSP_I2C_ADDRESS_2)
					dsp_reset(DSP_I2C_ADDRESS_2)
					dsp_getstatus(DSP_I2C_ADDRESS_2)
					after_update_dsp2 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_2)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant4.code", DSP_I2C_ADDRESS_3)
					dsp_reset(DSP_I2C_ADDRESS_3)
					dsp_getstatus(DSP_I2C_ADDRESS_3)
					after_update_dsp3 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_3)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant4.code", DSP_I2C_ADDRESS_4)
					dsp_reset(DSP_I2C_ADDRESS_4)
					dsp_getstatus(DSP_I2C_ADDRESS_4)
					after_update_dsp4 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_4)
					if after_update_dsp1 == 1 or after_update_dsp2 == 1 or after_update_dsp3 == 1 or after_update_dsp4 == 1: 	# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					else:
						sys.exit(0)
				elif current_value == "variant5":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant5.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					if after_update == 1:				# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					elif after_update == 0:
						sys.exit(0)
				elif current_value == "variant6":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant6.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					if after_update == 1:				# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					elif after_update == 0:
						sys.exit(0)
				elif current_value == "variant7":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant7.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update_dsp1 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant7.code", DSP_I2C_ADDRESS_2)
					dsp_reset(DSP_I2C_ADDRESS_2)
					dsp_getstatus(DSP_I2C_ADDRESS_2)
					after_update_dsp2 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_2)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant7.code", DSP_I2C_ADDRESS_3)
					dsp_reset(DSP_I2C_ADDRESS_3)
					dsp_getstatus(DSP_I2C_ADDRESS_3)
					after_update_dsp3 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_3)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant7.code", DSP_I2C_ADDRESS_4)
					dsp_reset(DSP_I2C_ADDRESS_4)
					dsp_getstatus(DSP_I2C_ADDRESS_4)
					after_update_dsp4 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_4)
					if after_update_dsp1 == 1 or after_update_dsp2 == 1 or after_update_dsp3 == 1 or after_update_dsp4 == 1: 	# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					else:
						sys.exit(0)
				elif current_value == "variant8":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant2.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update_dsp1 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant2.code", DSP_I2C_ADDRESS_2)
					dsp_reset(DSP_I2C_ADDRESS_2)
					dsp_getstatus(DSP_I2C_ADDRESS_2)
					after_update_dsp2 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_2)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant2.code", DSP_I2C_ADDRESS_3)
					dsp_reset(DSP_I2C_ADDRESS_3)
					dsp_getstatus(DSP_I2C_ADDRESS_3)
					after_update_dsp3 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_3)
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant2.code", DSP_I2C_ADDRESS_4)
					dsp_reset(DSP_I2C_ADDRESS_4)
					dsp_getstatus(DSP_I2C_ADDRESS_4)
					after_update_dsp4 = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_4)
					if after_update_dsp1 == 1 or after_update_dsp2 == 1 or after_update_dsp3 == 1 or after_update_dsp4 == 1: 	# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					else:
						sys.exit(0)
				elif current_value == "variant9":
					dsp_update_eeprom("/home/orangepi/IpcSystemService/variant5.code", DSP_I2C_ADDRESS_1)
					dsp_reset(DSP_I2C_ADDRESS_1)
					dsp_getstatus(DSP_I2C_ADDRESS_1)
					after_update = dsp_checksoftware(SW_VERSION, DSP_I2C_ADDRESS_1)
					if after_update == 1:				# we check the running code again against SW_VERSION, if one there is still a mismatch
						sys.exit(1)				# exit error 1
					elif after_update == 0:
						sys.exit(0)
			else:
				print("No update required...")
				sys.exit(0)

	elif current_argument in ("-c", "--getcalibration"):
		print("Getcalibration from dsp n°" + str(current_value))
		if current_value == "1":
			dsp_getcalibration(DSP_I2C_ADDRESS_1)
		elif current_value == "2":
			dsp_getcalibration(DSP_I2C_ADDRESS_2)
		elif current_value == "3":
			dsp_getcalibration(DSP_I2C_ADDRESS_3)
		elif current_value == "4":
			dsp_getcalibration(DSP_I2C_ADDRESS_4)
		else:
			print("Wrong argument, DSP index between 1 and 4")

	elif current_argument in ("-l", "--getreadback"):
		print("Getreadback from dsp n°" + str(current_value))
		if current_value == "1":
			dsp_getreadback(DSP_I2C_ADDRESS_1)
		elif current_value == "2":
			dsp_getreadback(DSP_I2C_ADDRESS_2)
		elif current_value == "3":
			dsp_getreadback(DSP_I2C_ADDRESS_3)
		elif current_value == "4":
			dsp_getreadback(DSP_I2C_ADDRESS_4)
		else:
			print("Wrong argument, DSP index between 1 and 4")

# MAIN *******************************************************************************************************
