#!/bin/bash

UPDATE_CACHE="/tmp/ipcupdatecache"
UPDATE_SCRIPT="/tmp/ipcupdatecache/update_script.sh"
SERVICE_NAME="cp_update_script"
SCRIPT_PATH="/usr/local/bin/$SERVICE_NAME.sh"
SERVICE_FILE="/etc/systemd/system/$SERVICE_NAME.service"

echo "Creating script at $SCRIPT_PATH"
cp $UPDATE_SCRIPT $SCRIPT_PATH

chmod +x $SCRIPT_PATH

echo "Creating systemd service at $SERVICE_FILE"
cat <<EOF > $SERVICE_FILE
[Unit]
Description=One-time service
After=network.target

[Service]
Type=oneshot
ExecStart=$SCRIPT_PATH
RemainAfterExit=true

[Install]
WantedBy=multi-user.target
EOF

echo "Reloading systemd daemon"
systemctl daemon-reload

# Start the service
echo "Starting the service $SERVICE_NAME"
systemctl start $SERVICE_NAME.service