#!/bin/bash

if [ "$EUID" -ne 0 ]; then
  echo "Must run as root."
  exit 1
fi

IPC_ROOT="/home/orangepi"
WEBUI_ROOT="/var/www/html"
UPDATE_CACHE="/tmp/ipcupdatecache"
UPDATE_LOG="/var/log/ipcupdate.log"
OEMFILE="/home/orangepi/IpcSystemService/oem.json"
SESSIONFILE="/home/orangepi/IpcSystemService/session.json"
ALLSPEAKERFILE="/home/orangepi/IpcSystemService/all_speaker_presets.json"
READBACKFILE="/tmp/ipcreadback"

CONFIG_FILE="/home/orangepi/IpcSystemService/data.json"
CONFIG_FILE_1="/home/orangepi/IpcSystemService/data_1.json"

GLOBAL_PRESETS_FILE="/home/orangepi/IpcSystemService/global_presets.json"
GLOBAL_PRESETS_FILE_1="/home/orangepi/IpcSystemService/global_presets_1.json"

SPEAKER_PRESETS_FILE="/home/orangepi/IpcSystemService/speaker_presets.json"
SPEAKER_PRESETS_FILE_1="/home/orangepi/IpcSystemService/speaker_presets_1.json"

ALL_SPEAKER_PRESETS_FILE="/home/orangepi/IpcSystemService/all_speaker_presets.json"
ALL_SPEAKER_PRESETS_FILE_1="/home/orangepi/IpcSystemService/all_speaker_presets_1.json"


var1="variant1.code"
var2="variant2.code"
var3="variant3.code"
var4="variant4.code"
var5="variant5.code"
var6="variant6.code"
var7="variant7.code"
var8="variant4.code"
var9="variant9.code"

value=$(<"$IPC_ROOT/IpcSystemService/dsp_variant.txt")

echo '-----------------------------------------------------------------------' >> "$UPDATE_LOG"
echo "$(date)" >> "$UPDATE_LOG"
echo '-----------------------------------------------------------------------' >> "$UPDATE_LOG"


#####################################################################################
# Copy saved files
#####################################################################################

echo "Creating dual backup files :" >> "$UPDATE_LOG"

if [ ! -f "$CONFIG_FILE_1" ]; then
    echo "Creating dual backup Config File" >> "$UPDATE_LOG"
    cp -p $CONFIG_FILE $CONFIG_FILE_1
else
    echo "Dual backup Config File already exist !" >> "$UPDATE_LOG"
fi

if [ ! -f "$GLOBAL_PRESETS_FILE_1" ]; then
    echo "Creating dual backup Global Preset File" >> "$UPDATE_LOG"
    cp -p $GLOBAL_PRESETS_FILE $GLOBAL_PRESETS_FILE_1
else
    echo "Dual backup Global Preset File already exist !" >> "$UPDATE_LOG"
fi

if [ ! -f "$SPEAKER_PRESETS_FILE_1" ]; then
    echo "Creating dual backup Speaker Preset File" >> "$UPDATE_LOG"
    cp -p $SPEAKER_PRESETS_FILE $SPEAKER_PRESETS_FILE_1
else
    echo "Dual backup Speaker Preset File already exist !" >> "$UPDATE_LOG"
fi

if [ ! -f "$ALL_SPEAKER_PRESETS_FILE_1" ]; then
    echo "Creating dual backup All Speaker Preset File" >> "$UPDATE_LOG"
    cp -p $ALL_SPEAKER_PRESETS_FILE $ALL_SPEAKER_PRESETS_FILE_1
else
    echo "Dual backup All Speaker Preset File already exist !" >> "$UPDATE_LOG"
fi

sync

#####################################################################################
# Stop all IPC servces
#####################################################################################
su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"=> 1/6 Stop services\""

echo "Stopping givalocalapp..." >> "$UPDATE_LOG"
# systemctl kill --signal=SIGKILL givalocalapp.service
systemctl kill --signal=SIGKILL givalocalapp.service

# sudo service givalocalapp.service stop
sleep 3

echo "Stopping givawebsocket..." >> "$UPDATE_LOG"
# systemctl kill --signal=SIGKILL givawebsocket.service
systemctl kill --signal=SIGKILL givawebsocket.service

# sudo service givawebsocket.service stop
sleep 3

echo "Stopping givaipc..." >> "$UPDATE_LOG"
# systemctl kill --signal=SIGKILL givaipc.service
systemctl kill --signal=SIGKILL givaipc.service

# sudo service givaipc.service stop
sleep 3

# disable dhcpcd service
sudo systemctl disable dhcpcd.service

sync

#####################################################################################
# Clean up the content of existing folders
#####################################################################################
su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"=> 2/6 Cleaning files\""

echo "Cleaning existing folders..." >> "$UPDATE_LOG"
# Assuming we don't update fonts and images of the local app
if [ -d "$UPDATE_CACHE/ApexCloud/" ]
then
    echo "Cleaning /ApexCloud/..." >> "$UPDATE_LOG"
    rm -f "$IPC_ROOT"/ApexCloud/*.sh
fi

if [ -d "$UPDATE_CACHE/Giva-IPC-FrontUI/" ]
then
    echo "Cleaning /Giva-IPC-FrontUI/..." >> "$UPDATE_LOG"
    rm -f "$IPC_ROOT"/Giva-IPC-FrontUI/*.py

    if [ -d "$IPC_ROOT/Giva-IPC-FrontUI/__pycache__/" ]
    then
        echo "Cleaning /Giva-IPC-FrontUI/__pycache__" >> "$UPDATE_LOG"
        rm -f "$IPC_ROOT"/Giva-IPC-FrontUI/__pycache__/*.pyc
    fi

    if [ -d "$IPC_ROOT/Giva-IPC-FrontUI/fonts/" ]
    then
        echo "Cleaning Giva IPC FrontUI / fonts ..." >> "$UPDATE_LOG"
        rm -f -r "$IPC_ROOT"/Giva-IPC-FrontUI/fonts
    fi
    if [ -d "$IPC_ROOT/Giva-IPC-FrontUI/images/" ]
    then
        echo "Cleaning Giva IPC FrontUI / images ..." >> "$UPDATE_LOG"
        rm -f -r "$IPC_ROOT"/Giva-IPC-FrontUI/images
    fi
fi

if [ -d "$UPDATE_CACHE/IpcSystemService/" ]
then
    echo "Cleaning /IPCSystemService/..." >> "$UPDATE_LOG"
    rm -f "$IPC_ROOT"/IpcSystemService/*.py
    rm -f "$IPC_ROOT"/IpcSystemService/*.code
fi

if [ -d "$IPC_ROOT/IpcSystemService/FactorySettings/" ]
then
    echo "Cleaning /IPCSystemService/FactorySettings" >> "$UPDATE_LOG"
    rm -r "$IPC_ROOT"/IPCSystemService/FactorySettings
fi

if [ -d "$IPC_ROOT/IpcSystemService/__pycache__/" ]
then
    echo "Cleaning /IPCSystemService/__pycache__" >> "$UPDATE_LOG"
    rm -f "$IPC_ROOT"/IPCSystemService/__pycache__/*.pyc
fi

if [ -d "$UPDATE_CACHE/WebUI/" ]
then
    echo "Cleaning /html/..." >> "$UPDATE_LOG"
    rm -r -f "$WEBUI_ROOT"/*
fi


echo "Cleaning ipc_readback temp file" >> "$UPDATE_LOG"
rm "$READBACKFILE"

# Do not delete .json configuration files of the service

#####################################################################################
# Copy over new files
#####################################################################################
su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"=> 3/6 Copying new files\""
echo "Copying new files..." >> "$UPDATE_LOG"
if [ -d "$UPDATE_CACHE/ApexCloud/" ]
then
    echo "Copy Giva IPC FrontUI..." >> "$UPDATE_LOG"
    cp -f "$UPDATE_CACHE"/ApexCloud/*.sh "$IPC_ROOT"/ApexCloud
    chmod +x -R  "$IPC_ROOT"/ApexCloud/
fi

if [ -d "$UPDATE_CACHE/Giva-IPC-FrontUI/" ]
then
    echo "Copy Giva IPC FrontUI..." >> "$UPDATE_LOG"
    cp -f "$UPDATE_CACHE"/Giva-IPC-FrontUI/*.py "$IPC_ROOT"/Giva-IPC-FrontUI
    if [ -d "$UPDATE_CACHE/Giva-IPC-FrontUI/fonts" ]
    then
        echo "Copy Giva IPC FrontUI / fonts ..." >> "$UPDATE_LOG"
        cp -R -u -p "$UPDATE_CACHE"/Giva-IPC-FrontUI/fonts "$IPC_ROOT"/Giva-IPC-FrontUI/fonts
    fi
    if [ -d "$UPDATE_CACHE/Giva-IPC-FrontUI/images" ]
    then
        echo "Copy Giva IPC FrontUI / images ..." >> "$UPDATE_LOG"
        cp -R -u -p "$UPDATE_CACHE"/Giva-IPC-FrontUI/images "$IPC_ROOT"/Giva-IPC-FrontUI/images
    fi
fi

if [ -d "$UPDATE_CACHE/IpcSystemService/" ]
then
    echo "Copy Giva IPC System Service..." >> "$UPDATE_LOG"
    cp -f "$UPDATE_CACHE"/IpcSystemService/*.py "$IPC_ROOT"/IpcSystemService
    cp -f "$UPDATE_CACHE"/IpcSystemService/*.code "$IPC_ROOT"/IpcSystemService

    mkdir -p "$IPC_ROOT/IpcSystemService/FactorySettings"
    cp -r "$UPDATE_CACHE/IpcSystemService/FactorySettings/"* "$IPC_ROOT/IpcSystemService/FactorySettings/"

    if [ -f "$OEMFILE" ]; then
        echo "$OEMFILE exists." >> "$UPDATE_LOG"
    else
        echo "$OEMFILE does not exist." >> "$UPDATE_LOG"
        cp -f "$UPDATE_CACHE"/IpcSystemService/oem.json "$IPC_ROOT"/IpcSystemService
    fi

    if [ -f "$SESSIONFILE" ]; then
        echo "$SESSIONFILE exists." >> "$UPDATE_LOG"
    else
        echo "$SESSIONFILE does not exist." >> "$UPDATE_LOG"
        cp -f "$UPDATE_CACHE"/IpcSystemService/session.json "$IPC_ROOT"/IpcSystemService
    fi

    if [ -f "$ALLSPEAKERFILE" ]; then
        echo "$ALLSPEAKERFILE exists." >> "$UPDATE_LOG"
    else
        echo "$ALLSPEAKERFILE does not exist." >> "$UPDATE_LOG"
        cp -f "$UPDATE_CACHE"/IpcSystemService/all_speaker_presets.json "$IPC_ROOT"/IpcSystemService
    fi
fi

if [ -d "$UPDATE_CACHE/WebUI/" ]
then
    echo "Copy Giva IPC WebUI..." >> "$UPDATE_LOG"
    cp -rf "$UPDATE_CACHE"/WebUI/* "$WEBUI_ROOT"/
fi

# Do not overwrite .json files of the service in order to preserve existing config.
# Fix up ownership

echo "Sync files..." >> "$UPDATE_LOG"
sync

su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"=> 4/6 Files copied\""

sleep 4

su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"=> 5/6 Updating DSP(s)\""

echo "Amplifier variant is $value" >> "$UPDATE_LOG"

if [[ "$value" =~ $var1 ]]
then
    echo "Amplifier is variant1..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant1
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant1
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var2 ]]
then
    echo "Amplifier is variant2..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant2
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant2
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var3 ]]
then
    echo "Amplifier is variant3..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant3
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant3
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var4 ]]
then
    echo "Amplifier is variant4..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant4
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant4
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var5 ]]
then
    echo "Amplifier is variant5..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant5
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant5
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var6 ]]
then
    echo "Amplifier is variant6..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant6
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant6
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var7 ]]
then
    echo "Amplifier is variant7..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant7
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant7
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var8 ]]
then
    echo "Amplifier is variant8..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant8
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant8
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
elif [[ "$value" =~ $var9 ]]
then
    echo "Amplifier is variant9..." >> "$UPDATE_LOG"
    python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant9
    ret=$?
    if  [ $ret -ne 0 ]; then
        python3 /home/orangepi/IpcSystemService/ipc_sma_tools.py --updatedsp=variant9
    fi
        echo "DSP updated successfully" >> "$UPDATE_LOG"
else
    echo "No known variant detected" >> "$UPDATE_LOG"
fi

sleep 2

su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"=> 6/6 DSPs updated\""

sleep 4

su -l orangepi -s /bin/bash -c "exec python3 /home/orangepi/Giva-IPC-FrontUI/Display_status.py print \"Please RESTART\""

echo "Update complete !" >> "$UPDATE_LOG"

exit 0
